/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette.internal.ui;

import com.rsi.idldt.core.dom.IIDLDOMManager;
import com.rsi.idldt.core.dom.IIDLKeyword;
import com.rsi.idldt.core.dom.IIDLRoutine;
import com.rsi.idldt.core.internal.dom.IDLDOMManager;
import com.rsi.idldt.toolpalette.ActionSig;
import com.rsi.idldt.toolpalette.IDLVisTool;
import com.rsi.idldt.toolpalette.ToolPalettePlugin;
import com.rsi.idldt.toolpalette.internal.ui.FieldWithAssist;
import com.rsi.idldt.toolpalette.internal.ui.LabelUtils;
import com.rsi.idldt.toolpalette.internal.ui.Messages;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ActionBarEditDialog
extends Dialog {
    protected static final String HELP_ID = "com.rsi.idldt.toolpalette.action_edit_dialog_help";
    public final int MASK_PROC_NAME = 0;
    public final int MASK_POSITIONAL_PARMS = 1;
    public final int MASK_STATIC_PARMS = 2;
    public final int MASK_DESC = 3;
    public final int MASK_TITLE = 4;
    public final String MSG_NORMAL_TEXT = Messages.ActionBarEditDialog_DefineActionData;
    public final String MSG_INVALID_DATA_TEXT = Messages.ActionBarEditDialog_InvalidData;
    public final String MSG_REQUIRED_DATA_TEXT = Messages.ActionBarEditDialog_RequiredData;
    protected Image m_errorIcon = null;
    protected Image m_titleImage = null;
    private String m_additionalErrorNote = "";
    protected boolean m_isForNewBar = false;
    protected BitSet m_validator = new BitSet(6);
    protected BitSet m_receivedData = new BitSet(6);
    static final String CD_FIELD_NAME = "fieldName";
    static final String PROC_NAME = "procName";
    static final String POSITIONAL_PARMS = "positionalParms";
    static final String STATIC_PARMS = "staticParms";
    static final String DESC = "desc";
    static final String TITLE = "title";
    protected ActionSig m_newSig;
    protected String m_dialogTitle;
    protected Label m_messageLabel;
    protected Label m_messageImageLabel;
    protected Text m_procedureNameText;
    protected Label m_procedureNameLabel;
    protected Text m_positionalArgText;
    protected Label m_positionalArgLabel;
    protected Text m_staticArgText;
    protected Label m_staticArgLabel;
    protected Text m_descText;
    protected Label m_descLabel;
    protected Text m_titleText;
    protected Label m_titleLabel;
    protected ActionSig m_actionSig;
    protected Button m_okButton;
    protected IDLVisTool m_visTool;

    public ActionBarEditDialog(Shell parentShell, String dialogTitle, IDLVisTool visTool, ActionSig actionsig, boolean bEditingNewBar) {
        super(parentShell);
        this.m_dialogTitle = dialogTitle;
        this.m_actionSig = actionsig;
        this.m_visTool = visTool;
        this.m_isForNewBar = bEditingNewBar;
        if (bEditingNewBar) {
            this.m_validator.set(0, 5, false);
            this.m_receivedData.set(0, 5, false);
            this.m_validator.set(0, true);
            this.m_receivedData.set(0, true);
            this.m_validator.set(4, true);
            this.m_receivedData.set(4, true);
        }
    }

    protected void disposeImages() {
        if (this.m_errorIcon != null) {
            this.m_errorIcon.dispose();
        }
        if (this.m_titleImage != null) {
            this.m_titleImage.dispose();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.m_dialogTitle != null) {
            shell.setText(this.m_dialogTitle);
        }
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ActionBarEditDialog.this.disposeImages();
            }
        });
    }

    protected boolean validIDLProcName(String var) {
        String addErrNote1 = "\n" + Messages.ActionBarEditDialog_NotAValidProcedureName;
        this.removeErrNote(addErrNote1);
        String addErrNote2 = "\n" + Messages.ActionBarEditDialog_UnknownIdlProcedure;
        this.removeErrNote(addErrNote2);
        char[] chars = var.toCharArray();
        if (chars == null || chars.length == 0) {
            this.m_additionalErrorNote = String.valueOf(this.m_additionalErrorNote) + addErrNote1;
            return false;
        }
        int i = 0;
        while (i < chars.length) {
            boolean valid;
            char c = chars[i];
            if (i == 0) {
                valid = Character.isLetter(c) || c == '_';
            } else {
                boolean bl = valid = Character.isLetter(c) || Character.isDigit(c) || c == '$' || c == '_';
            }
            if (!valid) {
                this.m_additionalErrorNote = String.valueOf(this.m_additionalErrorNote) + addErrNote1;
                return false;
            }
            ++i;
        }
        if (!this.validateProcNameWithDOM(var)) {
            this.m_additionalErrorNote = String.valueOf(this.m_additionalErrorNote) + addErrNote2;
            return false;
        }
        return true;
    }

    protected boolean validateProcNameWithDOM(String procName) {
        IIDLDOMManager dm = IDLDOMManager.getActiveManager();
        if (dm == null) {
            return true;
        }
        int flags = 117;
        IIDLRoutine[] routines = dm.findRoutines(procName, flags);
        boolean valid = routines != null && routines.length > 0;
        return valid;
    }

    protected boolean validIDLVariableName(String var) {
        char[] chars = var.toCharArray();
        if (chars == null || chars.length == 0) {
            return false;
        }
        int i = 0;
        while (i < chars.length) {
            boolean valid;
            char c = chars[i];
            if (i == 0) {
                valid = Character.isLetter(c) || c == '_';
            } else {
                boolean bl = valid = Character.isLetter(c) || Character.isDigit(c) || c == '$' || c == '_';
            }
            if (!valid) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean validPositionalParams(String[] params) {
        boolean valid = true;
        if (params == null) {
            return true;
        }
        int i = 0;
        while (i < params.length) {
            String p = params[i].trim();
            valid = this.validIDLVariableName(p);
            if (!valid || !(valid = this.isUniqueInTheList(p, params))) break;
            ++i;
        }
        return valid;
    }

    protected boolean isUniqueInTheList(String inputParm, String[] params) {
        int count = 0;
        int i = 0;
        while (i < params.length) {
            if (inputParm.equalsIgnoreCase(params[i])) {
                ++count;
            }
            if (count > 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean validStaticParameters() {
        boolean valid = true;
        return valid;
    }

    protected boolean validDescription() {
        boolean valid = true;
        return valid;
    }

    protected boolean validTitle(String title) {
        String addErrNote = "\n" + Messages.ActionBarEditDialog_ActionTitleIsAlreadyUsedChooseAnother;
        this.removeErrNote(addErrNote);
        if (title == null || title.trim().length() == 0) {
            return false;
        }
        ActionSig sig = this.m_visTool.getActionSig(title);
        if (this.m_isForNewBar || !this.m_isForNewBar && this.m_actionSig.isSystemDefined()) {
            if (sig != null) {
                this.m_additionalErrorNote = String.valueOf(this.m_additionalErrorNote) + addErrNote;
                return false;
            }
        } else if (sig != null && sig != this.m_actionSig) {
            return false;
        }
        return true;
    }

    protected void validateInput(Text text) {
        String fieldName = (String)text.getData(CD_FIELD_NAME);
        if (fieldName.equalsIgnoreCase(PROC_NAME)) {
            String value = text.getText().trim();
            this.m_validator.set(0, !this.validIDLProcName(value));
            this.m_receivedData.set(0, false);
        } else if (fieldName.equalsIgnoreCase(POSITIONAL_PARMS)) {
            String[] params = text.getText().trim().split(",");
            if (params.length == 1 && params[0].trim().length() == 0) {
                params = null;
            }
            this.m_validator.set(1, !this.validPositionalParams(params));
            this.m_receivedData.set(1, false);
        } else if (fieldName.equalsIgnoreCase(STATIC_PARMS)) {
            this.m_validator.set(2, !this.validStaticParameters());
        } else if (fieldName.equalsIgnoreCase(DESC)) {
            this.m_validator.set(3, !this.validDescription());
            this.m_receivedData.set(3, false);
        } else if (fieldName.equalsIgnoreCase(TITLE)) {
            String value = text.getText().trim();
            this.m_validator.set(4, !this.validTitle(value));
            this.m_receivedData.set(4, false);
        }
        this.setOkayButtonEnablement();
    }

    protected Image getErrorIcon() {
        if (this.m_errorIcon == null) {
            URL url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/stop.png"), null);
            this.m_errorIcon = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return this.m_errorIcon;
    }

    protected void updateMessage(boolean bAllGood) {
        this.m_messageLabel.setForeground(this.m_messageLabel.getDisplay().getSystemColor(2));
        if (bAllGood) {
            this.m_messageLabel.setText(this.MSG_NORMAL_TEXT);
            this.m_messageImageLabel.setImage(null);
        } else if (this.m_isForNewBar && !this.m_receivedData.isEmpty()) {
            this.m_messageLabel.setText(this.MSG_REQUIRED_DATA_TEXT);
            this.m_messageImageLabel.setImage(null);
            this.m_messageLabel.setForeground(this.m_messageLabel.getDisplay().getSystemColor(3));
        } else {
            if (this.m_additionalErrorNote.length() != 0) {
                this.m_messageLabel.setText(String.valueOf(this.MSG_INVALID_DATA_TEXT) + this.m_additionalErrorNote);
            } else {
                this.m_messageLabel.setText(this.MSG_INVALID_DATA_TEXT);
            }
            this.m_messageImageLabel.setImage(this.getErrorIcon());
        }
        this.m_messageLabel.getParent().getParent().getParent().layout(true);
    }

    protected void setOkayButtonEnablement() {
        Color normal = this.m_procedureNameLabel.getDisplay().getSystemColor(2);
        Color red = this.m_procedureNameLabel.getDisplay().getSystemColor(3);
        this.m_procedureNameLabel.setForeground(normal);
        this.m_positionalArgLabel.setForeground(normal);
        this.m_staticArgLabel.setForeground(normal);
        this.m_descLabel.setForeground(normal);
        this.m_titleLabel.setForeground(normal);
        if (this.m_okButton == null || this.m_okButton.isDisposed()) {
            return;
        }
        if (this.m_validator.isEmpty()) {
            this.m_okButton.setEnabled(true);
            this.updateMessage(true);
        } else {
            this.m_okButton.setEnabled(false);
            this.updateMessage(false);
            if (this.m_validator.get(0)) {
                this.m_procedureNameLabel.setForeground(red);
            }
            if (this.m_validator.get(1)) {
                this.m_positionalArgLabel.setForeground(red);
            }
            if (this.m_validator.get(2)) {
                this.m_staticArgLabel.setForeground(red);
            }
            if (this.m_validator.get(3)) {
                this.m_descLabel.setForeground(red);
            }
            if (this.m_validator.get(4)) {
                this.m_titleLabel.setForeground(red);
            }
        }
    }

    protected void addValidateModifier(Text text) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ActionBarEditDialog.this.validateInput((Text)e.widget);
            }
        });
    }

    protected void createTitleArea(Composite parent) {
        Composite titleAreaComposite = new Composite(parent, 2048);
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        titleAreaComposite.setLayoutData((Object)gd);
        titleAreaComposite.setBackground(parent.getDisplay().getSystemColor(1));
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 1;
        titleAreaComposite.setLayout((Layout)gl);
        titleAreaComposite.setBackgroundMode(2);
        Composite c = new Composite(titleAreaComposite, 0);
        c.setBackgroundMode(2);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        c.setLayout((Layout)gl);
        Label l = new Label(c, 0);
        l.setText(this.m_dialogTitle);
        LabelUtils.makeLabelBold(l);
        LabelUtils.makeLabelHeightChange(l, 2);
        gd = new GridData();
        gd.horizontalIndent = 10;
        gd.verticalIndent = 3;
        l.setLayoutData((Object)gd);
        Composite msgComposite = new Composite(c, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        msgComposite.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData();
        gd.horizontalIndent = 10;
        gd.verticalIndent = 0;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        msgComposite.setLayoutData((Object)gd);
        this.m_messageImageLabel = new Label(msgComposite, 0);
        this.m_messageImageLabel.setImage(null);
        this.m_messageLabel = new Label(msgComposite, 0);
        l = new Label(titleAreaComposite, 0);
        URL url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/invocation_bar.gif"), null);
        this.m_titleImage = ImageDescriptor.createFromURL((URL)url).createImage();
        l.setImage(this.m_titleImage);
        l.setLayoutData((Object)new GridData(131072, 0x1000000, true, true, 1, 2));
    }

    protected Control createDialogArea(Composite parent) {
        MyComposite composite = new MyComposite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        composite.setLayoutData(new GridData(1808));
        this.createTitleArea(composite);
        this.m_procedureNameLabel = new Label((Composite)composite, 0);
        this.m_procedureNameLabel.setText(Messages.ActionBarEditDialog_IDLProcedure);
        this.m_procedureNameText = new Text((Composite)composite, 2048);
        this.addValidateModifier(this.m_procedureNameText);
        this.m_procedureNameText.setToolTipText(Messages.ActionBarEditDialog_IDLProcedureTooltipText);
        this.m_procedureNameText.setData(CD_FIELD_NAME, (Object)PROC_NAME);
        GridData gd = new GridData(4, 0x1000000, true, false, 1, 1);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        this.m_procedureNameText.setLayoutData((Object)gd);
        new FieldWithAssist(this.m_procedureNameText);
        this.m_positionalArgLabel = new Label((Composite)composite, 0);
        this.m_positionalArgLabel.setText(Messages.ActionBarEditDialog_PositionalArguments);
        this.m_positionalArgText = new Text((Composite)composite, 2048);
        this.m_positionalArgText.setData(CD_FIELD_NAME, (Object)POSITIONAL_PARMS);
        this.addValidateModifier(this.m_positionalArgText);
        this.m_positionalArgText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.m_positionalArgText.setToolTipText(Messages.ActionBarEditDialog_PositionalArgumentsTooltipText);
        this.m_staticArgLabel = new Label((Composite)composite, 0);
        this.m_staticArgLabel.setText(Messages.ActionBarEditDialog_Keywords);
        this.m_staticArgText = new Text((Composite)composite, 2048);
        this.addValidateModifier(this.m_staticArgText);
        this.m_staticArgText.setData(CD_FIELD_NAME, (Object)STATIC_PARMS);
        this.m_staticArgText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.m_staticArgText.setToolTipText(Messages.ActionBarEditDialog_KeywordsTooltipText);
        new FieldWithAssist(this.m_staticArgText, this.m_procedureNameText, this.m_positionalArgText);
        this.m_titleLabel = new Label((Composite)composite, 0);
        this.m_titleLabel.setText(Messages.ActionBarEditDialog_Title);
        this.m_titleText = new Text((Composite)composite, 2048);
        this.addValidateModifier(this.m_titleText);
        this.m_titleText.setData(CD_FIELD_NAME, (Object)TITLE);
        this.m_titleText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.m_titleText.setToolTipText(Messages.ActionBarEditDialog_TitleTooltipText);
        this.m_descLabel = new Label((Composite)composite, 0);
        this.m_descLabel.setText(Messages.ActionBarEditDialog_Description);
        this.m_descText = new Text((Composite)composite, 2048);
        this.addValidateModifier(this.m_descText);
        this.m_descText.setData(CD_FIELD_NAME, (Object)DESC);
        this.m_descText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.m_descText.setToolTipText(Messages.ActionBarEditDialog_DescriptionTooltipText);
        if (this.m_actionSig != null) {
            this.m_procedureNameText.setText(this.m_actionSig.m_procName);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.m_actionSig.m_argNames.size()) {
                String arg = this.m_actionSig.m_argNames.get(i);
                sb.append(arg);
                if (i + 1 < this.m_actionSig.m_argNames.size()) {
                    sb.append(", ");
                }
                ++i;
            }
            this.m_positionalArgText.setText(sb.toString());
            if (this.m_actionSig.m_staticArgs != null) {
                this.m_staticArgText.setText(this.m_actionSig.m_staticArgs);
            }
            if (this.m_actionSig.m_desc != null) {
                this.m_descText.setText(this.m_actionSig.m_desc);
            }
            if (this.m_actionSig.m_title != null) {
                if (this.m_actionSig.isSystemDefined() && !this.m_isForNewBar) {
                    this.m_titleText.setText(this.m_visTool.generateUniqueActionTitle(this.m_actionSig.m_title));
                } else {
                    this.m_titleText.setText(this.m_actionSig.m_title);
                }
            }
            this.validateInput(this.m_titleText);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, HELP_ID);
        ActionBarEditDialog.applyDialogFont((Control)composite);
        this.setOkayButtonEnablement();
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    public ActionSig getNewActionSig() {
        return this.m_newSig;
    }

    protected void removeErrNote(String errNote) {
        String newNote;
        int idx = this.m_additionalErrorNote.indexOf(errNote);
        if (idx == -1) {
            return;
        }
        if (idx > 0) {
            newNote = this.m_additionalErrorNote.substring(0, idx);
            newNote = String.valueOf(newNote) + this.m_additionalErrorNote.substring(idx + errNote.length());
        } else {
            newNote = this.m_additionalErrorNote.substring(idx + errNote.length());
        }
        this.m_additionalErrorNote = newNote;
    }

    protected void okPressed() {
        this.setReturnCode(0);
        this.m_newSig = this.m_actionSig != null ? new ActionSig(this.m_actionSig.m_sigSystemOrUser) : new ActionSig(1);
        this.m_newSig.m_procName = this.m_procedureNameText.getText().trim().toUpperCase();
        this.m_newSig.m_overplotCmd = this.getOverplotCommand(this.m_newSig.m_procName);
        if (this.m_newSig.m_overplotCmd != null) {
            this.m_newSig.m_overplotCmd = this.m_newSig.m_overplotCmd.trim().toUpperCase();
        }
        this.m_newSig.m_argNames = new ArrayList();
        String[] args = this.m_positionalArgText.getText().trim().split(",");
        int i = 0;
        while (i < args.length) {
            if (args[i].trim().length() > 0) {
                this.m_newSig.m_argNames.add(args[i].trim().toUpperCase());
            }
            ++i;
        }
        this.m_newSig.m_staticArgs = this.removeLeadingAndTrailingCommas(this.m_staticArgText.getText().trim());
        this.m_newSig.m_desc = this.m_descText.getText().trim();
        this.m_newSig.m_title = this.m_titleText.getText().trim();
        this.close();
    }

    protected String removeLeadingAndTrailingCommas(String input) {
        try {
            if (input == null) {
                return input;
            }
            int i = 0;
            i = 0;
            while (i < input.length()) {
                if (input.charAt(i) != ',') break;
                ++i;
            }
            int j = 0;
            j = input.length() - 1;
            while (j > i) {
                if (input.charAt(j) != ',') break;
                --j;
            }
            String newString = input.substring(i, j + 1);
            return newString;
        }
        catch (Exception exception) {
            return input;
        }
    }

    private String getOverplotCommand(String procName) {
        IIDLRoutine routine = this.findRoutineInDOM(procName);
        if (routine == null) {
            return null;
        }
        IIDLKeyword[] keywords = routine.getKeywords();
        if (keywords == null) {
            return null;
        }
        IIDLKeyword[] iIDLKeywordArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            IIDLKeyword keyword = iIDLKeywordArray[n2];
            if (keyword.getElementName().toUpperCase().equals("OVERPLOT")) {
                return String.valueOf(procName) + ", " + "/OVERPLOT";
            }
            ++n2;
        }
        return null;
    }

    protected IIDLRoutine findRoutineInDOM(String procName) {
        if (procName == null || procName.length() == 0) {
            return null;
        }
        IIDLDOMManager dm = IDLDOMManager.getActiveManager();
        if (dm == null) {
            return null;
        }
        int flags = 117;
        IIDLRoutine[] routines = dm.findRoutines(procName, flags);
        if (routines == null || routines.length == 0) {
            return null;
        }
        IIDLRoutine routine = null;
        if (routines.length > 1) {
            int i = 0;
            while (i < routines.length) {
                IIDLRoutine r = routines[i];
                if (r.getFilename() == null) {
                    routine = r;
                    break;
                }
                ++i;
            }
        }
        if (routine == null) {
            routine = routines[0];
        }
        return routine;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.m_okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.setOkayButtonEnablement();
    }

    protected Control createButtonBar(Composite parent) {
        Composite compTop = new Composite(parent, 0);
        compTop.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        compTop.setLayout((Layout)layout);
        compTop.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Image helpImage = JFaceResources.getImage((String)"dialog_help_image");
        if (helpImage != null) {
            this.createHelpImageButton(compTop, helpImage);
        }
        Composite composite = new Composite(compTop, 0);
        layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    private ToolBar createHelpImageButton(Composite parent, Image image) {
        ToolBar toolBar = new ToolBar(parent, 0x880000);
        toolBar.setLayoutData((Object)new GridData(32));
        final Cursor cursor = new Cursor((Device)parent.getDisplay(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                cursor.dispose();
            }
        });
        ToolItem item = new ToolItem(toolBar, 0);
        item.setImage(image);
        item.setToolTipText(JFaceResources.getString((String)"helpToolTip"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionBarEditDialog.this.helpPressed();
            }
        });
        return toolBar;
    }

    void helpPressed() {
        if (this.getShell() != null) {
            Control c = this.getShell().getDisplay().getFocusControl();
            while (c != null) {
                if (c.isListening(28)) {
                    c.notifyListeners(28, new Event());
                    break;
                }
                c = c.getParent();
            }
        }
    }

    protected class MyComposite
    extends Composite {
        public MyComposite(Composite parent, int style) {
            super(parent, style);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            Point size = super.computeSize(wHint, hHint, changed);
            double eightyPctOfDisplayWidth = (double)Toolkit.getDefaultToolkit().getScreenSize().width * 0.8;
            if ((double)size.x > eightyPctOfDisplayWidth) {
                size.x = (int)eightyPctOfDisplayWidth;
            }
            return size;
        }
    }
}

