/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette.internal.ui;

import com.rsi.idldt.toolpalette.ActionSig;
import com.rsi.idldt.toolpalette.IDLVisTool;
import com.rsi.idldt.toolpalette.ToolCatalogParser;
import com.rsi.idldt.toolpalette.ToolPalettePlugin;
import com.rsi.idldt.toolpalette.actions.ActionBarPushButtonCommandAction;
import com.rsi.idldt.toolpalette.actions.ActionBarPushButtonWithMenuCommandAction;
import com.rsi.idldt.toolpalette.internal.ui.ActionBar;
import com.rsi.idldt.toolpalette.internal.ui.ActionBarCopyTransfer;
import com.rsi.idldt.toolpalette.internal.ui.ActionBarEditDialog;
import com.rsi.idldt.toolpalette.internal.ui.ArgTransfer;
import com.rsi.idldt.toolpalette.internal.ui.ControlRearrangeTransfer;
import com.rsi.idldt.toolpalette.internal.ui.LabelUtils;
import com.rsi.idldt.toolpalette.internal.ui.Messages;
import com.rsi.idldt.toolpalette.internal.ui.PlotOverlayCommandTransfer;
import com.rsi.idldt.toolpalette.views.ToolPaletteView;
import com.rsi.idldt.ui.TreeUtils;
import com.rsi.idldt.ui.UIPreferenceManager;
import com.rsi.jdml.PlatformSupport;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionBarComposite
extends Composite {
    public static final String CD_ARG_LABEL = "argLabel";
    public static final String CD_ARGID = "argID";
    public static final String CD_PROCNAME = "procName";
    public static final String CD_ACTIONBAR = "actionBar";
    public static final String CD_ACTION_SIG = "actionSig";
    public static final String CD_ACTIONBAR_INDEX = "actionBarIndex";
    public static final String CD_SIGID = "sigID";
    public static final String CD_DRAG_TOOLITEM = "dragToolItem";
    public static final String CD_ACTIONBARS_TOOLBAR = "actionBarToolbar";
    public static final String CD_STATICARGS = "staticArgs";
    public static final String CD_ARGLABELS = "argLabels";
    public static final String CD_ARG_HAS_DATA = "argHasData";
    public static final String CD_ARG_NULL_VALUE = "argNullValue";
    public static final String CD_FULL_ARG_VALUE = "fullArgValue";
    public static final String PARM_HAS_NO_VALUE = "!__PARM_HAS_NO_VALUE__!";
    protected static Hashtable<DropTarget, DropTargetAdapter> m_actionBarsDropListenerClearList = new Hashtable();
    protected static Hashtable<String, Label> m_argID2plotBarArgHash = new Hashtable();
    protected static int m_nArgID = 0;
    protected Vector<ActionBar> m_actionBars = new Vector();
    protected static ActionBar m_actionBarRearrangeDragSource = null;
    protected static boolean m_bActionBarEditMode = false;
    protected boolean m_bActionBarsDirty = false;
    protected Button m_acceptEditsButton = null;
    protected IDLVisTool m_editingActionBarForVisTool;
    protected ActionBar m_currentActionBarRearrangeDropTarget = null;
    protected ActionBarComposite m_thisInstance;
    protected Composite m_titleArea;
    private int m_ourMinWidth;
    protected Control m_actionBarDragSource;
    private static Image m_addUserDefinedImage;
    private static Image m_editSystemDefinedImage;
    private static Image m_editUserDefinedImage;

    public ActionBarComposite(Composite parent, Composite titleArea, int style) {
        super(parent, style);
        this.m_titleArea = titleArea;
        this.setupComposite();
        this.m_thisInstance = this;
    }

    public ActionBarComposite getInstance() {
        return this.m_thisInstance;
    }

    public void setupComposite() {
        GridLayout glayout = new GridLayout(1, true);
        glayout.verticalSpacing = 2;
        glayout.marginHeight = 2;
        glayout.marginWidth = 2;
        this.setLayout((Layout)glayout);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Composite bar = (Composite)e.widget;
                bar.setFocus();
            }
        });
    }

    public void setMinWidth(int min_width) {
        this.m_ourMinWidth = min_width;
        ((ScrolledComposite)this.getParent()).setMinWidth(min_width);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (wHint == -1) {
            return super.computeSize(this.m_ourMinWidth, hHint, changed);
        }
        return super.computeSize(wHint, hHint, changed);
    }

    public Point computeSize(int wHint, int hHint) {
        if (wHint == -1) {
            return super.computeSize(this.m_ourMinWidth, hHint);
        }
        return super.computeSize(wHint, hHint);
    }

    public void createTitleArea(IDLVisTool visTool) {
        Composite titleBar = this.m_titleArea;
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginBottom = 3;
        gridLayout.marginTop = 2;
        titleBar.setLayout((Layout)gridLayout);
        Label titleText = new Label(titleBar, 16384);
        String duped = ToolPaletteView.getInstance().duplicateAmpersands(visTool.getToolName());
        titleText.setText(String.valueOf(duped) + " " + Messages.ActionBarComposite_Actions);
        LabelUtils.makeLabelBold(titleText);
        GridData gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.verticalAlignment = 0x1000000;
        gd.horizontalIndent = 5;
        titleText.setLayoutData((Object)gd);
        if (m_bActionBarEditMode) {
            Composite linksComposite = new Composite(titleBar, 0);
            GridLayout gl = new GridLayout(1, false);
            gl.marginHeight = 0;
            gl.verticalSpacing = 0;
            linksComposite.setLayout((Layout)gl);
            gd = new GridData();
            gd.horizontalAlignment = 16384;
            gd.verticalAlignment = 0x1000000;
            gd.horizontalIndent = 5;
            linksComposite.setLayoutData((Object)gd);
            Composite linksComposite2 = new Composite(linksComposite, 0);
            gl = new GridLayout(2, false);
            gl.marginWidth = 0;
            gl.verticalSpacing = 0;
            linksComposite2.setLayout((Layout)gl);
            gd = new GridData();
            gd.horizontalAlignment = 16384;
            gd.verticalAlignment = 0x1000000;
            linksComposite2.setLayoutData((Object)gd);
            Button cancelEditsButton = new Button(linksComposite2, 0);
            cancelEditsButton.setText(Messages.ActionBarComposite_CancelEdits);
            cancelEditsButton.setToolTipText(Messages.ActionBarComposite_CancelAllEdits);
            cancelEditsButton.setData("visTool", (Object)visTool);
            Listener cancelEditsButtonListener = new Listener(){

                public void handleEvent(Event event) {
                    ActionBarComposite.this.cancelActionBarEditMode(false);
                    ToolPaletteView.getInstance().setVisPaletteEnabled(true);
                }
            };
            cancelEditsButton.addListener(13, cancelEditsButtonListener);
            gd = new GridData();
            gd.horizontalAlignment = 16384;
            cancelEditsButton.setLayoutData((Object)gd);
            this.m_acceptEditsButton = new Button(linksComposite2, 0);
            if (this.m_bActionBarsDirty) {
                this.m_acceptEditsButton.setEnabled(true);
            } else {
                this.m_acceptEditsButton.setEnabled(false);
            }
            this.m_acceptEditsButton.setData("visTool", (Object)visTool);
            this.m_acceptEditsButton.setText(Messages.ActionBarComposite_AcceptEdits);
            this.m_acceptEditsButton.setToolTipText(Messages.ActionBarComposite_AcceptEditsToolTip);
            gd = new GridData();
            gd.horizontalAlignment = 16384;
            this.m_acceptEditsButton.setLayoutData((Object)gd);
            Listener acceptEditsListener = new Listener(){

                public void handleEvent(Event event) {
                    Button button = (Button)event.widget;
                    IDLVisTool visTool1 = (IDLVisTool)button.getData("visTool");
                    m_bActionBarEditMode = false;
                    visTool1.removeAllActionSigBackups();
                    ToolPaletteView.getInstance().writeUserCatalog();
                    ActionBarComposite.this.m_bActionBarsDirty = false;
                    ToolPaletteView.getInstance().setVisPaletteEnabled(true);
                    ToolPaletteView.getInstance().showToolActions(visTool1, true, true);
                }
            };
            this.m_acceptEditsButton.addListener(13, acceptEditsListener);
            if (visTool.isSystemDefined() && visTool.isSystemActionBarsIntact()) {
                Button restoreSystemActionsBtn = new Button(linksComposite, 0x800000);
                restoreSystemActionsBtn.setImage(this.getRestoreSystemActionsImage());
                restoreSystemActionsBtn.setText(Messages.ActionBarComposite_Restore);
                restoreSystemActionsBtn.setToolTipText(Messages.ActionBarComposite_RestoreSystemDefinedActions);
                restoreSystemActionsBtn.setData("visTool", (Object)visTool);
                gd = new GridData();
                gd.horizontalAlignment = 16384;
                restoreSystemActionsBtn.setLayoutData((Object)gd);
                Listener resetSystemActionBarsListener = new Listener(){

                    public void handleEvent(Event event) {
                        Button restoreSystemActionsBtn1 = (Button)event.widget;
                        IDLVisTool visTool1 = (IDLVisTool)restoreSystemActionsBtn1.getData("visTool");
                        visTool1.restoreSystemDefinedActionBars();
                        ActionBarComposite.this.setActionBarsDirty();
                        ToolPaletteView.getInstance().showToolActions(visTool1, true, true);
                    }
                };
                restoreSystemActionsBtn.addListener(13, resetSystemActionBarsListener);
            }
        }
        titleBar.layout(true);
        titleBar.getParent().layout(true);
    }

    public boolean isInEditMode() {
        return m_bActionBarEditMode;
    }

    public void startActionBarEditMode(IDLVisTool visTool) {
        if (visTool == null) {
            return;
        }
        m_bActionBarEditMode = true;
        this.m_editingActionBarForVisTool = visTool;
        visTool.clearActionBarDropStates();
        visTool.backupActionSignatures();
        ToolPaletteView.getInstance().setVisPaletteEnabled(false);
        ToolPaletteView.getInstance().showToolActions(visTool, true, true);
    }

    public void cancelActionBarEditMode(boolean bAskToSave) {
        if (m_bActionBarEditMode) {
            m_bActionBarEditMode = false;
            assert (this.m_editingActionBarForVisTool != null) : "m_editingActionBarForVisTool is null";
            if (bAskToSave && this.m_bActionBarsDirty) {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getShells()[0];
                MessageBox msgBox = new MessageBox(shell, 196);
                msgBox.setMessage(Messages.ActionBarComposite_SaveActionModifications);
                msgBox.setText(Messages.ActionBarComposite_Question);
                int rc = msgBox.open();
                if (rc == 128) {
                    this.m_editingActionBarForVisTool.restoreBackupActionSignatures();
                } else {
                    m_bActionBarEditMode = false;
                    this.m_editingActionBarForVisTool.removeAllActionSigBackups();
                    ToolPaletteView.getInstance().writeUserCatalog();
                }
            } else {
                this.m_editingActionBarForVisTool.restoreBackupActionSignatures();
            }
            ToolPaletteView.getInstance().setVisPaletteEnabled(true);
            this.m_bActionBarsDirty = false;
            ToolPaletteView.getInstance().showToolActions(this.m_editingActionBarForVisTool, true, true);
        }
    }

    protected void handleActionBarEditButtonPush(Event event) {
        Button pbEditButton = (Button)event.widget;
        ActionSig sig = (ActionSig)pbEditButton.getData(CD_ACTION_SIG);
        IDLVisTool visTool = (IDLVisTool)pbEditButton.getData("visTool");
        ActionBar bar = (ActionBar)((Object)pbEditButton.getData(CD_ACTIONBAR));
        bar.internalFocusGained(false);
        this.showActionBarEditDialog(visTool, sig, false);
    }

    public void showActionBarEditDialog(IDLVisTool visTool, ActionSig sig, boolean bRemoveActionOnDialogCancel) {
        int actionBarIndex = visTool.getActionBarShowIndexNumber(sig.m_title);
        this.setFocusOnActionBar(actionBarIndex);
        ActionBarEditDialog dlg = new ActionBarEditDialog(Display.getCurrent().getActiveShell(), Messages.ActionBarComposite_EditAction, visTool, sig, false);
        if (dlg.open() == 0) {
            this.setActionBarsDirty();
            ActionSig newSig = dlg.getNewActionSig();
            if (sig.isUserDefined()) {
                visTool.changeActionTitle(sig.m_title, newSig.m_title);
                sig.applyEdits(newSig);
            } else {
                visTool.addActionSignature(newSig.m_actionType, 1, newSig.m_procName, newSig.m_overplotCmd, newSig.m_argNames, newSig.m_staticArgs, newSig.m_desc, newSig.m_title, sig.m_title);
            }
            ToolPaletteView.getInstance().showToolActions(visTool, true, true);
        } else if (bRemoveActionOnDialogCancel) {
            visTool.closeActionSignature(sig);
            this.setActionBarsDirty();
            ToolPaletteView.getInstance().showToolActions(visTool, true, false);
            if (--actionBarIndex < 0) {
                actionBarIndex = 0;
            }
            this.setFocusOnActionBar(actionBarIndex);
        }
    }

    public void createActionBarEditControls(IDLVisTool visTool, ActionBar actionbar, ActionSig sig) {
        Composite editComp = actionbar.addComposite(0, false);
        GridLayout gl = new GridLayout(2, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        editComp.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        editComp.setLayoutData((Object)gd);
        Button pbEditButton = new Button(editComp, 0x800000);
        pbEditButton.setImage(this.getEditImage(sig));
        pbEditButton.setText(Messages.ActionBarComposite_Edit);
        if (sig.isSystemDefined()) {
            pbEditButton.setToolTipText(" " + Messages.ActionBarComposite_EditSystemDefinedAction);
        } else {
            pbEditButton.setToolTipText(" " + Messages.ActionBarComposite_EditUserDefinedAction);
        }
        gd = new GridData(16384, 4, true, false, 1, 1);
        gd.horizontalIndent = 3;
        pbEditButton.setLayoutData((Object)gd);
        pbEditButton.setData(CD_ACTION_SIG, (Object)sig);
        pbEditButton.setData(CD_ACTIONBAR, (Object)actionbar);
        pbEditButton.setData("visTool", (Object)visTool);
        Listener editActionBarListener = new Listener(){

            public void handleEvent(Event event) {
                ActionBarComposite.this.handleActionBarEditButtonPush(event);
            }
        };
        pbEditButton.addListener(13, editActionBarListener);
        ToolBar toolBar = new ToolBar(editComp, 0x820000);
        actionbar.setData(CD_ACTIONBARS_TOOLBAR, toolBar);
        toolBar.setData(CD_ACTIONBAR, (Object)actionbar);
        gd = new GridData(131072, 4, true, true, 1, 1);
        toolBar.setLayoutData((Object)gd);
        ToolItem createNewFromExistingButton = new ToolItem(toolBar, 0x800000);
        createNewFromExistingButton.setImage(ToolPaletteView.getInstance().getAddActionBarFromExistingImage());
        createNewFromExistingButton.setData(CD_ACTION_SIG, (Object)sig);
        createNewFromExistingButton.setData("visTool", (Object)visTool);
        createNewFromExistingButton.setToolTipText(Messages.ActionBarComposite_CreateNewActionFromExistingAction);
        Listener createNewFromExistingListener = new Listener(){

            public void handleEvent(Event event) {
                ToolItem createNewFromExistingButton1 = (ToolItem)event.widget;
                ActionSig sig1 = (ActionSig)createNewFromExistingButton1.getData(ActionBarComposite.CD_ACTION_SIG);
                IDLVisTool visTool1 = (IDLVisTool)createNewFromExistingButton1.getData("visTool");
                ActionBar bar = (ActionBar)((Object)createNewFromExistingButton1.getParent().getData(ActionBarComposite.CD_ACTIONBAR));
                bar.internalFocusGained(false);
                ActionBarEditDialog dlg = new ActionBarEditDialog(Display.getCurrent().getActiveShell(), Messages.ActionBarComposite_CreateNewAction, visTool1, sig1, true);
                if (dlg.open() == 0) {
                    ActionBarComposite.this.setActionBarsDirty();
                    ActionSig newSig = dlg.getNewActionSig();
                    visTool1.addActionSignature(newSig.m_actionType, 1, newSig.m_procName, newSig.m_overplotCmd, newSig.m_argNames, newSig.m_staticArgs, newSig.m_desc, newSig.m_title, null);
                    ToolPaletteView.getInstance().showToolActions(visTool1, true, true);
                }
            }
        };
        createNewFromExistingButton.addListener(13, createNewFromExistingListener);
        ToolItem moveButton = new ToolItem(toolBar, 0x800000);
        moveButton.setImage(ToolPaletteView.getInstance().getReorderImage());
        moveButton.setToolTipText(Messages.ActionBarComposite_DragAction);
        actionbar.setData(CD_DRAG_TOOLITEM, moveButton);
        ToolItem closeButton = new ToolItem(toolBar, 0x800000);
        closeButton.setImage(ToolPaletteView.getInstance().getCloseImage());
        closeButton.setData(CD_ACTION_SIG, (Object)sig);
        closeButton.setData("visTool", (Object)visTool);
        closeButton.setToolTipText(Messages.ActionBarComposite_RemoveAction);
        Listener closeButtonListener = new Listener(){

            public void handleEvent(Event event) {
                ToolItem closeButton1 = (ToolItem)event.widget;
                IDLVisTool visTool1 = (IDLVisTool)closeButton1.getData("visTool");
                ActionSig sig1 = (ActionSig)closeButton1.getData(ActionBarComposite.CD_ACTION_SIG);
                int actionBarIndex = visTool1.getActionBarShowIndexNumber(sig1.m_title);
                visTool1.closeActionSignature(sig1);
                ActionBarComposite.this.setActionBarsDirty();
                ToolPaletteView.getInstance().showToolActions(visTool1, true, false);
                if (--actionBarIndex < 0) {
                    actionBarIndex = 0;
                }
                ActionBarComposite.this.setFocusOnActionBar(actionBarIndex);
            }
        };
        closeButton.addListener(13, closeButtonListener);
        actionbar.addMouseDownCausesFocusToAllKids(editComp);
    }

    private Image getAddUserDefinedActionImage() {
        if (m_addUserDefinedImage == null) {
            URL url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/addUserDefinedAction16.png"), null);
            m_addUserDefinedImage = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return m_addUserDefinedImage;
    }

    private Image getRestoreSystemActionsImage() {
        if (m_editSystemDefinedImage == null) {
            URL url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/editSystemDefinedAction16.png"), null);
            m_editSystemDefinedImage = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return m_editSystemDefinedImage;
    }

    private Image getEditImage(ActionSig sig) {
        URL url;
        if (m_editSystemDefinedImage == null) {
            url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/editSystemDefinedAction16.png"), null);
            m_editSystemDefinedImage = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        if (m_editUserDefinedImage == null) {
            url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/editUserDefinedAction16.png"), null);
            m_editUserDefinedImage = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        if (sig.isSystemDefined()) {
            return m_editSystemDefinedImage;
        }
        return m_editUserDefinedImage;
    }

    public void createDropAreaToCreateANewActionBar(IDLVisTool visTool) {
        Composite addArea = new Composite((Composite)this, 18432);
        addArea.setData("visTool", (Object)visTool);
        GridLayout glayout = new GridLayout(1, false);
        glayout.verticalSpacing = 0;
        glayout.marginBottom = 1;
        addArea.setLayout((Layout)glayout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        addArea.setLayoutData((Object)gd);
        final Button btnToShowAddDialog = new Button(addArea, 0x800000);
        btnToShowAddDialog.setImage(this.getAddUserDefinedActionImage());
        btnToShowAddDialog.setText(Messages.ActionBarComposite_NewAction);
        btnToShowAddDialog.setToolTipText(Messages.ActionBarComposite_AddNewUserDefinedAction);
        btnToShowAddDialog.setData("visTool", (Object)visTool);
        Color color = btnToShowAddDialog.getDisplay().getSystemColor(10);
        gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.grabExcessHorizontalSpace = true;
        btnToShowAddDialog.setLayoutData((Object)gd);
        Label label = new Label(addArea, 16448);
        label.setText(String.valueOf(Messages.ActionBarComposite_DragToCreateNew) + Messages.ActionBarComposite_ToThisArea);
        LabelUtils.makeLabelColor(label, color);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gd);
        this.makeNewActionBarADropSite(addArea);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                IDLVisTool visTool1 = (IDLVisTool)btnToShowAddDialog.getData("visTool");
                ActionBarEditDialog dlg = new ActionBarEditDialog(Display.getCurrent().getActiveShell(), Messages.ActionBarComposite_AddNewActionDlgTitle, visTool1, null, true);
                if (dlg.open() == 0) {
                    ActionBarComposite.this.setActionBarsDirty();
                    ActionSig newSig = dlg.getNewActionSig();
                    visTool1.addActionSignature(newSig.m_actionType, 1, newSig.m_procName, newSig.m_overplotCmd, newSig.m_argNames, newSig.m_staticArgs, newSig.m_desc, newSig.m_title, null);
                    ToolPaletteView.getInstance().showToolActions(visTool1, true, false);
                }
            }
        };
        btnToShowAddDialog.addListener(13, listener);
    }

    protected void makeNewActionBarADropSite(Composite addArea) {
        DropTargetAdapter targetAdapter = new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
                int i = 0;
                int n = event.dataTypes.length;
                while (i < n) {
                    if (TextTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                    }
                    ++i;
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
            }

            public void drop(DropTargetEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String commandText = (String)event.data;
                    DropTarget dropTarget = (DropTarget)event.getSource();
                    Composite area = (Composite)dropTarget.getControl();
                    IDLVisTool visTool = (IDLVisTool)area.getData("visTool");
                    String routineName = ActionBarComposite.this.getRoutineNameFromCommandText(commandText);
                    ArrayList<String> argNames = ActionBarComposite.this.getPositionalArgsFromCommandText(commandText);
                    String staticArgs = ActionBarComposite.this.getStaticArgsFromCommandText(commandText);
                    if (routineName != null) {
                        String title = visTool.generateUniqueActionTitle(null);
                        visTool.addActionSignature(ActionSig.ActionType.PROCESSING, 1, routineName, null, argNames, staticArgs, null, title, null);
                        ActionBarComposite.this.setActionBarsDirty();
                        ToolPaletteView.getInstance().showToolActions(visTool, true, false);
                        ActionSig sig = visTool.getActionSig(title);
                        ActionBarComposite.this.showActionBarEditDialog(visTool, sig, true);
                    } else {
                        String message = String.valueOf(Messages.ActionBarComposite_IllFormedCommandForAnAction) + "\n" + commandText + "\n" + Messages.ActionBarComposite_CommandMustBeAnIDLProcedure;
                        String title = Messages.ActionBarComposite_UnableToCreateNewAction;
                        MessageDialog.openError((Shell)area.getShell(), (String)title, (String)message);
                    }
                }
            }
        };
        int style = 17;
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        DropTarget target = new DropTarget((Control)addArea, style);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)targetAdapter);
        ActionBarComposite.addToActionBarsDropListenerClearList(target, targetAdapter);
    }

    protected String getRoutineNameFromCommandText(String commandText) {
        String[] t = commandText.split(",");
        if (t == null || t.length == 0) {
            return commandText.trim();
        }
        return t[0].trim();
    }

    protected ArrayList<String> getPositionalArgsFromCommandText(String commandText) {
        ArrayList<String> list = new ArrayList<String>();
        String[] t = commandText.split(",");
        if (t == null || t.length <= 1) {
            return list;
        }
        int i = 1;
        while (i < t.length) {
            String token = t[i].trim();
            if (IDLVisTool.validIDLVariableName(token)) {
                list.add(token);
            }
            ++i;
        }
        return list;
    }

    protected String getStaticArgsFromCommandText(String commandText) {
        StringBuffer buf = new StringBuffer();
        String[] t = commandText.split(",");
        if (t == null || t.length <= 1) {
            return "";
        }
        int i = 1;
        while (i < t.length) {
            String token = t[i].trim();
            if (!IDLVisTool.validIDLVariableName(token)) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(token);
            }
            ++i;
        }
        String returnVal = buf.toString();
        if (returnVal.trim().length() == 0) {
            returnVal = null;
        }
        return returnVal;
    }

    public void makeActionBarADropSite(ActionBar bar) {
        DropTargetAdapter targetAdapter = new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (ActionBarComposite.this.m_actionBarDragSource != null) {
                    event.detail = 0;
                    return;
                }
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
                int i = 0;
                int n = event.dataTypes.length;
                while (i < n) {
                    if (TextTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        if (ActionBarComposite.this.getInstance().isInEditMode()) {
                            event.detail = 0;
                            break;
                        }
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataTypes[i]) || FileTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        if (ActionBarComposite.this.getInstance().isInEditMode()) {
                            event.detail = 0;
                            break;
                        }
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    if (ControlRearrangeTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        event.detail = 2;
                        break;
                    }
                    ++i;
                }
            }

            public void dragOver(DropTargetEvent event) {
                Composite c;
                event.feedback = 8;
                DropTarget dt = (DropTarget)event.widget;
                Control targetControl = dt.getControl();
                if (targetControl instanceof Composite) {
                    c = (Composite)targetControl;
                } else if (targetControl instanceof Label) {
                    c = targetControl.getParent();
                } else {
                    return;
                }
                ScrolledComposite scrollComposite = null;
                while (c != null) {
                    if (c instanceof ScrolledComposite) {
                        scrollComposite = (ScrolledComposite)c;
                        break;
                    }
                    c = c.getParent();
                }
                if (scrollComposite != null) {
                    ToolPaletteView.getInstance().autoScrollComposite(scrollComposite, event.y);
                }
                if (ControlRearrangeTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    while (!(targetControl instanceof ActionBar)) {
                        targetControl = targetControl.getParent();
                    }
                    ActionBar targetActionbar = (ActionBar)targetControl;
                    if (targetActionbar != m_actionBarRearrangeDragSource) {
                        ActionBarComposite.this.highlightCurrentActionBarDropTarget(targetActionbar, new Point(event.x, event.y));
                    }
                }
            }

            /*
             * Unable to fully structure code
             */
            public void drop(DropTargetEvent event) {
                block23: {
                    block25: {
                        block24: {
                            block20: {
                                block22: {
                                    block21: {
                                        if (!ControlRearrangeTransfer.getInstance().isSupportedType(event.currentDataType)) break block20;
                                        if (!(event.data instanceof String)) {
                                            return;
                                        }
                                        strSourcePlotbarIndexNumber = (String)event.data;
                                        sourcePlotbarIndexNumber = Integer.parseInt(strSourcePlotbarIndexNumber);
                                        targetPlotbarIndexNumber = -1;
                                        dt = (DropTarget)event.widget;
                                        targetControl = dt.getControl();
                                        if (!(targetControl instanceof Composite)) break block21;
                                        targetComposite = (Composite)targetControl;
                                        ** GOTO lbl20
                                    }
                                    if (!(targetControl instanceof Label)) break block22;
                                    targetComposite = targetControl.getParent();
                                    if (true) ** GOTO lbl20
                                }
                                return;
                                do {
                                    targetComposite = targetComposite.getParent();
lbl20:
                                    // 3 sources

                                } while (!(targetComposite instanceof ActionBar));
                                targetActionBar = (ActionBar)targetComposite;
                                i = 0;
                                while (i < ActionBarComposite.this.m_actionBars.size()) {
                                    pbar = ActionBarComposite.this.m_actionBars.get(i);
                                    if (pbar == targetActionBar) {
                                        targetPlotbarIndexNumber = i;
                                        break;
                                    }
                                    ++i;
                                }
                                if (sourcePlotbarIndexNumber != targetPlotbarIndexNumber) {
                                    vistool = (IDLVisTool)targetActionBar.getData("visTool");
                                    if (targetActionBar.isInsertAbove()) {
                                        vistool.moveBeforeActionSig(sourcePlotbarIndexNumber, targetPlotbarIndexNumber);
                                    } else {
                                        vistool.moveAfterActionSig(sourcePlotbarIndexNumber, targetPlotbarIndexNumber);
                                    }
                                    ActionBarComposite.this.setActionBarsDirty();
                                }
                                break block23;
                            }
                            if (!TextTransfer.getInstance().isSupportedType(event.currentDataType) && !FileTransfer.getInstance().isSupportedType(event.currentDataType) && !LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) break block23;
                            if (ActionBarComposite.this.getInstance().isInEditMode()) {
                                event.detail = 0;
                                return;
                            }
                            if (event.data instanceof TreeSelection) {
                                selection = (TreeSelection)event.data;
                                idlVariables = TreeUtils.convertSelectionToCSVListOfVariableNames((TreeSelection)selection);
                                varNames = idlVariables.split(",");
                            } else if (event.data instanceof String) {
                                varNames = ActionBarComposite.this.getVarNamesFromDroppedText((String)event.data);
                            } else if (event.data instanceof String[]) {
                                varNames = (String[])event.data;
                                i = 0;
                                while (i < varNames.length) {
                                    varNames[i] = String.valueOf('\'') + varNames[i] + '\'';
                                    ++i;
                                }
                            } else {
                                return;
                            }
                            dropTarget = (DropTarget)event.getSource();
                            targetControl = dropTarget.getControl();
                            if (!(targetControl instanceof Composite)) break block24;
                            targetComposite = (Composite)targetControl;
                            ** GOTO lbl73
                        }
                        if (!(targetControl instanceof Label)) break block25;
                        targetComposite = targetControl.getParent();
                        if (true) ** GOTO lbl73
                    }
                    return;
                    do {
                        targetComposite = targetComposite.getParent();
lbl73:
                        // 3 sources

                    } while (!(targetComposite instanceof ActionBar));
                    actionBar = (ActionBar)targetComposite;
                    argLabels = (ArrayList)actionBar.getData("argLabels");
                    i = 0;
                    while (i < varNames.length) {
                        if (i > argLabels.size() - 3) break;
                        l = (Label)argLabels.get(i + 2);
                        ActionBarComposite.setArgValue(l, varNames[i]);
                        ++i;
                    }
                    ActionBarComposite.configurePlotBarActivationButton(argLabels);
                    ActionBarComposite.this.saveActionBarState(actionBar, argLabels);
                    kids = actionBar.getChildren();
                    if (kids[0] instanceof Composite) {
                        c = (Composite)kids[0];
                        c.layout(true);
                        c.pack();
                        kids2 = c.getChildren();
                        index = 0;
                        if (kids2.length > 1) {
                            index = 1;
                        }
                        if (kids2[index] instanceof Composite) {
                            ActionBarComposite.this.possiblyGrowParmComposite((Composite)kids2[index]);
                        }
                    }
                    actionBar.internalFocusGained(false);
                    actionBar.layout(true);
                    actionBar.getParent().pack();
                }
            }
        };
        int style = 19;
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance(), FileTransfer.getInstance(), ControlRearrangeTransfer.getInstance()};
        DropTarget target = new DropTarget((Control)bar, style);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)targetAdapter);
        ActionBarComposite.addToActionBarsDropListenerClearList(target, targetAdapter);
        Vector<Control> innerCompositesAndLabels = bar.getInnerCompositesAndLabels();
        for (Control composite : innerCompositesAndLabels) {
            target = new DropTarget(composite, style);
            target.setTransfer(types);
            target.addDropListener((DropTargetListener)targetAdapter);
            ActionBarComposite.addToActionBarsDropListenerClearList(target, targetAdapter);
        }
    }

    protected String[] getVarNamesFromDroppedText(String droppedText) {
        ArrayList<Integer> commaIndexes = ActionBarComposite.getIndexesOfCommasInDroppedText(droppedText);
        String[] varNames = new String[commaIndexes.size() + 1];
        int i = 0;
        while (i < commaIndexes.size()) {
            int start = i == 0 ? 0 : commaIndexes.get(i - 1) + 1;
            int stop = commaIndexes.get(i) + 1;
            varNames[i] = droppedText.substring(start, stop - 1).trim();
            ++i;
        }
        if (commaIndexes.size() < 1) {
            varNames[0] = droppedText;
        } else {
            varNames[varNames.length - 1] = droppedText.substring(commaIndexes.get(commaIndexes.size() - 1) + 1);
        }
        return varNames;
    }

    private static ArrayList<Integer> getIndexesOfCommasInDroppedText(String droppedText) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        boolean bInsideArray = false;
        boolean bInsideQuote = false;
        char[] chars = droppedText.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '\'' || c == '\"') {
                bInsideQuote = !bInsideQuote;
            } else if (c == '[') {
                bInsideArray = true;
            } else if (c == ']') {
                bInsideArray = false;
            } else if (!bInsideQuote && !bInsideArray && c == ',') {
                indexes.add(new Integer(i));
            }
            ++i;
        }
        return indexes;
    }

    protected String getOverplotCommand(Control control, ActionSig sig) {
        ArrayList argLabels = (ArrayList)control.getData(CD_ARGLABELS);
        String staticArgs = (String)control.getData(CD_STATICARGS);
        String procName = (String)control.getData(CD_PROCNAME);
        StringBuffer idlVariables = new StringBuffer();
        int i = 2;
        while (i < argLabels.size()) {
            Label label = (Label)argLabels.get(i);
            String nullValue = (String)label.getData(CD_ARG_NULL_VALUE);
            String argValue = ActionBarComposite.getArgValue(label);
            if (argValue == null || argValue.trim().length() == 0) {
                argValue = nullValue;
            }
            idlVariables.append(argValue);
            if (i < argLabels.size() - 1) {
                idlVariables.append(", ");
            }
            ++i;
        }
        String plotCommand = IDLVisTool.doMacroVariableExpansionOnStaticArgs(sig.m_overplotCmd, sig.m_procName, null);
        if (idlVariables.length() > 0) {
            plotCommand = String.valueOf(plotCommand) + ", " + idlVariables.toString();
        }
        if (staticArgs != null && staticArgs.trim().length() > 0 && (staticArgs = IDLVisTool.doMacroVariableExpansionOnStaticArgs(staticArgs, procName, idlVariables.toString())) != null && staticArgs.length() > 0) {
            plotCommand = String.valueOf(plotCommand) + ", " + staticArgs;
        }
        return plotCommand;
    }

    protected ActionSig getHandleToActionBeingDrug(Control control) {
        ActionSig actionSig = (ActionSig)control.getData(CD_ACTION_SIG);
        return actionSig;
    }

    protected String getPlotCommand(Control control, boolean bJustRawCommand, String overPlotCmd) {
        ArrayList argLabels = (ArrayList)control.getData(CD_ARGLABELS);
        String staticArgs = (String)control.getData(CD_STATICARGS);
        String procName = overPlotCmd == null ? (String)control.getData(CD_PROCNAME) : overPlotCmd;
        StringBuffer idlVariables = new StringBuffer();
        int i = 2;
        while (i < argLabels.size()) {
            Label label = (Label)argLabels.get(i);
            String nullValue = (String)label.getData(CD_ARG_NULL_VALUE);
            if (bJustRawCommand) {
                idlVariables.append(nullValue);
            } else {
                String argValue = ActionBarComposite.getArgValue(label);
                if (argValue == null || argValue.trim().length() == 0) {
                    argValue = nullValue;
                }
                idlVariables.append(argValue);
            }
            if (i < argLabels.size() - 1) {
                idlVariables.append(", ");
            }
            ++i;
        }
        String plotCommand = procName;
        if (idlVariables.length() > 0) {
            plotCommand = String.valueOf(plotCommand) + ", " + idlVariables.toString();
        }
        if (staticArgs != null && staticArgs.trim().length() > 0) {
            if (!bJustRawCommand) {
                staticArgs = IDLVisTool.doMacroVariableExpansionOnStaticArgs(staticArgs, procName, idlVariables.toString());
            }
            if (staticArgs != null && staticArgs.length() > 0) {
                plotCommand = String.valueOf(plotCommand) + ", " + staticArgs;
            }
        }
        return plotCommand;
    }

    protected void makeADragSourceForPlotOverlayCommand(ArrayList<Control> controls, IDLVisTool visTool, ArrayList<Control> argLabels, String staticArgs, ActionSig sig) {
        for (Control control : controls) {
            if (control.getData("DragSource") != null) continue;
            control.setData("visTool", (Object)visTool);
            control.setData(CD_ARGLABELS, argLabels);
            control.setData(CD_STATICARGS, (Object)staticArgs);
            control.setData(CD_PROCNAME, (Object)sig.m_procName);
            control.setData(CD_ACTION_SIG, (Object)sig);
            this.makeControlADragSourceForPlotOverlayCommand(control);
        }
    }

    protected void makeControlADragSourceForPlotOverlayCommand(Control control) {
        int operations = 17;
        DragSource source = new DragSource(control, operations);
        source.setDragSourceEffect(new DragSourceEffect(control){
            Image m_dragImage;

            public void dragStart(DragSourceEvent event) {
                DragSource ds = (DragSource)event.getSource();
                Control control1 = ds.getControl();
                while (control1 != null && !(control1 instanceof ActionBar)) {
                    control1 = control1.getParent();
                }
                if (control1 == null) {
                    return;
                }
                ActionBarComposite.this.m_actionBarDragSource = control1;
                ActionSig sig = (ActionSig)control1.getData(ActionBarComposite.CD_ACTION_SIG);
                Label l = new Label(control1.getParent(), 0);
                if (sig.m_title != null) {
                    l.setText(sig.m_title);
                }
                int X_INDENT_PIX = 12;
                l.setSize(l.computeSize(-1, -1));
                Point size = l.getSize();
                size.x += X_INDENT_PIX;
                this.m_dragImage = new Image((Device)control1.getDisplay(), size.x, size.y);
                GC gc = new GC((Drawable)this.m_dragImage);
                gc.setFont(l.getFont());
                gc.setForeground(control1.getDisplay().getSystemColor(2));
                gc.setBackground(control1.getDisplay().getSystemColor(1));
                gc.drawText(l.getText(), X_INDENT_PIX, 0);
                gc.dispose();
                l.dispose();
                event.image = this.m_dragImage;
            }

            public void dragFinished(DragSourceEvent event) {
                this.m_dragImage.dispose();
                ActionBarComposite.this.m_actionBarDragSource = null;
            }
        });
        Transfer[] types = new Transfer[]{ActionBarCopyTransfer.getInstance(), PlotOverlayCommandTransfer.getInstance(), TextTransfer.getInstance()};
        source.setTransfer(types);
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                DragSource ds = (DragSource)event.getSource();
                Control control1 = ds.getControl();
                if (!control1.isEnabled()) {
                    event.doit = false;
                } else {
                    IDLVisTool.setHandleToActionBeingDrug(ActionBarComposite.this.getHandleToActionBeingDrug(control1));
                    ActionSig sig = (ActionSig)control1.getData(ActionBarComposite.CD_ACTION_SIG);
                    if (sig.m_overplotCmd != null && sig.m_overplotCmd.trim().length() > 0) {
                        IDLVisTool.setOverplotDragData(ActionBarComposite.this.getOverplotCommand(control1, sig));
                    }
                }
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = "";
                DragSource ds = (DragSource)event.getSource();
                Control control1 = ds.getControl();
                if (PlotOverlayCommandTransfer.getInstance().isSupportedType(event.dataType) || TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = ActionBarComposite.this.getPlotCommand(control1, false, null);
                    IDLVisTool.setHandleToActionBeingDrug(ActionBarComposite.this.getHandleToActionBeingDrug(control1));
                } else if (ActionBarCopyTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = ActionBarComposite.this.getPlotCommand(control1, true, null);
                    IDLVisTool.setHandleToActionBeingDrug(ActionBarComposite.this.getHandleToActionBeingDrug(control1));
                }
            }

            public void dragFinished(DragSourceEvent event) {
                IDLVisTool.setOverplotDragData(null);
                IDLVisTool.setHandleToActionBeingDrug(null);
            }
        });
    }

    protected void addComma(Composite c) {
        Label l = new Label(c, 16384);
        l.setText(",");
        l.setFont(ToolPaletteView.MONO_FONT);
    }

    public ActionBar createActionBar(int barIndex, IDLVisTool visTool, ActionSig sig) {
        ArrayList<Control> controlsThatCanDragPlotCommand = new ArrayList<Control>();
        StringBuilder actionBarToolTipText = new StringBuilder();
        ArrayList<String> argNames = sig.m_argNames;
        String staticArgs = sig.m_staticArgs;
        String action_description = sig.m_desc;
        String action_title = sig.m_title;
        ActionBar actionBar = new ActionBar(this, 2048);
        sig.setActionBar(actionBar);
        this.m_actionBars.add(actionBar);
        actionBar.setData(CD_SIGID, sig.m_title);
        actionBar.setData("visTool", visTool);
        actionBar.setData(CD_ACTIONBAR_INDEX, new Integer(barIndex));
        controlsThatCanDragPlotCommand.add((Control)actionBar);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        actionBar.setLayoutData(gd);
        sig.m_plotBar = actionBar;
        if (this.isInEditMode()) {
            this.createActionBarEditControls(visTool, actionBar, sig);
        }
        if (action_title != null && action_title.trim().length() > 0) {
            Label title = actionBar.addLabel(16448, true);
            controlsThatCanDragPlotCommand.add((Control)title);
            title.setText(ToolPaletteView.getInstance().duplicateAmpersands(action_title));
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.verticalIndent = 1;
            gd.horizontalIndent = 5;
            actionBarToolTipText.append("<b>" + Messages.ActionBarComposite_Title + "</b><br><dd>");
            actionBarToolTipText.append(ToolCatalogParser.HTMLEncode(action_title));
            if (this.isInEditMode()) {
                LabelUtils.makeLabelBold(title);
                gd.horizontalIndent = 3;
            } else {
                gd.horizontalIndent = 5;
            }
            title.setLayoutData((Object)gd);
        }
        if (action_description != null && action_description.trim().length() > 0) {
            actionBarToolTipText.append("<br><b>" + Messages.ActionBarComposite_Description + "</b><br><dd>");
            actionBarToolTipText.append(ToolCatalogParser.HTMLEncode(action_description));
        }
        if (this.isInEditMode() && action_description != null && action_description.trim().length() > 0) {
            Label desc = actionBar.addLabel(16448, true);
            controlsThatCanDragPlotCommand.add((Control)desc);
            desc.setText(action_description);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.verticalIndent = 3;
            gd.horizontalIndent = 3;
            desc.setLayoutData((Object)gd);
        }
        Composite parambar = actionBar.addComposite(0, false);
        controlsThatCanDragPlotCommand.add((Control)parambar);
        controlsThatCanDragPlotCommand.add((Control)actionBar.getInnerComposite());
        GridLayout glayout = new GridLayout(-1, false);
        glayout.numColumns = argNames.size() >= 4 ? 4 : 10;
        glayout.verticalSpacing = 0;
        glayout.horizontalSpacing = 2;
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.makeColumnsEqualWidth = false;
        parambar.setLayout((Layout)glayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.grabExcessHorizontalSpace = true;
        parambar.setLayoutData((Object)gd);
        ArrayList<Control> argLabels = new ArrayList<Control>();
        Object dragPlotCommandLabel = null;
        new Label(parambar, 0);
        ToolBar actionButtonToolBar = this.createActionButtonToolBar(parambar, visTool, argLabels, sig);
        argLabels.add((Control)actionButtonToolBar);
        argLabels.add((Control)dragPlotCommandLabel);
        int nArgs = argNames.size();
        String[] previousValues = visTool.getActionBarDropState(barIndex);
        int iDum = 2;
        int i = 0;
        while (i < nArgs) {
            String argID = Integer.toString(++m_nArgID);
            if (nArgs >= 4 && i == iDum) {
                new Label(parambar, 0);
                new Label(parambar, 0);
                iDum += 2;
            }
            Composite labelComposite = new Composite(parambar, 2048);
            GridLayout gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginWidth = 2;
            gl.horizontalSpacing = 0;
            labelComposite.setLayout((Layout)gl);
            Label arg = new Label(labelComposite, 16384);
            arg.setData(CD_ARGID, (Object)argID);
            arg.setData(CD_ARGLABELS, argLabels);
            arg.setData(CD_ACTIONBAR, (Object)actionBar);
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 16384;
            arg.setLayoutData((Object)gd);
            String arg_name = argNames.get(i);
            this.setArgNullValue(arg, arg_name);
            arg.setToolTipText(arg_name);
            arg.setFont(ToolPaletteView.MONO_FONT);
            argLabels.add((Control)arg);
            if (i + 1 < nArgs) {
                this.addComma(labelComposite);
            }
            this.addDnDtoArgLabel(labelComposite, arg);
            m_argID2plotBarArgHash.put(argID, arg);
            if (previousValues != null && i < previousValues.length && !previousValues[i].equals(PARM_HAS_NO_VALUE)) {
                ActionBarComposite.setArgValue(arg, previousValues[i]);
            }
            labelComposite.pack(true);
            ++i;
        }
        parambar.layout(true);
        parambar.pack(true);
        this.possiblyGrowParmComposite(parambar);
        ActionBarComposite.configurePlotBarActivationButton(argLabels);
        actionBar.addMouseDownCausesFocusToAllKids(parambar);
        if ((m_bActionBarEditMode || this.isShowingKeywords()) && staticArgs != null && staticArgs.trim().length() > 0) {
            Composite c = actionBar.addComposite(0, true);
            this.createStaticArgsComposite(controlsThatCanDragPlotCommand, c, staticArgs);
            actionBar.addMouseDownCausesFocusToAllKids(c);
            actionBar.addHoverHelpToControl((Control)c);
        }
        actionBar.setData(CD_ARGLABELS, argLabels);
        this.makeActionBarADropSite(actionBar);
        actionBar.layout(true);
        actionBar.pack(true);
        this.makeADragSourceForPlotOverlayCommand(controlsThatCanDragPlotCommand, visTool, argLabels, staticArgs, sig);
        actionBarToolTipText.append("<br><b>" + Messages.ActionBarComposite_Action + "</b><br><dd>" + this.getPlotCommand((Control)parambar, true, null));
        if (sig.hasOverplotCommand()) {
            String overPlotCmd = IDLVisTool.doMacroVariableExpansionOnStaticArgs(sig.m_overplotCmd, sig.m_procName, null);
            actionBarToolTipText.append("<br><b>" + Messages.ActionBarComposite_OverplotCommand + "</b><br><dd>" + this.getPlotCommand((Control)parambar, true, overPlotCmd));
        }
        actionBar.setToolTipText(actionBarToolTipText.toString());
        if (!this.isInEditMode()) {
            actionBar.addContextMenu();
        }
        return actionBar;
    }

    private ToolBar createActionButtonToolBar(Composite parambar, IDLVisTool visTool, ArrayList<Control> argLabels, ActionSig sig) {
        ToolBarManager tbm = new ToolBarManager(0x800100);
        if (!sig.hasOverplotCommand()) {
            tbm.add((IAction)new ActionBarPushButtonCommandAction(visTool, argLabels, sig));
        } else {
            tbm.add((IAction)new ActionBarPushButtonWithMenuCommandAction(visTool, argLabels, sig));
        }
        ToolBar tb = tbm.createControl(parambar);
        return tb;
    }

    public boolean isShowingKeywords() {
        IPreferenceStore pref_store = UIPreferenceManager.getPreferenceStore();
        boolean bShowingKeywords = pref_store.getBoolean("IDLDT_VISMGR_showing_KEYWORDS");
        return bShowingKeywords;
    }

    protected void createStaticArgsComposite(ArrayList<Control> controls, Composite c, String staticArgs) {
        GridLayout glayout1 = new GridLayout(1, false);
        glayout1.marginHeight = 0;
        glayout1.verticalSpacing = 0;
        glayout1.marginWidth = 0;
        c.setLayout((Layout)glayout1);
        c.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label staticArgsLabel = new Label(c, 64);
        staticArgsLabel.setText(", " + staticArgs);
        controls.add((Control)staticArgsLabel);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalIndent = 4;
        staticArgsLabel.setLayoutData((Object)gd);
    }

    protected Composite getArgComposite(Control theControl) {
        Control control = theControl;
        while (!(control instanceof Composite)) {
            control = control.getParent();
        }
        return (Composite)control;
    }

    protected void makeArgLabelADragSource(Composite argComposite) {
        int operations = 2;
        Control[] kids = argComposite.getChildren();
        int i = -1;
        while (i < kids.length) {
            Object kid = i == -1 ? argComposite : kids[i];
            DragSource source = new DragSource((Control)kid, operations);
            source.setDragSourceEffect(new DragSourceEffect((Control)kid){

                public void dragStart(DragSourceEvent event) {
                    event.image = ToolPaletteView.getInstance().getArgSwapIcon();
                }
            });
            Transfer[] types = new Transfer[]{ArgTransfer.getInstance()};
            source.setTransfer(types);
            source.addDragListener(new DragSourceListener(){

                public void dragStart(DragSourceEvent event) {
                    DragSource ds = (DragSource)event.getSource();
                    Control control = ds.getControl();
                    Label argLabel = (Label)ActionBarComposite.this.getArgComposite(control).getData(ActionBarComposite.CD_ARG_LABEL);
                    Boolean hasData = (Boolean)argLabel.getData(ActionBarComposite.CD_ARG_HAS_DATA);
                    if (argLabel.getText().length() == 0 || !hasData.booleanValue()) {
                        event.doit = false;
                    } else {
                        argLabel.setBackground(argLabel.getDisplay().getSystemColor(5));
                    }
                }

                public void dragSetData(DragSourceEvent event) {
                    if (ArgTransfer.getInstance().isSupportedType(event.dataType)) {
                        DragSource ds = (DragSource)event.getSource();
                        Control control = ds.getControl();
                        Label argLabel = (Label)ActionBarComposite.this.getArgComposite(control).getData(ActionBarComposite.CD_ARG_LABEL);
                        event.data = argLabel.getData(ActionBarComposite.CD_ARGID);
                    }
                }

                public void dragFinished(DragSourceEvent event) {
                    DragSource ds = (DragSource)event.getSource();
                    Control control = ds.getControl();
                    Label argLabel = (Label)ActionBarComposite.this.getArgComposite(control).getData(ActionBarComposite.CD_ARG_LABEL);
                    argLabel.setBackground(null);
                }
            });
            ++i;
        }
    }

    protected void makeArgLabelADropSite(Composite argComposite) {
        DropTargetAdapter targetAdapter = new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (ActionBarComposite.this.getInstance().isInEditMode()) {
                    event.detail = 0;
                    return;
                }
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
                boolean bAllowedDataType = false;
                int i = 0;
                int n = event.dataTypes.length;
                while (i < n) {
                    if (ActionBarCopyTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        bAllowedDataType = false;
                        break;
                    }
                    if (ArgTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        bAllowedDataType = true;
                        event.detail = 2;
                        break;
                    }
                    if (TextTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        bAllowedDataType = true;
                        break;
                    }
                    if (FileTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        bAllowedDataType = true;
                        break;
                    }
                    if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        bAllowedDataType = true;
                        break;
                    }
                    ++i;
                }
                if (!bAllowedDataType || !this.allowThisActionBarDrop(event)) {
                    event.detail = 0;
                    return;
                }
            }

            private boolean allowThisActionBarDrop(DropTargetEvent event) {
                ActionSig sig;
                DropTarget dropTarget = (DropTarget)event.getSource();
                Control control = dropTarget.getControl();
                Label dropArg = (Label)ActionBarComposite.this.getArgComposite(control).getData(ActionBarComposite.CD_ARG_LABEL);
                ActionBar dropActionBar = (ActionBar)((Object)dropArg.getData(ActionBarComposite.CD_ACTIONBAR));
                IDLVisTool visTool = (IDLVisTool)dropActionBar.getData("visTool");
                if (visTool == null) {
                    return false;
                }
                return !ActionBarCopyTransfer.getInstance().isSupportedType(event.currentDataType) || (sig = IDLVisTool.getHandleToActionBeingDrug()) == null || !visTool.containsSig(sig);
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
            }

            public void drop(DropTargetEvent event) {
                Label dropArg = null;
                if (ArgTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String sourceArgID = (String)event.data;
                    Label sourceArg = m_argID2plotBarArgHash.get(sourceArgID);
                    DropTarget dropTarget = (DropTarget)event.getSource();
                    Control control = dropTarget.getControl();
                    dropArg = (Label)ActionBarComposite.this.getArgComposite(control).getData(ActionBarComposite.CD_ARG_LABEL);
                    Boolean bDropArgHasData = (Boolean)dropArg.getData(ActionBarComposite.CD_ARG_HAS_DATA);
                    if (bDropArgHasData.booleanValue()) {
                        String tmp = ActionBarComposite.getArgValue(dropArg);
                        ActionBarComposite.setArgValue(dropArg, ActionBarComposite.getArgValue(sourceArg));
                        ActionBarComposite.setArgValue(sourceArg, tmp);
                    } else {
                        ActionBarComposite.setArgValue(dropArg, ActionBarComposite.getArgValue(sourceArg));
                        String nullValue = (String)sourceArg.getData(ActionBarComposite.CD_ARG_NULL_VALUE);
                        ActionBarComposite.this.setArgNullValue(sourceArg, nullValue);
                    }
                    ArrayList sourceArgLabels = (ArrayList)sourceArg.getData(ActionBarComposite.CD_ARGLABELS);
                    ArrayList dropArgLabels = (ArrayList)dropArg.getData(ActionBarComposite.CD_ARGLABELS);
                    ActionBarComposite.configurePlotBarActivationButton(sourceArgLabels);
                    ActionBarComposite.configurePlotBarActivationButton(dropArgLabels);
                    sourceArg.getParent().layout(true);
                    sourceArg.getParent().pack();
                    dropArg.getParent().getParent().layout(true);
                    dropArg.getParent().getParent().pack();
                    sourceArg.getParent().getParent().layout(true);
                    sourceArg.getParent().getParent().pack();
                    ActionBar sourceActionBar = (ActionBar)((Object)sourceArg.getData(ActionBarComposite.CD_ACTIONBAR));
                    ActionBar dropActionBar = (ActionBar)((Object)dropArg.getData(ActionBarComposite.CD_ACTIONBAR));
                    ActionBarComposite.this.saveActionBarState(sourceActionBar, sourceArgLabels);
                    if (!((Object)((Object)dropActionBar)).equals((Object)sourceActionBar)) {
                        ActionBarComposite.this.saveActionBarState(dropActionBar, dropArgLabels);
                    }
                } else if (TextTransfer.getInstance().isSupportedType(event.currentDataType) || FileTransfer.getInstance().isSupportedType(event.currentDataType) || LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
                    String idlVariables = TreeUtils.convertTransferDataToString((Object)event.data);
                    if (idlVariables == null) {
                        return;
                    }
                    idlVariables = idlVariables.split(",")[0];
                    DropTarget dropTarget = (DropTarget)event.getSource();
                    Control control = dropTarget.getControl();
                    dropArg = (Label)ActionBarComposite.this.getArgComposite(control).getData(ActionBarComposite.CD_ARG_LABEL);
                    ActionBarComposite.setArgValue(dropArg, idlVariables);
                    ArrayList dropArgLabels = (ArrayList)dropArg.getData(ActionBarComposite.CD_ARGLABELS);
                    ActionBarComposite.configurePlotBarActivationButton(dropArgLabels);
                    ActionBar dropActionBar = (ActionBar)((Object)dropArg.getData(ActionBarComposite.CD_ACTIONBAR));
                    ActionBarComposite.this.saveActionBarState(dropActionBar, dropArgLabels);
                    dropArg.getParent().getParent().layout(true);
                    dropArg.getParent().getParent().pack();
                }
                if (dropArg != null) {
                    ActionBarComposite.this.possiblyGrowParmComposite(dropArg.getParent().getParent());
                }
            }
        };
        int style = 19;
        Transfer[] types = new Transfer[]{ActionBarCopyTransfer.getInstance(), ArgTransfer.getInstance(), TextTransfer.getInstance(), FileTransfer.getInstance(), LocalSelectionTransfer.getTransfer()};
        Control[] kids = argComposite.getChildren();
        int i = -1;
        while (i < kids.length) {
            Object kid = i == -1 ? argComposite : kids[i];
            DropTarget target = new DropTarget((Control)kid, style);
            target.setTransfer(types);
            target.addDropListener((DropTargetListener)targetAdapter);
            ActionBarComposite.addToActionBarsDropListenerClearList(target, targetAdapter);
            ++i;
        }
    }

    public void possiblyGrowParmComposite(Composite start) {
        int parambar_width = 5 + start.getSize().x;
        int pc_width = this.getSize().x;
        if (parambar_width > pc_width) {
            if (this.m_ourMinWidth < parambar_width) {
                this.setMinWidth(parambar_width);
            }
            start.pack();
            this.setSize(this.computeSize(-1, -1));
        }
        this.layout(true);
        this.getParent().layout(true);
        this.getParent().update();
    }

    protected void addDnDtoArgLabel(Composite argComposite, Label argLabel) {
        argComposite.setData(CD_ARG_LABEL, (Object)argLabel);
        this.makeArgLabelADragSource(argComposite);
        this.makeArgLabelADropSite(argComposite);
    }

    protected void saveActionBarState(ActionBar actionBar, ArrayList<Control> argLabels) {
        IDLVisTool visTool = (IDLVisTool)actionBar.getData("visTool");
        Integer actionBarIndexClass = (Integer)actionBar.getData(CD_ACTIONBAR_INDEX);
        String[] idlVariableNames = new String[argLabels.size() - 2];
        int i = 2;
        while (i < argLabels.size()) {
            Label label = (Label)argLabels.get(i);
            Boolean hasData = (Boolean)label.getData(CD_ARG_HAS_DATA);
            idlVariableNames[i - 2] = hasData != false ? ActionBarComposite.getArgValue(label) : PARM_HAS_NO_VALUE;
            ++i;
        }
        visTool.setActionBarDropState(actionBarIndexClass, idlVariableNames);
    }

    public static void configurePlotBarActivationButton(ArrayList<Control> argLabels) {
        ToolBar toolBar = (ToolBar)argLabels.get(0);
        ActionBarComposite.addPaintListenerIfNeedBe(toolBar);
        if (m_bActionBarEditMode) {
            ActionBarComposite.setToolBarEnablement(toolBar, false);
            return;
        }
        int i = 2;
        while (i < argLabels.size()) {
            Label l = (Label)argLabels.get(i);
            boolean hasData = (Boolean)l.getData(CD_ARG_HAS_DATA);
            if (!hasData) {
                ActionBarComposite.setToolBarEnablement(toolBar, false);
                return;
            }
            ++i;
        }
        ActionBarComposite.setToolBarEnablement(toolBar, true);
    }

    private static void addPaintListenerIfNeedBe(ToolBar toolBar) {
        if (!PlatformSupport.isMac()) {
            return;
        }
        Integer listener = (Integer)toolBar.getData("_mac_paint_listener");
        if (listener == null) {
            toolBar.setData("_mac_paint_listener", (Object)new Integer(1));
            toolBar.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    ToolBar tb = (ToolBar)e.widget;
                    if (tb.isEnabled()) {
                        e.gc.setAlpha(80);
                        Rectangle rect = tb.getBounds();
                        rect.width -= 3;
                        rect.height -= 2;
                        Color fore = Display.getCurrent().getSystemColor(2);
                        e.gc.setForeground(fore);
                        e.gc.drawRectangle(rect.x, rect.y, rect.width, rect.height);
                        e.gc.setAlpha(20);
                        Color back = Display.getCurrent().getSystemColor(17);
                        fore = Display.getCurrent().getSystemColor(1);
                        e.gc.setForeground(fore);
                        e.gc.setBackground(back);
                        e.gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
                    }
                }
            });
        }
    }

    public static void setToolBarEnablement(ToolBar toolBar, boolean value) {
        toolBar.setEnabled(value);
        if (PlatformSupport.isMac()) {
            ToolItem[] items;
            toolBar.setForeground(Display.getCurrent().getSystemColor(value ? 21 : 18));
            ToolItem[] toolItemArray = items = toolBar.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem item = toolItemArray[n2];
                item.setEnabled(value);
                ++n2;
            }
        }
        toolBar.redraw();
    }

    public static String baseValue(String invalue) {
        String baseValue = invalue.trim();
        if (baseValue.startsWith("'")) {
            baseValue = baseValue.substring(1);
        }
        if (baseValue.endsWith("'")) {
            baseValue = baseValue.substring(0, baseValue.length() - 1);
        }
        File f = new File(baseValue);
        baseValue = f.getName();
        return baseValue;
    }

    public static String getArgValue(Label argLabel) {
        Boolean hasData = (Boolean)argLabel.getData(CD_ARG_HAS_DATA);
        if (!hasData.booleanValue() || !hasData.booleanValue()) {
            return null;
        }
        String fullValue = (String)argLabel.getData(CD_FULL_ARG_VALUE);
        if (fullValue != null) {
            return fullValue;
        }
        return argLabel.getText().trim();
    }

    public static void setArgValue(Label argLabelIn, String value) {
        Label argLabel = argLabelIn;
        argLabel.setData(CD_FULL_ARG_VALUE, null);
        String trimmedValue = value.trim();
        String baseValue = ActionBarComposite.baseValue(trimmedValue);
        argLabel.setText(baseValue);
        argLabel.setData(CD_ARG_HAS_DATA, (Object)new Boolean(true));
        if (!trimmedValue.equals(baseValue)) {
            argLabel.setData(CD_FULL_ARG_VALUE, (Object)trimmedValue);
        }
        LabelUtils.makeLabelBold(argLabel);
        Color red = argLabel.getDisplay().getSystemColor(4);
        LabelUtils.makeLabelColor(argLabel, red);
        argLabel.computeSize(-1, -1, true);
    }

    public void setArgNullValue(Label argLabelIn, String nullValue) {
        Label argLabel = argLabelIn;
        argLabel.setText(nullValue.trim());
        argLabel.setData(CD_ARG_HAS_DATA, (Object)new Boolean(false));
        argLabel.setData(CD_ARG_NULL_VALUE, (Object)nullValue);
        LabelUtils.makeLabelItalic(argLabel);
        Color black = argLabel.getDisplay().getSystemColor(2);
        LabelUtils.makeLabelColor(argLabel, black);
    }

    protected void highlightCurrentActionBarDropTarget(ActionBar plotbar, Point displayPoint) {
        if (this.m_currentActionBarRearrangeDropTarget != null && this.m_currentActionBarRearrangeDropTarget != m_actionBarRearrangeDragSource) {
            this.m_currentActionBarRearrangeDropTarget.highlightAsRearrangeTarget(false, displayPoint, 0);
        }
        int force = 0;
        if (m_actionBarRearrangeDragSource != null && this.m_currentActionBarRearrangeDropTarget != null) {
            IDLVisTool visTool = (IDLVisTool)m_actionBarRearrangeDragSource.getData("visTool");
            String sourceSigId = (String)m_actionBarRearrangeDragSource.getData(CD_SIGID);
            String targetSigId = (String)this.m_currentActionBarRearrangeDropTarget.getData(CD_SIGID);
            int sourceIndex = visTool.getActionBarShowIndexNumber(sourceSigId);
            int dragTargetIndex = visTool.getActionBarShowIndexNumber(targetSigId);
            if (dragTargetIndex == sourceIndex + 1) {
                force = 1024;
            } else if (dragTargetIndex == sourceIndex - 1) {
                force = 128;
            }
        }
        plotbar.highlightAsRearrangeTarget(true, displayPoint, force);
        this.m_currentActionBarRearrangeDropTarget = plotbar;
    }

    protected void makeActionBarARearrangeDragSource(Control control, int actionBarIndexNumber) {
        int operations = 2;
        control.setData(CD_ACTIONBAR_INDEX, (Object)Integer.toString(actionBarIndexNumber));
        DragSource source = new DragSource(control, operations);
        source.setDragSourceEffect(new DragSourceEffect(control){

            public void dragStart(DragSourceEvent event) {
                event.image = null;
            }
        });
        Transfer[] types = new Transfer[]{ControlRearrangeTransfer.getInstance()};
        source.setTransfer(types);
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                ActionBar plotbar;
                DragSource ds = (DragSource)event.getSource();
                ToolBar sourceControl = (ToolBar)ds.getControl();
                m_actionBarRearrangeDragSource = plotbar = (ActionBar)((Object)sourceControl.getData(ActionBarComposite.CD_ACTIONBAR));
                ActionBarComposite.this.m_currentActionBarRearrangeDropTarget = plotbar;
            }

            public void dragSetData(DragSourceEvent event) {
                if (ControlRearrangeTransfer.getInstance().isSupportedType(event.dataType)) {
                    DragSource ds = (DragSource)event.getSource();
                    Control control1 = ds.getControl();
                    String plotBarIndexNumber = (String)control1.getData(ActionBarComposite.CD_ACTIONBAR_INDEX);
                    event.data = plotBarIndexNumber;
                }
            }

            public void dragFinished(DragSourceEvent event) {
                String sourceSigID = (String)m_actionBarRearrangeDragSource.getData(ActionBarComposite.CD_SIGID);
                DragSource ds = (DragSource)event.getSource();
                Control control1 = ds.getControl();
                ActionBar pb = (ActionBar)((Object)control1.getData(ActionBarComposite.CD_ACTIONBAR));
                IDLVisTool vistool = (IDLVisTool)pb.getData("visTool");
                ToolPaletteView.getInstance().showToolActions(vistool, true, false);
                int i = 0;
                while (i < ActionBarComposite.this.m_actionBars.size()) {
                    ActionBar pbar = ActionBarComposite.this.m_actionBars.get(i);
                    String sigID = (String)pbar.getData(ActionBarComposite.CD_SIGID);
                    if (sigID.equalsIgnoreCase(sourceSigID)) {
                        pbar.internalFocusGained(true);
                        break;
                    }
                    ++i;
                }
            }
        });
    }

    public void clearArgID2plotBarArgHash() {
        m_argID2plotBarArgHash.clear();
        m_nArgID = 0;
    }

    public void hookActionBarDragSupport(IDLVisTool visTool) {
        int i = 0;
        while (i < this.m_actionBars.size()) {
            Composite plotBar = this.m_actionBars.get(i);
            ToolItem dragToolItem = (ToolItem)plotBar.getData(CD_DRAG_TOOLITEM);
            ToolBar control = dragToolItem.getParent();
            this.makeActionBarARearrangeDragSource((Control)control, i);
            ++i;
        }
    }

    public void clearActionBarsVector() {
        this.m_actionBars.clear();
    }

    public void deactivated() {
        int i = 0;
        while (i < this.m_actionBars.size()) {
            ActionBar bar = this.m_actionBars.get(i);
            bar.internalFocusLost();
            ++i;
        }
    }

    public void activated() {
        if (this.m_actionBars != null && this.m_actionBars.size() > 0) {
            ActionBar bar = ActionBar.getLastFocusedBar();
            if (bar == null) {
                bar = this.m_actionBars.get(0);
            }
            bar.internalFocusGained(true);
        }
    }

    public void setFocusOnActionBar(int actionBarIndex) {
        try {
            ActionBar actionbar = this.m_actionBars.get(actionBarIndex);
            actionbar.setFocus();
            ScrolledComposite sc = (ScrolledComposite)this.getParent();
            Point origin = actionbar.getLocation();
            sc.setOrigin(origin);
        }
        catch (Exception exception) {}
    }

    public void setActionBarsDirty() {
        this.m_bActionBarsDirty = true;
        this.m_acceptEditsButton.setEnabled(true);
    }

    public static void addToActionBarsDropListenerClearList(DropTarget target, DropTargetAdapter targetAdapter) {
        m_actionBarsDropListenerClearList.put(target, targetAdapter);
    }

    public void clear() {
        if (this.isDisposed()) {
            return;
        }
        Enumeration<DropTarget> e = m_actionBarsDropListenerClearList.keys();
        while (e.hasMoreElements()) {
            DropTarget dt = e.nextElement();
            DropTargetAdapter dta = m_actionBarsDropListenerClearList.get(dt);
            if (dt.isDisposed()) continue;
            dt.removeDropListener((DropTargetListener)dta);
        }
        m_actionBarsDropListenerClearList.clear();
        Control[] kids = this.getChildren();
        int i = 0;
        while (i < kids.length) {
            if (!kids[i].isDisposed()) {
                kids[i].dispose();
            }
            ++i;
        }
        kids = this.m_titleArea.getChildren();
        i = 0;
        while (i < kids.length) {
            if (!kids[i].isDisposed()) {
                kids[i].dispose();
            }
            ++i;
        }
        this.layout();
    }

    public void show() {
        this.getParent().setVisible(true);
        this.getParent().setSize(this.getParent().computeSize(-1, -1));
        this.m_titleArea.setVisible(true);
        this.m_titleArea.setSize(this.m_titleArea.computeSize(-1, -1));
    }

    public void hide() {
        this.getParent().setVisible(false);
        this.getParent().setSize(0, 0);
        this.m_titleArea.setVisible(false);
        this.m_titleArea.setSize(0, 0);
    }
}

