/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette.internal.ui;

import com.rsi.idldt.toolpalette.ActionSig;
import com.rsi.idldt.toolpalette.IDLVisTool;
import com.rsi.idldt.toolpalette.internal.ui.ActionBarComposite;
import com.rsi.idldt.toolpalette.internal.ui.ActionBarInformationControl;
import com.rsi.idldt.toolpalette.internal.ui.Messages;
import com.rsi.idldt.toolpalette.views.ToolPaletteView;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionBar
extends Composite
implements FocusListener,
PaintListener {
    Composite m_inner;
    private ToolTipOwnerControlListener m_toolTipListener = new ToolTipOwnerControlListener();
    private TooltipHideListener hideListener = new TooltipHideListener();
    private Vector<Control> m_additionalComposites = new Vector();
    private Vector<Label> m_additionalLabels = new Vector();
    private Color m_defaultBackgroundColor;
    private Color m_focusBackgroundColor;
    private boolean m_paintInsertionMarker = false;
    private Point m_insertionMarkerPoint = null;
    private int m_forceMarkerLocation = 0;
    private boolean m_insertAbove = true;
    ActionBarInformationControl m_hoverHelp;
    ArrayList<Control> m_controlsThatNeedHoverHelp = new ArrayList();
    protected ActionBarComposite m_actionBarComposite;
    private static ActionBar m_lastFocus;

    public ActionBar(Composite parent, int style) {
        super(parent, style);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 3;
        gl.marginHeight = 3;
        this.setLayout((Layout)gl);
        this.addMouseDownCausesFocus((Control)this);
        this.addFocusListener(this);
        this.addPaintListener(this);
        this.m_actionBarComposite = (ActionBarComposite)parent;
    }

    protected void createInnerComposite() {
        this.m_inner = new Composite((Composite)this, 0);
        this.m_controlsThatNeedHoverHelp.add((Control)this.m_inner);
        this.m_defaultBackgroundColor = this.getBackground();
        this.m_focusBackgroundColor = new Color((Device)this.getDisplay(), 153, 186, 243);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 2;
        gl.marginHeight = 2;
        gl.marginWidth = 0;
        this.m_inner.setLayout((Layout)gl);
        this.m_inner.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.addMouseDownCausesFocus((Control)this.m_inner);
        this.m_inner.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ActionBar.this.internalFocusLost();
            }
        });
        this.m_hoverHelp = new ActionBarInformationControl(this.m_inner.getShell(), false);
        Point p = this.m_hoverHelp.computeSizeConstraints(80, 50);
        this.m_hoverHelp.setSizeConstraints(p.x, p.y);
    }

    public void activateHoverHelp() {
        this.doActivateHoverHelp();
        this.addMouseEventBehaviorToHoverHelpControl((Control)this.m_hoverHelp.getComposite());
    }

    protected void addHoverHelpToControl(Control control) {
        this.m_controlsThatNeedHoverHelp.add(control);
    }

    protected void activateHoverHelpOnControl(Control control) {
        control.addListener(12, (Listener)this.m_toolTipListener);
        control.addListener(32, (Listener)this.m_toolTipListener);
        control.addListener(5, (Listener)this.m_toolTipListener);
        control.addListener(7, (Listener)this.m_toolTipListener);
        control.addListener(3, (Listener)this.m_toolTipListener);
        control.addListener(37, (Listener)this.m_toolTipListener);
        if (control != this.m_inner && control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                this.activateHoverHelpOnControl(children[i]);
                ++i;
            }
        }
    }

    protected void doActivateHoverHelp() {
        for (Control control : this.m_controlsThatNeedHoverHelp) {
            this.activateHoverHelpOnControl(control);
        }
    }

    private void addMouseEventBehaviorToHoverHelpControl(Control c) {
        c.addListener(3, (Listener)this.hideListener);
        c.addListener(7, (Listener)this.hideListener);
        if (c instanceof Composite) {
            Control[] children = ((Composite)c).getChildren();
            int i = 0;
            while (i < children.length) {
                this.addMouseEventBehaviorToHoverHelpControl(children[i]);
                ++i;
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.m_focusBackgroundColor.dispose();
    }

    public Button addButton(int style) {
        if (this.m_inner == null) {
            this.createInnerComposite();
        }
        Button b = new Button(this.m_inner, style);
        GridData gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.grabExcessHorizontalSpace = false;
        b.setLayoutData((Object)gd);
        b.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ActionBar.this.internalFocusGained(false);
            }

            public void focusLost(FocusEvent e) {
                ActionBar.this.internalFocusLost();
            }
        });
        return b;
    }

    public Label addLabel(int style, boolean bAddHoverHelp) {
        if (this.m_inner == null) {
            this.createInnerComposite();
        }
        Label l = new Label(this.m_inner, style);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        l.setLayoutData((Object)gd);
        this.addMouseDownCausesFocus((Control)l);
        this.m_additionalLabels.add(l);
        if (bAddHoverHelp) {
            this.addHoverHelpToControl((Control)l);
        }
        return l;
    }

    public Composite addComposite(int style, boolean bAddHoverHelp) {
        if (this.m_inner == null) {
            this.createInnerComposite();
        }
        Composite c = new Composite(this.m_inner, style);
        this.addMouseDownCausesFocus((Control)c);
        this.m_additionalComposites.add((Control)c);
        if (bAddHoverHelp) {
            this.addHoverHelpToControl((Control)c);
        }
        return c;
    }

    public ToolBar addToolBar(int style) {
        if (this.m_inner == null) {
            this.createInnerComposite();
        }
        ToolBar toolbar = new ToolBar(this.m_inner, style);
        this.addMouseDownCausesFocus((Control)toolbar);
        return toolbar;
    }

    public static ActionBar getLastFocusedBar() {
        return m_lastFocus;
    }

    public void internalFocusGained(boolean bSetFocus) {
        if (this.isDisposed()) {
            return;
        }
        if (m_lastFocus != null && !m_lastFocus.isDisposed()) {
            m_lastFocus.focusLost();
        }
        this.setBackground(this.m_focusBackgroundColor);
        m_lastFocus = this;
        if (bSetFocus && !this.isFocusControl()) {
            this.setFocus();
        }
    }

    public void focusLost() {
        this.internalFocusLost();
    }

    public void internalFocusLost() {
        if (this.isDisposed()) {
            return;
        }
        this.setBackground(this.m_defaultBackgroundColor);
    }

    protected void addMouseDownCausesFocus(Control c) {
        c.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                ActionBar.this.internalFocusGained(true);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        if (c instanceof Button || c instanceof Text) {
            c.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    ActionBar.this.internalFocusGained(false);
                }

                public void focusLost(FocusEvent e) {
                }
            });
        }
    }

    public void addMouseDownCausesFocusToAllKids(Composite c) {
        Control[] kids = c.getChildren();
        int i = 0;
        while (i < kids.length) {
            if (!(kids[i] instanceof Link)) {
                this.addMouseDownCausesFocus(kids[i]);
            }
            ++i;
        }
    }

    public boolean setFocus() {
        this.internalFocusGained(false);
        return super.setFocus();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.internalFocusLost();
    }

    public void setToolTipText(String toolTipStr) {
        this.m_hoverHelp.setInformation(toolTipStr);
        this.activateHoverHelp();
    }

    public void addContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IAction)new EditActionBarAction(this));
        menuMgr.setRemoveAllWhenShown(false);
        for (Control c : this.m_controlsThatNeedHoverHelp) {
            if (c instanceof Composite) {
                this.addContextMenuToCompositeAndKids((Composite)c, menuMgr);
                continue;
            }
            Menu menu = menuMgr.createContextMenu(c);
            c.setMenu(menu);
        }
    }

    protected void addContextMenuToCompositeAndKids(Composite c, MenuManager menuMgr) {
        Control[] kids;
        Control[] controlArray = kids = c.getChildren();
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            Control kid = controlArray[n2];
            if (kid instanceof Composite) {
                this.addContextMenuToCompositeAndKids((Composite)kid, menuMgr);
            } else {
                Menu menu = menuMgr.createContextMenu(kid);
                kid.setMenu(menu);
            }
            ++n2;
        }
        Menu menu = menuMgr.createContextMenu((Control)c);
        c.setMenu(menu);
    }

    public void highlightAsRearrangeTarget(boolean bHighlight, Point displayPoint, int force) {
        Point controlPoint = this.toControl(displayPoint);
        this.m_paintInsertionMarker = bHighlight;
        this.m_insertionMarkerPoint = controlPoint;
        this.m_forceMarkerLocation = force;
        this.redraw();
    }

    public boolean isInsertAbove() {
        return this.m_insertAbove;
    }

    public void paintControl(PaintEvent e) {
        if (this.m_paintInsertionMarker && this.m_insertionMarkerPoint != null) {
            GC gc = e.gc;
            gc.setForeground(this.getDisplay().getSystemColor(3));
            Rectangle rect = this.getClientArea();
            this.m_insertAbove = this.m_forceMarkerLocation == 128 ? true : (this.m_forceMarkerLocation == 1024 ? false : this.m_insertionMarkerPoint.y <= rect.y + rect.height / 2);
            int x1 = rect.x;
            int y1 = this.m_insertAbove ? rect.y + 2 : rect.y + rect.height - 1;
            int x2 = x1 + rect.width;
            int y2 = y1;
            gc.drawLine(x1, y1, x2, y2);
            gc.drawLine(x1, --y1, x2, --y2);
        }
    }

    public Vector<Control> getInnerCompositesAndLabels() {
        Vector<Control> v = new Vector<Control>(this.m_additionalComposites);
        v.add((Control)this.m_inner);
        for (Label label : this.m_additionalLabels) {
            v.add((Control)label);
        }
        return v;
    }

    public Composite getInnerComposite() {
        return this.m_inner;
    }

    protected class EditActionBarAction
    extends Action {
        ActionBar m_actionBar;

        public EditActionBarAction(ActionBar actionBar2) {
            this.setText(String.valueOf(Messages.ActionBar_EditAction) + "...");
            this.setToolTipText(Messages.ActionBar_EditActionTooltipText);
            this.m_actionBar = actionBar2;
        }

        public void run() {
            IDLVisTool visTool = (IDLVisTool)this.m_actionBar.getData("visTool");
            String sigId = (String)this.m_actionBar.getData("sigID");
            ActionSig sig = visTool.getActionSig(sigId);
            ToolPaletteView.getInstance().startActionBarEditMode();
            ActionBar.this.m_actionBarComposite.showActionBarEditDialog(visTool, sig, false);
        }
    }

    class ToolTipOwnerControlListener
    implements Listener {
        protected int TOP_PAD = 22;
        private Point m_showLocation;

        ToolTipOwnerControlListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 1: 
                case 3: 
                case 5: 
                case 12: 
                case 37: {
                    this.hideit(event);
                    break;
                }
                case 32: {
                    Point hoverHelpSize = ActionBar.this.m_hoverHelp.computeSizeHint();
                    ActionBar.this.m_hoverHelp.setSize(hoverHelpSize.x, hoverHelpSize.y);
                    Control c = (Control)event.widget;
                    Point location = c.toDisplay(event.x, event.y);
                    location.y += this.TOP_PAD;
                    location = this.adjustLocationForScreenSize(location, hoverHelpSize);
                    ActionBar.this.m_hoverHelp.setLocation(location);
                    this.m_showLocation = location;
                    ActionBar.this.m_hoverHelp.setVisible(true);
                    break;
                }
                case 7: {
                    if (!ActionBar.this.m_inner.isDisposed() && ActionBar.this.m_hoverHelp.getBounds().contains(ActionBar.this.m_inner.toDisplay(event.x, event.y))) break;
                    ActionBar.this.m_hoverHelp.setVisible(false);
                }
            }
        }

        private void hideit(Event event) {
            if (event.type == 5 && this.m_showLocation != null) {
                Point mlocation = ActionBar.this.m_inner.toDisplay(event.x, event.y);
                if (this.m_showLocation.y - this.TOP_PAD <= mlocation.y && mlocation.y <= this.m_showLocation.y && mlocation.x >= this.m_showLocation.x) {
                    return;
                }
            }
            ActionBar.this.m_hoverHelp.setVisible(false);
        }

        private Point adjustLocationForScreenSize(Point location, Point hoverHelpSize) {
            Point returnPoint = new Point(location.x, location.y);
            Rectangle scrSize = ActionBar.this.m_inner.getDisplay().getBounds();
            if (location.x + hoverHelpSize.x > scrSize.width) {
                returnPoint.x -= location.x + hoverHelpSize.x - scrSize.width;
            }
            if (location.y + hoverHelpSize.y > scrSize.height) {
                returnPoint.y -= location.y + hoverHelpSize.y - scrSize.height;
            }
            return returnPoint;
        }
    }

    class TooltipHideListener
    implements Listener {
        TooltipHideListener() {
        }

        public void handleEvent(Event event) {
            if (event.widget instanceof Control) {
                Control c = (Control)event.widget;
                Shell shell = c.getShell();
                switch (event.type) {
                    case 3: {
                        ActionBar.this.m_hoverHelp.setVisible(false);
                        break;
                    }
                    case 7: {
                        Rectangle rect = shell.getBounds();
                        rect.x += 5;
                        rect.y += 5;
                        rect.width -= 10;
                        rect.height -= 10;
                        if (rect.contains(c.getDisplay().getCursorLocation())) break;
                        ActionBar.this.m_hoverHelp.setVisible(false);
                    }
                }
            }
        }
    }
}

