/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette;

import com.rsi.idldt.toolpalette.ToolPalette2IDLComms;
import com.rsi.idldt.toolpalette.ToolPalettePlugin;
import com.rsi.idldt.toolpalette.internal.ui.Messages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigator;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolPaletteAssociationHandler
implements Runnable {
    protected void makeWorkbenchAssociationsWithIOpen(Vector<String> fileExtensionsIn) {
        StringBuffer commaSeparatedFileExtensions = new StringBuffer();
        try {
            Iterator<String> iterator = fileExtensionsIn.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                String suffix = iterator.next();
                suffix = suffix.replaceAll("[.]", "");
                commaSeparatedFileExtensions.append(suffix);
                if (!iterator.hasNext()) continue;
                commaSeparatedFileExtensions.append(",");
            }
            String fileExtensions = commaSeparatedFileExtensions.toString();
            if (fileExtensions.trim().length() == 0) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            sb.append("<plugin>");
            sb.append("<extension point=\"org.eclipse.ui.editors\"");
            sb.append("    id=\"com.rsi.idldt.toolpalette.IDLiOpenLauncher\">");
            sb.append("<editor ");
            sb.append("  id=\"com.rsi.idldt.toolpalette.iopen.runner\"");
            sb.append("  icon=\"icons/iOpen16.png\"");
            sb.append("  name=\"iOpen\"");
            sb.append("  extensions=\"" + fileExtensions + "\"");
            sb.append("  default=\"true\"");
            sb.append("  launcher=\"com.rsi.idldt.toolpalette.internal.ui.IDLiOpenLauncher\">");
            sb.append("</editor>");
            sb.append("</extension>");
            sb.append("<extension point=\"com.rsi.idldt.ui.openFilterStrings\"> ");
            Iterator<String> iterator2 = fileExtensionsIn.iterator();
            while (iterator2.hasNext()) {
                String filterName = iterator2.next();
                String suffix = iterator2.next();
                suffix = suffix.replaceAll("[,]", ";*");
                sb.append("  <filter name=\"" + filterName + "\" value=\"*" + suffix + "\"/>");
            }
            sb.append("</extension>");
            sb.append("</plugin>");
            this.addExtension(sb.toString());
        }
        catch (Exception e) {
            Status status = new Status(4, "com.rsi.idldt.toolpalette", 0, e.getLocalizedMessage(), (Throwable)e);
            ToolPalettePlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    protected void addExtension(String xml) throws UnsupportedEncodingException {
        IExtensionRegistry reg = RegistryFactory.getRegistry();
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        Object key = ((ExtensionRegistry)reg).getTemporaryUserToken();
        Bundle bundle = ToolPalettePlugin.getDefault().getBundle();
        IContributor contributor = ContributorFactoryOSGi.createContributor((Bundle)bundle);
        try {
            reg.addContribution((InputStream)is, contributor, false, null, null, key);
        }
        catch (Throwable throwable) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {}
    }

    @Override
    public void run() {
        ToolPalette2IDLComms.waitForIDLToBecomeActive();
        ToolPalettePlugin.getDefault().createExistingVisDataModel();
        RegistryUpdateJob j = new RegistryUpdateJob();
        j.setPriority(20);
        j.schedule();
    }

    private class RegistryUpdateJob
    extends Job {
        public RegistryUpdateJob() {
            super(Messages.ToolPaletteAssociationHandler_RegisteringIOpenFileAssociations);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            ToolPaletteAssociationHandler.this.makeWorkbenchAssociationsWithIOpen(ToolPalette2IDLComms.getIOpenFileExtensions());
            this.refresh();
            return Status.OK_STATUS;
        }

        protected void refresh() {
            Job job = new Job(Messages.ToolPaletteAssociationHandler_RefreshingWorkspace){

                public IStatus run(IProgressMonitor monitor) {
                    if (PlatformUI.getWorkbench().getDisplay() != null && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                IViewReference[] views;
                                IWorkbenchPage wbp;
                                IWorkbenchWindow wbw;
                                IWorkbench wb = PlatformUI.getWorkbench();
                                if (wb != null && (wbw = wb.getActiveWorkbenchWindow()) != null && (wbp = wbw.getActivePage()) != null && (views = wbp.getViewReferences()) != null && views.length > 0) {
                                    int i = 0;
                                    while (i < views.length) {
                                        CommonNavigator cn;
                                        String id = views[i].getId();
                                        if ("org.eclipse.ui.views.ResourceNavigator".equals(id)) {
                                            ResourceNavigator rn = (ResourceNavigator)views[i].getView(false);
                                            if (rn != null && rn.getViewer() != null) {
                                                rn.getViewer().refresh();
                                            }
                                        } else if ("org.eclipse.ui.navigator.ProjectExplorer".equals(id) && (cn = (CommonNavigator)views[i].getView(false)) != null && cn.getCommonViewer() != null) {
                                            cn.getCommonViewer().refresh();
                                        }
                                        ++i;
                                    }
                                }
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            job.setSystem(true);
            job.schedule();
        }
    }
}

