/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.toolpalette.IDLCommandHelper;
import com.rsi.idldt.toolpalette.ToolPalettePlugin;
import com.rsi.idldt.ui.UIPreferenceManager;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolPalette2IDLComms {
    protected static IDLCommandHelper m_cmdHelper = null;
    protected static IIDLProcessProxy m_idlProcess = null;

    public static String getAppUserDirectory() {
        ToolPalette2IDLComms.waitForIDLToBecomeActive();
        String tempIDLVar1 = "_idl_hidden_wbv_appUserDir1";
        String tempIDLVar2 = "_idl_hidden_wbv_appUserDir2";
        String command = String.valueOf(tempIDLVar1) + " = APP_USER_DIR_QUERY('itt', 'pref', /RESTRICT_IDL_RELEASE, /RESTRICT_FAMILY) & " + tempIDLVar2 + " = " + tempIDLVar1 + "[0]";
        m_cmdHelper.silentExecuteStringAndWait(command);
        String value = m_cmdHelper.getIdlVariableValueAsString(tempIDLVar2);
        ToolPalette2IDLComms.delvar(tempIDLVar1);
        ToolPalette2IDLComms.delvar(tempIDLVar2);
        return value;
    }

    public static Vector<String> getIOpenFileExtensions() {
        Vector<String> extensions = new Vector<String>();
        extensions = new Vector();
        String valueReturnedFromIDL = null;
        try {
            String tempIDLVar = "_idl_hidden_wbv_iopen_suffixes";
            String command = String.valueOf(tempIDLVar) + "=strjoin(((igetreaders())[1:2,*])[*],'@')";
            m_cmdHelper.silentExecuteStringAndWait(command);
            valueReturnedFromIDL = m_cmdHelper.getIdlVariableValueAsString(tempIDLVar);
            ToolPalette2IDLComms.delvar(tempIDLVar);
            String[] tokens = valueReturnedFromIDL.split("@");
            int i = 0;
            while (i < tokens.length) {
                String filterName = tokens[i].trim();
                String suffix = tokens[i + 1].trim();
                if (!(suffix.equalsIgnoreCase(".isv") || suffix.equalsIgnoreCase(".sav") || extensions.contains(suffix))) {
                    extensions.add(filterName);
                    extensions.add(suffix);
                }
                i += 2;
            }
        }
        catch (Exception exception) {
            String message = "Error processing IOPEN file extensions returned from IDL.\n";
            message = valueReturnedFromIDL != null ? String.valueOf(message) + "Data returned from igetReaders(): \n\n" + valueReturnedFromIDL : String.valueOf(message) + "IDL returned no data from the command:  igetReaders()";
            Status status = new Status(4, "com.rsi.idldt.toolpalette", 0, message, null);
            ToolPalettePlugin.getDefault().getLog().log((IStatus)status);
        }
        return extensions;
    }

    public static String getIdlVariableValueAsString(String idlVariableName) {
        return m_cmdHelper.getIdlVariableValueAsString(idlVariableName);
    }

    public static void waitForIDLToBecomeActive() {
        while (!Thread.interrupted() && m_idlProcess == null) {
            try {
                Thread.sleep(2000L);
                m_idlProcess = IDLProcessManager.getActiveProcess();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (Exception exception) {
                return;
            }
        }
        m_cmdHelper = new IDLCommandHelper(m_idlProcess);
    }

    public static void silentExecuteString(String command) {
        if (m_idlProcess == null) {
            return;
        }
        IDLProcessManager.queueSilentExecuteString((String)command);
    }

    public static void silentExecuteStringAndWait(String command) {
        if (m_idlProcess == null) {
            return;
        }
        m_cmdHelper.silentExecuteStringAndWait(command);
    }

    public static void executeString(String command) {
        if (m_idlProcess == null) {
            return;
        }
        IDLProcessManager.queueExecuteString((String)command);
    }

    public static void callIOpen(IPath file) {
        String idlRoutineToCall = "iOpen";
        String iOpenCommand = String.valueOf(idlRoutineToCall) + ", '" + file.toOSString() + "', /WBOPEN";
        boolean bVizOnOpen = true;
        IPreferenceStore store = UIPreferenceManager.getPreferenceStore();
        if (store != null) {
            bVizOnOpen = store.getBoolean("IDLDT_AUTOVIS_IMAGES_ON_OPEN");
        }
        if (bVizOnOpen) {
            iOpenCommand = String.valueOf(iOpenCommand) + ", /VISUALIZE";
        }
        ToolPalette2IDLComms.executeString(iOpenCommand);
    }

    protected static String createIDLVariableNameForFile(IPath file) {
        String name = file.lastSegment();
        name = name.replaceAll("\\.", "_");
        return name;
    }

    public static void delvar(String variableName) {
        if (!IDLProcessManager.isDebugging()) {
            String command = "delvar, " + variableName;
            ToolPalette2IDLComms.silentExecuteString(command);
        }
    }
}

