/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette;

import com.rsi.idldt.toolpalette.ActionSig;
import com.rsi.idldt.toolpalette.IDLVisTool;
import com.rsi.idldt.toolpalette.ToolPalette2IDLComms;
import com.rsi.idldt.toolpalette.ToolPalettePlugin;
import com.rsi.idldt.toolpalette.internal.ui.Messages;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolCatalogParser {
    protected static ToolCatalogParser m_instance = null;
    protected static final String CATALOG_FNAME = "vis_tools_catalog.xml";
    protected final String ELEM_TOOL_SHOW_ORDER = "tool_show_order";
    protected final String ELEM_TOOL = "tool";
    protected final String ELEM_TOOLCATALOG = "ToolCatalog";
    protected final String ELEM_SYSTEM_CUSTOMIZATIONS = "System_Customizations";
    protected final String ELEM_ACTION_ORDER = "action_order";
    protected final String ELEM_ADD_ACTION_BARS = "add_action_bars";
    protected final String ELEM_ACTION = "action";
    protected final String ELEM_ARGS = "args";
    protected final String ELEM_DESCRIPTION = "description";
    protected final String ELEM_TITLE = "title";
    protected final String ELEM_STATIC_ARGS = "static_args";
    protected final String ELEM_OVERPLOT_CMD = "overplot_command";
    protected final String ATTR_ICON = "icon";
    protected final String ATTR_ID = "id";
    protected final String ATTR_NAME = "name";
    protected final String ATTR_PROCNAME = "procname";
    protected final String ATTR_VERSION = "version";
    protected static InputStream m_systemCatalogFile;
    protected static File m_userCatalogFile;
    protected String m_path;
    protected int m_systemOrUser;
    protected PrintWriter m_output;
    protected String m_indent = "";
    protected Document m_systemDoc;
    protected Document m_userDoc;
    protected Vector<IDLVisTool> m_systemVec;
    protected Vector<Integer> m_showOrder;
    protected boolean m_bWriteMinimalSystemCustomizations;
    protected boolean m_bPerformingImport = false;
    private static final char[] c;
    private static final String[] expansion;
    protected ReplaceExistingSystemToolAction m_systemReplaceAction;

    static {
        c = new char[]{'<', '>', '&', '\"'};
        expansion = new String[]{"&lt;", "&gt;", "&amp;", "&quot;"};
    }

    protected ToolCatalogParser() {
    }

    public static ToolCatalogParser getInstance() {
        if (m_instance == null) {
            m_instance = new ToolCatalogParser();
        }
        return m_instance;
    }

    protected void parseCatalogs() {
        m_systemCatalogFile = this.getSystemCatalogFile();
        this.m_systemDoc = this.parseCatalog(m_systemCatalogFile, Messages.ToolCatalogParser_VisMgrPluginCatalog);
        m_userCatalogFile = this.openCatalogFileForRead(this.getUserCatalogFilename());
        if (m_userCatalogFile != null) {
            try {
                this.m_userDoc = this.parseCatalog(new FileInputStream(m_userCatalogFile), this.getUserCatalogFilename());
            }
            catch (Exception exception) {
                this.m_userDoc = null;
            }
        }
    }

    protected InputStream getSystemCatalogFile() {
        try {
            URL bundleURL = ToolPalettePlugin.getDefault().getBundle().getEntry("/vis_tools_catalog.xml");
            InputStream is = bundleURL.openStream();
            if (is != null) {
                return is;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String getUserCatalogFilename() {
        String fs = System.getProperty("file.separator");
        String fname = String.valueOf(ToolPalette2IDLComms.getAppUserDirectory()) + fs + CATALOG_FNAME;
        return fname;
    }

    protected File openCatalogFileForRead(String fname) {
        File f = new File(fname);
        if (f.exists() && f.canRead()) {
            return f;
        }
        return null;
    }

    protected File openUserCatalogFileForWrite() {
        File f = new File(this.getUserCatalogFilename());
        if (f.exists() && f.canWrite()) {
            f.delete();
            f = new File(this.getUserCatalogFilename());
        }
        try {
            f.createNewFile();
        }
        catch (IOException iOException) {
            this.reportErrorOpeningCatalogFileForWrite();
            return null;
        }
        return f;
    }

    protected void reportErrorOpeningCatalogFileForWrite() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                String ls = System.getProperty("line.separator");
                StringBuilder sb = new StringBuilder();
                sb.append(String.valueOf(Messages.ToolCatalogParser_UnableToOpenFileForWrite) + ls + ls + "   " + ToolCatalogParser.this.getUserCatalogFilename());
                sb.append(String.valueOf(ls) + ls + Messages.ToolCatalogParser_ToolActionModificationsCannotBeSaved);
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ToolCatalogParser_ErrorSavingToolCatalog, (String)sb.toString());
            }
        });
    }

    protected void reportErrorParsingCatalog(Exception e, String fname) {
        String msg = String.valueOf(Messages.ToolCatalogParser_XMLErrorParsingFile) + fname;
        if (e != null) {
            msg = String.valueOf(msg) + "\n" + e.getLocalizedMessage();
        }
        Status status = new Status(4, "com.rsi.idldt.toolpalette", 0, msg, (Throwable)e);
        ToolPalettePlugin.getDefault().getLog().log((IStatus)status);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable((IStatus)status){
            private final /* synthetic */ IStatus val$status;
            {
                this.val$status = iStatus;
            }

            public void run() {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ToolCatalogParser_ErrorReadingCatalog, (String)this.val$status.getMessage());
            }
        });
    }

    protected Document parseCatalog(InputStream file, String fname) {
        Document doc = null;
        if (file == null) {
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(file);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            this.reportErrorParsingCatalog(null, fname);
        }
        catch (ParserConfigurationException e) {
            this.reportErrorParsingCatalog(e, fname);
        }
        catch (SAXException e) {
            this.reportErrorParsingCatalog(e, fname);
        }
        catch (IOException e) {
            this.reportErrorParsingCatalog(e, fname);
        }
        return doc;
    }

    protected Vector<IDLVisTool> processCatalogs() {
        Vector<IDLVisTool> systemVec = null;
        this.m_path = null;
        this.m_systemOrUser = 0;
        systemVec = this.processDoc(this.m_systemDoc);
        Vector<IDLVisTool> userVec = null;
        this.m_systemOrUser = 1;
        if (m_userCatalogFile != null) {
            this.m_path = m_userCatalogFile.getParent();
            userVec = this.processDoc(this.m_userDoc);
        }
        this.m_systemVec = systemVec;
        this.rememberSystemActionOrder(systemVec);
        this.processSystemCustomizations(systemVec, this.m_userDoc);
        Vector<IDLVisTool> mergedVec = this.mergeVectors(systemVec, userVec);
        this.m_showOrder = this.processToolShowOrder(mergedVec, this.m_userDoc);
        this.m_systemDoc = null;
        this.m_userDoc = null;
        return mergedVec;
    }

    protected void rememberSystemActionOrder(Vector<IDLVisTool> systemVec) {
        for (IDLVisTool vt : systemVec) {
            if (!vt.isSystemDefined()) continue;
            vt.rememberSystemActionOrder();
        }
    }

    public Vector<IDLVisTool> getSystemVisTools() {
        return this.m_systemVec;
    }

    public Vector<IDLVisTool> getVisTools() {
        this.parseCatalogs();
        Vector<IDLVisTool> visTools = this.processCatalogs();
        return visTools;
    }

    public Vector<Integer> getVisToolShowOrder() {
        return this.m_showOrder;
    }

    protected Vector<Integer> processToolShowOrder(Vector<IDLVisTool> mergedTools, Document userDoc) {
        Vector<Integer> v;
        block6: {
            block5: {
                if (userDoc == null) {
                    Vector<Integer> v2 = new Vector<Integer>();
                    int i = 0;
                    while (i < mergedTools.size()) {
                        v2.add(new Integer(i));
                        ++i;
                    }
                    return v2;
                }
                v = new Vector<Integer>();
                NodeList nodeList = userDoc.getElementsByTagName("tool_show_order");
                Element vistool_show_order = (Element)nodeList.item(0);
                if (vistool_show_order == null) break block5;
                nodeList = vistool_show_order.getElementsByTagName("tool");
                if (nodeList == null) break block6;
                int i = 0;
                while (i < nodeList.getLength()) {
                    int idx;
                    Element e = (Element)nodeList.item(i);
                    String tool_name = e.getAttribute("name");
                    if (tool_name != null && (idx = this.findVisToolIndex(mergedTools, tool_name)) > -1) {
                        v.add(new Integer(idx));
                    }
                    ++i;
                }
                break block6;
            }
            int i = 0;
            while (i < mergedTools.size()) {
                v.add(new Integer(i));
                ++i;
            }
        }
        return v;
    }

    protected int findVisToolIndex(Vector<IDLVisTool> mergedTools, String tool_name) {
        int idx = -1;
        int i = 0;
        while (i < mergedTools.size()) {
            IDLVisTool vt = mergedTools.get(i);
            if (vt.getToolName().equalsIgnoreCase(tool_name)) {
                idx = i;
                break;
            }
            ++i;
        }
        return idx;
    }

    protected void processSystemCustomizations(Vector<IDLVisTool> systemVec, Document doc) {
        if (doc == null) {
            return;
        }
        NodeList nodeList = doc.getElementsByTagName("ToolCatalog");
        if (nodeList.getLength() == 0) {
            return;
        }
        Element sys_custom = this.findElement((Element)nodeList.item(0), "System_Customizations");
        if (sys_custom != null) {
            nodeList = sys_custom.getElementsByTagName("add_action_bars");
            if (nodeList != null && nodeList.getLength() > 0) {
                this.processAddActionBarsToSystemTools(systemVec, null, (Element)nodeList.item(0));
            }
            if ((nodeList = sys_custom.getElementsByTagName("action_order")) != null && nodeList.getLength() > 0) {
                this.processActionOrder(systemVec, (Element)nodeList.item(0));
            }
        }
    }

    protected void processAddActionBarsToSystemTools(Vector<IDLVisTool> toolVec, Vector<Integer> showOrder, Element add_action_bars) {
        NodeList nodeList = add_action_bars.getElementsByTagName("tool");
        int i = 0;
        while (i < nodeList.getLength()) {
            boolean bIsToolActionsModified;
            IDLVisTool vt;
            Element tool = (Element)nodeList.item(i);
            String toolName = tool.getAttribute("name");
            if (toolName != null && (vt = IDLVisTool.findTool(toolVec, toolName)) != null && (bIsToolActionsModified = this.processToolActions(tool.getChildNodes(), vt)) && vt.isSystemDefined() && showOrder != null) {
                int idx = 0;
                int toolIndex = -1;
                for (IDLVisTool index : toolVec) {
                    if (index == vt) {
                        toolIndex = idx;
                        break;
                    }
                    ++idx;
                }
                if (toolIndex > -1 && this.toolIsHidden(showOrder, toolIndex)) {
                    showOrder.add(new Integer(toolIndex));
                }
            }
            ++i;
        }
    }

    protected boolean toolIsHidden(Vector<Integer> showOrder, int toolIndex) {
        for (Integer visibleToolIndex : showOrder) {
            if (visibleToolIndex != toolIndex) continue;
            return false;
        }
        return true;
    }

    protected void processActionOrder(Vector<IDLVisTool> toolVec, Element action_order) {
        NodeList nodeList = action_order.getElementsByTagName("tool");
        int i = 0;
        while (i < nodeList.getLength()) {
            NodeList nl;
            Element tool = (Element)nodeList.item(i);
            String toolName = tool.getAttribute("name");
            if (toolName != null && (nl = tool.getElementsByTagName("action")).getLength() > 0) {
                Vector<String> showOrderVector = new Vector<String>();
                int j = 0;
                while (j < nl.getLength()) {
                    Element action = (Element)nl.item(j);
                    showOrderVector.add(action.getAttribute("id").toLowerCase());
                    ++j;
                }
                IDLVisTool vt = IDLVisTool.findTool(toolVec, toolName);
                if (vt != null) {
                    vt.setActionShowOrder(showOrderVector);
                }
            }
            ++i;
        }
    }

    protected Vector<IDLVisTool> processDoc(Document doc) {
        if (doc == null) {
            return null;
        }
        Vector<IDLVisTool> v = new Vector<IDLVisTool>();
        NodeList children = doc.getChildNodes();
        int n = children.getLength();
        int i = 0;
        while (i < n) {
            Element e;
            String tagName;
            Node child = children.item(i);
            if (child instanceof Element && (tagName = (e = (Element)child).getTagName()).equalsIgnoreCase("ToolCatalog")) {
                children = e.getChildNodes();
                this.processToolCatalog(v, children);
                break;
            }
            ++i;
        }
        return v;
    }

    protected String getFullPathname(String fname) {
        if (this.m_path == null) {
            return fname;
        }
        if (IDLVisTool.isPathFullyQualified(fname)) {
            return fname;
        }
        String fs = System.getProperty("file.separator");
        if (!this.m_path.endsWith(fs)) {
            this.m_path = String.valueOf(this.m_path) + fs;
        }
        String pathQualifiedName = this.fixFileSeparators(String.valueOf(this.m_path) + fname);
        return pathQualifiedName;
    }

    protected String fixFileSeparators(String in) {
        String out = in.replaceAll("\\\\", "/");
        return out;
    }

    protected void processToolCatalog(Vector<IDLVisTool> vector, NodeList children) {
        int n = children.getLength();
        int i = 0;
        while (i < n) {
            Element e;
            String tagName;
            Node child = children.item(i);
            if (child instanceof Element && (tagName = (e = (Element)child).getTagName()).equalsIgnoreCase("tool")) {
                String toolName = e.getAttribute("name");
                String iconName = e.getAttribute("icon");
                iconName = iconName == null || iconName.trim().length() == 0 ? null : this.getFullPathname(iconName);
                IDLVisTool vt = new IDLVisTool(toolName, this.m_systemOrUser, iconName);
                vector.add(vt);
                this.processToolActions(e.getChildNodes(), vt);
            }
            ++i;
        }
    }

    protected boolean processToolActions(NodeList children, IDLVisTool vt) {
        boolean bActionsWereModified = false;
        int n = children.getLength();
        int i = 0;
        while (i < n) {
            Element e;
            String tagName;
            Node child = children.item(i);
            if (child instanceof Element && (tagName = (e = (Element)child).getTagName()).equalsIgnoreCase("action")) {
                String procName = e.getAttribute("procname");
                ArrayList<String> argNames = this.getArgs(e);
                String staticArgs = this.getStringValueFromElement(e, "static_args");
                String description = this.getStringValueFromElement(e, "description");
                String title = this.getStringValueFromElement(e, "title");
                String overplotcmd = this.getStringValueFromElement(e, "overplot_command");
                if (title == null) {
                    title = vt.generateUniqueActionTitle(null);
                }
                boolean bOKToAccpetNewSig = true;
                ActionSig sig = vt.getActionSig(title);
                if (sig != null && this.m_bPerformingImport) {
                    this.m_systemReplaceAction.showPromptToReplaceExistingSystemAction(vt.getToolName(), title);
                    bOKToAccpetNewSig = this.m_systemReplaceAction.isYes();
                    if (bOKToAccpetNewSig) {
                        vt.removeActionSigFromShowOrder(title);
                        if (sig.isUserDefined()) {
                            vt.removeActionSignature(title);
                        }
                    }
                }
                if (bOKToAccpetNewSig) {
                    vt.addActionSignature(ActionSig.ActionType.ITOOL, this.m_systemOrUser, procName, overplotcmd, argNames, staticArgs, description, title);
                    vt.addActionSigToShowOrder(title);
                    bActionsWereModified = true;
                }
            }
            ++i;
        }
        return bActionsWereModified;
    }

    protected Element findElement(Element action, String childName) {
        NodeList nl = action.getElementsByTagName(childName);
        int n = nl.getLength();
        if (n > 0) {
            Node child = nl.item(0);
            return (Element)child;
        }
        return null;
    }

    protected String getNodeValue(Element e) {
        NodeList kids = e.getChildNodes();
        if (kids == null) {
            return "";
        }
        if (kids.getLength() == 0) {
            return "";
        }
        return kids.item(0).getNodeValue().trim();
    }

    ArrayList<String> getArgs(Element action) {
        ArrayList<String> list = new ArrayList<String>();
        Element e = this.findElement(action, "args");
        if (e != null) {
            String args = this.getNodeValue(e);
            String[] s = args.split(",");
            int i = 0;
            while (i < s.length) {
                list.add(s[i]);
                ++i;
            }
        }
        return list;
    }

    protected String getStringValueFromElement(Element action, String elementName) {
        String value = null;
        Element e = this.findElement(action, elementName);
        if (e != null) {
            value = this.getNodeValue(e);
        }
        if (value != null) {
            value = ToolCatalogParser.removeDuplicateWhitespace(value);
        }
        return value;
    }

    public static String removeDuplicateWhitespace(String inputStr) {
        String patternStr = "\\s+";
        String replaceStr = " ";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(inputStr);
        return matcher.replaceAll(replaceStr);
    }

    private boolean performImport(Vector<IDLVisTool> visToolsVec, Vector<Integer> showOrder, Vector<IDLVisTool> importVec, Document importDoc) {
        Element sys_custom;
        int lastShowIndex = visToolsVec.size() - 1;
        this.m_bPerformingImport = true;
        this.m_systemReplaceAction = new ReplaceExistingSystemToolAction();
        this.m_systemOrUser = 1;
        ReplaceToolAction replaceAction = new ReplaceToolAction();
        for (IDLVisTool visTool : importVec) {
            IDLVisTool tool = IDLVisTool.findTool(visToolsVec, visTool.getToolName());
            if (tool == null) {
                visToolsVec.add(visTool);
                showOrder.add(new Integer(++lastShowIndex));
                continue;
            }
            replaceAction.showPromptToReplaceExistingToolAndActions(visTool.getToolName());
            if (!replaceAction.isYes()) continue;
            int index = visToolsVec.indexOf(tool);
            visToolsVec.remove(index);
            visToolsVec.add(index, visTool);
        }
        NodeList nodeList = importDoc.getElementsByTagName("ToolCatalog");
        if (nodeList.getLength() > 0 && (sys_custom = this.findElement((Element)nodeList.item(0), "System_Customizations")) != null && (nodeList = sys_custom.getElementsByTagName("add_action_bars")) != null && nodeList.getLength() > 0) {
            this.processAddActionBarsToSystemTools(visToolsVec, showOrder, (Element)nodeList.item(0));
        }
        this.m_bPerformingImport = false;
        this.m_systemReplaceAction = null;
        return true;
    }

    protected Vector<IDLVisTool> mergeVectors(Vector<IDLVisTool> systemVec, Vector<IDLVisTool> userVec) {
        if (systemVec == null) {
            return userVec;
        }
        if (userVec == null) {
            return systemVec;
        }
        Vector<IDLVisTool> mergedVec = new Vector<IDLVisTool>();
        for (IDLVisTool visTool : systemVec) {
            mergedVec.add(visTool);
        }
        for (IDLVisTool visTool : userVec) {
            mergedVec.add(visTool);
        }
        return mergedVec;
    }

    protected void writeln(String line) {
        this.m_output.println(String.valueOf(this.m_indent) + line);
    }

    protected void writelnEncoded(String value) {
        this.writeln(ToolCatalogParser.HTMLEncode(value));
    }

    protected void flush() {
        this.m_output.flush();
    }

    protected void writeComment(String line) {
        this.m_output.println(String.valueOf(this.m_indent) + "<!-- " + line + " -->");
    }

    protected void changeIndent(int theAmt) {
        int amt = theAmt;
        if (amt > 0) {
            int i = 0;
            while (i < amt) {
                this.m_indent = String.valueOf(this.m_indent) + " ";
                ++i;
            }
        } else if ((amt *= -1) > this.m_indent.length()) {
            this.m_indent = "";
        } else {
            int end = this.m_indent.length() - amt;
            this.m_indent = this.m_indent.substring(0, end);
        }
    }

    protected void increaseIndent() {
        this.changeIndent(4);
    }

    protected void decreaseIndent() {
        this.changeIndent(-4);
    }

    public void writeUserCatalog(File file, Vector<IDLVisTool> visTools, Vector<Integer> the_visTool_showOrder) {
        File f;
        if (visTools == null) {
            return;
        }
        Vector<Integer> visTool_showOrder = the_visTool_showOrder;
        if (visTool_showOrder == null) {
            this.m_bWriteMinimalSystemCustomizations = true;
            visTool_showOrder = new Vector();
            int i = 0;
            while (i < visTools.size()) {
                visTool_showOrder.add(new Integer(i));
                ++i;
            }
        } else {
            this.m_bWriteMinimalSystemCustomizations = false;
        }
        if (file == null) {
            f = this.openUserCatalogFileForWrite();
            if (f == null) {
                return;
            }
        } else {
            f = file;
        }
        try {
            this.m_output = new PrintWriter(f, "UTF8");
        }
        catch (IOException iOException) {
            this.reportErrorOpeningCatalogFileForWrite();
            return;
        }
        try {
            try {
                this.writeln("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                this.writeln("");
                SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, MMM d, yyyy  HH:mm:ss");
                Date date = new Date();
                this.writeComment(String.valueOf(Messages.ToolCatalogParser_Written) + dateFormat.format(date));
                this.writeln("");
                this.writeln("<ToolCatalog version=\"1.0\">");
                this.writeln("");
                this.increaseIndent();
                this.writeComment("=====================================================================");
                this.writeComment(Messages.ToolCatalogParser_AdditionsToTheToolPalette);
                this.writeComment("=====================================================================");
                this.writeUserTools(visTools, visTool_showOrder);
                this.writeln("");
                this.writeComment("=====================================================================");
                this.writeComment(Messages.ToolCatalogParser_CustomizationsToTheSystemTools);
                this.writeComment("=====================================================================");
                this.writeSystemCustomizations(visTools);
                this.writeln("");
                this.writeComment("=====================================================================");
                this.writeComment(Messages.ToolCatalogParser_ToolShowOrder);
                this.writeComment("=====================================================================");
                this.writeVisToolShowOrder(visTools, visTool_showOrder);
                this.decreaseIndent();
                this.writeln("");
                this.writeln("</ToolCatalog>");
            }
            catch (Exception exception) {
                this.reportErrorOpeningCatalogFileForWrite();
                this.flush();
                this.m_output.close();
            }
        }
        finally {
            this.flush();
            this.m_output.close();
        }
    }

    protected String trimIconFilename(String theIconFilename) {
        String iconFilename = theIconFilename;
        if (iconFilename == null) {
            return null;
        }
        iconFilename = this.fixFileSeparators(iconFilename);
        String fs = System.getProperty("file.separator");
        if (Platform.getOS().equals("win32") && iconFilename.length() > 3 && iconFilename.charAt(0) == '/' && iconFilename.charAt(2) == ':') {
            iconFilename = iconFilename.substring(1);
        }
        String prefix = String.valueOf(ToolPalette2IDLComms.getAppUserDirectory()) + fs;
        int endIndex = iconFilename.indexOf(prefix = this.fixFileSeparators(prefix));
        if (endIndex > -1) {
            return iconFilename.substring(prefix.length());
        }
        return iconFilename;
    }

    protected void writeActionSig(ActionSig actionsig) {
        this.writeln("<action procname=\"" + actionsig.m_procName + "\">");
        this.increaseIndent();
        String argnames = actionsig.getCommaDelimitedArgNames();
        if (argnames != null) {
            this.writeln("<args> " + argnames + " </" + "args" + ">");
        }
        if (actionsig.m_overplotCmd != null && actionsig.m_overplotCmd.trim().length() > 0) {
            this.writeln("<overplot_command>");
            this.increaseIndent();
            this.writelnEncoded(actionsig.m_overplotCmd);
            this.decreaseIndent();
            this.writeln("</overplot_command>");
        }
        if (actionsig.m_staticArgs != null && actionsig.m_staticArgs.trim().length() > 0) {
            this.writeln("<static_args>");
            this.increaseIndent();
            this.writelnEncoded(actionsig.m_staticArgs);
            this.decreaseIndent();
            this.writeln("</static_args>");
        }
        if (actionsig.m_title != null && actionsig.m_title.trim().length() > 0) {
            this.writeln("<title>");
            this.increaseIndent();
            this.writelnEncoded(actionsig.m_title);
            this.decreaseIndent();
            this.writeln("</title>");
        }
        if (actionsig.m_desc != null && actionsig.m_desc.trim().length() > 0) {
            this.writeln("<description>");
            this.increaseIndent();
            this.writelnEncoded(actionsig.m_desc);
            this.decreaseIndent();
            this.writeln("</description>");
        }
        this.decreaseIndent();
        this.writeln("</action>");
    }

    protected void writeUserTools(Vector<IDLVisTool> visTools, Vector<Integer> visTools_showOrder) {
        int i = 0;
        while (i < visTools_showOrder.size()) {
            Integer intIdx = visTools_showOrder.get(i);
            IDLVisTool tool = visTools.get(intIdx);
            if (!tool.isSystemDefined()) {
                String iconFilename = this.trimIconFilename(tool.getIconFilename());
                if (iconFilename == null) {
                    iconFilename = "";
                }
                this.writeln("<tool name= \"" + ToolCatalogParser.HTMLEncode(tool.getToolName()) + "\" " + "icon" + "=\"" + iconFilename + "\">");
                this.increaseIndent();
                String[] sigs = tool.getActionSignatureIdsInShowOrder();
                int j = 0;
                while (j < sigs.length) {
                    ActionSig sig = tool.getActionSig(sigs[j]);
                    this.writeActionSig(sig);
                    ++j;
                }
                this.decreaseIndent();
                this.writeln("</tool>");
            }
            ++i;
        }
    }

    protected void writeVisToolShowOrder(Vector<IDLVisTool> visTools, Vector<Integer> visToolShowOrder) {
        if (this.m_bWriteMinimalSystemCustomizations) {
            return;
        }
        this.writeln("<tool_show_order>");
        this.increaseIndent();
        int i = 0;
        while (i < visToolShowOrder.size()) {
            Integer idx = visToolShowOrder.get(i);
            IDLVisTool vt = visTools.get(idx);
            this.writeln("<tool name=\"" + ToolCatalogParser.HTMLEncode(vt.getToolName()) + "\"/>");
            ++i;
        }
        this.decreaseIndent();
        this.writeln("</tool_show_order>");
    }

    protected void writeSystemCustomizations(Vector<IDLVisTool> visTools) {
        int i;
        String[] showOrder;
        IDLVisTool vt;
        this.writeln("<System_Customizations>");
        this.writeln("");
        this.increaseIndent();
        this.writeComment(Messages.ToolCatalogParser_AddActionsToASystemTool);
        this.writeln("<add_action_bars>");
        this.increaseIndent();
        int j = 0;
        while (j < visTools.size()) {
            vt = visTools.get(j);
            if (vt.isSystemDefined() && vt.isShowOrderCustomized()) {
                this.writeln("<tool name=\"" + ToolCatalogParser.HTMLEncode(vt.getToolName()) + "\">");
                showOrder = vt.getActionSignatureIdsInShowOrder();
                i = 0;
                while (i < showOrder.length) {
                    ActionSig actionsig = vt.getActionSig(showOrder[i]);
                    if (actionsig != null && actionsig.isUserDefined()) {
                        this.increaseIndent();
                        this.writeActionSig(actionsig);
                        this.decreaseIndent();
                    }
                    ++i;
                }
                this.writeln("</tool>");
            }
            ++j;
        }
        this.decreaseIndent();
        this.writeln("</add_action_bars>");
        if (!this.m_bWriteMinimalSystemCustomizations) {
            this.writeComment(Messages.ToolCatalogParser_ChangeActionShowOrderOfSystemTools);
            this.writeComment(Messages.ToolCatalogParser_MissingActionIdsWillBeHiddenInTheView);
            this.writeln("<action_order>");
            this.increaseIndent();
            j = 0;
            while (j < visTools.size()) {
                vt = visTools.get(j);
                if (vt.isSystemDefined() && vt.isShowOrderCustomized()) {
                    this.writeln("<tool name=\"" + ToolCatalogParser.HTMLEncode(vt.getToolName()) + "\">");
                    this.increaseIndent();
                    showOrder = vt.getActionSignatureIdsInShowOrder();
                    i = 0;
                    while (i < showOrder.length) {
                        if (vt.getActionSig(showOrder[i]) != null) {
                            this.writeln("<action id=\"" + ToolCatalogParser.HTMLEncode(showOrder[i]) + "\"/>");
                        }
                        ++i;
                    }
                    this.decreaseIndent();
                    this.writeln("</tool>");
                }
                ++j;
            }
            this.decreaseIndent();
            this.writeln("</action_order>");
        }
        this.decreaseIndent();
        this.writeln("</System_Customizations>");
    }

    public void backupUserCatalog() {
        String fname = this.getUserCatalogFilename();
        String backup_fname = fname.replaceAll("\\.xml", "\\.bkp");
        File f = new File(backup_fname);
        if (f.exists()) {
            f.delete();
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(fname));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(backup_fname));
            byte[] buffer = new byte[4096];
            int b = in.read(buffer);
            while (b >= 0) {
                out.write(buffer, 0, b);
                b = in.read(buffer);
            }
            in.close();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String HTMLEncode(String s) {
        StringBuffer st = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            boolean copy = true;
            char ch = s.charAt(i);
            int j = 0;
            while (j < c.length) {
                if (c[j] == ch) {
                    st.append(expansion[j]);
                    copy = false;
                    break;
                }
                ++j;
            }
            if (copy) {
                st.append(ch);
            }
            ++i;
        }
        return st.toString();
    }

    public boolean importFromFile(Vector<IDLVisTool> visToolsVec, Vector<Integer> showOrder, String fileName) {
        File file;
        block5: {
            try {
                file = this.openCatalogFileForRead(fileName);
                if (file != null) break block5;
                this.reportErrorParsingCatalog(null, fileName);
                return false;
            }
            catch (Exception e) {
                this.reportErrorParsingCatalog(e, fileName);
                return false;
            }
        }
        Document importDoc = this.parseCatalog(new FileInputStream(file), fileName);
        if (importDoc == null) {
            return false;
        }
        this.m_systemOrUser = 1;
        Vector<IDLVisTool> importVec = this.processDoc(importDoc);
        boolean ok = this.performImport(visToolsVec, showOrder, importVec, importDoc);
        if (ok) {
            this.writeUserCatalog(null, visToolsVec, showOrder);
        }
        return true;
    }

    private class ReplaceExistingSystemToolAction {
        private boolean m_confirmActionReplacement = true;
        private boolean m_isYes = false;

        public boolean isYes() {
            return this.m_isYes;
        }

        public void showPromptToReplaceExistingSystemAction(String toolName, String actionTitle) {
            if (this.m_confirmActionReplacement) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialogWithToggle dlg = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)Messages.ToolCatalogParser_ConfirmActionReplacement, (String)(String.valueOf(NLS.bind((String)Messages.ToolCatalogParser_ActionExistsForTool, (Object)(", [" + actionTitle + "], "), (Object)(", [" + toolName + "].\n"))) + Messages.ToolCatalogParser_ReplaceItQuestion), (String)Messages.ToolCatalogParser_DontAskMeAgain, (boolean)false, null, null);
                this.m_isYes = dlg.getReturnCode() == 2;
                this.m_confirmActionReplacement = !dlg.getToggleState();
            }
        }
    }

    private class ReplaceToolAction {
        private boolean m_confirmToolReplacement = true;
        private boolean m_isYes = false;

        public boolean isYes() {
            return this.m_isYes;
        }

        public void showPromptToReplaceExistingToolAndActions(String toolName) {
            if (this.m_confirmToolReplacement) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialogWithToggle dlg = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)Messages.ToolCatalogParser_ConfirmToolReplacement, (String)NLS.bind((String)Messages.ToolCatalogParser_ReplaceExisting, (Object)toolName), (String)Messages.ToolCatalogParser_DontAskMeAgain, (boolean)false, null, null);
                this.m_isYes = dlg.getReturnCode() == 2;
                this.m_confirmToolReplacement = !dlg.getToggleState();
            }
        }
    }
}

