/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.debug.internal.model.IDLDebugTarget;
import com.rsi.idldt.debug.internal.model.IDLStackFrame;
import com.rsi.idldt.debug.internal.model.IDLThread;
import com.rsi.idldt.debug.internal.model.IDLValue;
import com.rsi.idldt.debug.internal.model.IDLVariable;
import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.toolpalette.ActionSig;
import com.rsi.idldt.toolpalette.ToolPalette2IDLComms;
import com.rsi.idldt.toolpalette.ToolPalettePlugin;
import com.rsi.idldt.toolpalette.internal.ui.Messages;
import com.rsi.idldt.toolpalette.internal.ui.VisToolControl;
import com.rsi.idldt.toolpalette.views.ToolPaletteView;
import com.rsi.idldt.ui.IDLEditorUtilities;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDLVisTool {
    protected static final String DEFAULT_ICON = "DEFAULT ICON";
    public static final String[] MACRO_VARIABLES = new String[]{"%B", "%D", "%F", "%L", "%N", "%P", "%S", "%T", "%?", "%0"};
    public static final String[] MACRO_DESCRIPTIONS = new String[]{Messages.IDLVisTool_MacroDescription_B, Messages.IDLVisTool_MacroDescription_D, Messages.IDLVisTool_MacroDescription_F, Messages.IDLVisTool_MacroDescription_L, Messages.IDLVisTool_MacroDescription_N, Messages.IDLVisTool_MacroDescription_P, Messages.IDLVisTool_MacroDescription_S, Messages.IDLVisTool_MacroDescription_T, Messages.IDLVisTool_MacroDescription_QuestionMark, Messages.IDLVisTool_MacroDescription_0};
    public static final int SYSTEM = 0;
    public static final int USER = 1;
    protected String m_toolName;
    protected String m_iconFilename;
    protected Image m_iconImage;
    protected static Image m_default32_image;
    protected int m_focusIndex = 0;
    protected VisToolControl m_visToolControl;
    protected HashMap<String, ActionSig> m_actionSigs = new HashMap();
    protected HashMap<String, ActionSig> m_actionSigsBackup = null;
    protected HashMap<Integer, String[]> m_actionBarNumber2ListOfVarsDropped = new HashMap();
    protected Vector<String> m_actionShowOrder = null;
    protected Vector<String> m_actionShowOrderBackup = null;
    protected int m_systemOrUser = 0;
    private String m_toolNameBackup;
    private String m_largeIconFilenameBackup = "DEFAULT ICON";
    private Vector<String> m_originalSystemActionShowOrder = new Vector();
    private static String m_overplotDragData;
    protected static ActionSig m_handleToActionBeingDrug;

    static {
        m_overplotDragData = null;
        m_handleToActionBeingDrug = null;
    }

    public IDLVisTool(String toolName, int systemOrUserDefined, String largeIconFilename) {
        this.m_toolName = toolName;
        this.m_systemOrUser = systemOrUserDefined;
        this.m_iconFilename = largeIconFilename;
    }

    public String getToolName() {
        return this.m_toolName;
    }

    public String getIconFilename() {
        return this.m_iconFilename;
    }

    public VisToolControl getVisToolControl() {
        return this.m_visToolControl;
    }

    public void setVisToolControl(VisToolControl visToolControl) {
        this.m_visToolControl = visToolControl;
    }

    public int getActionBarShowIndexNumber(String sigId) {
        int i = 0;
        while (i < this.m_actionShowOrder.size()) {
            String sid = this.m_actionShowOrder.get(i);
            if (sigId.equalsIgnoreCase(sid)) {
                return i;
            }
            ++i;
        }
        return -99;
    }

    public boolean isSystemDefined() {
        return this.m_systemOrUser == 0;
    }

    public static boolean isPathFullyQualified(String filename) {
        if (filename == null || filename.length() == 0) {
            return false;
        }
        if (Platform.getOS().equals("win32")) {
            return filename.length() >= 2 && filename.charAt(1) == ':';
        }
        return filename.charAt(0) == '/';
    }

    public static Image getDefaultImage() {
        if (m_default32_image == null) {
            URL url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/default32.png"), null);
            m_default32_image = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return m_default32_image;
    }

    public Image getLargeImage() {
        if (m_default32_image == null) {
            IDLVisTool.getDefaultImage();
        }
        if (this.m_iconImage == null && this.m_iconFilename != null) {
            try {
                URL url = !IDLVisTool.isPathFullyQualified(this.m_iconFilename) ? FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path(this.m_iconFilename), null) : new URL("file:" + this.m_iconFilename);
                this.m_iconImage = ImageDescriptor.createFromURL((URL)url).createImage();
            }
            catch (MalformedURLException malformedURLException) {
                this.m_iconImage = null;
            }
        }
        if (this.m_iconImage == null || this.m_iconImage.getImageData().width <= 6 || this.m_iconImage.getImageData().height <= 6) {
            this.m_iconImage = m_default32_image;
        }
        return this.m_iconImage;
    }

    protected static String getXmlActionForVisTool(IDLVisTool visTool) {
        StringBuffer sb = new StringBuffer();
        String label = "Visualize using " + visTool.m_toolName + "...";
        String helpContextId = String.valueOf(visTool.m_toolName) + "_help_context";
        String toolId = "com.rsi.idldt.toolpalette.visTool." + visTool.m_toolName;
        sb.append("<action ");
        sb.append("  label=\"" + label + "\"");
        sb.append("  helpContextId=\"" + helpContextId + "\"");
        sb.append("  menubarPath=\"variableGroup\"");
        sb.append("  id=\"" + toolId + "\">");
        sb.append(" <class class=\"com.rsi.idldt.toolpalette.actions.IDLVisualizationAction\">");
        sb.append("   <parameter name=\"idl_routine\"  value=\"" + visTool.m_toolName + "\"/> ");
        sb.append(" </class>");
        sb.append("</action>");
        return sb.toString();
    }

    protected static String getXmlExtensionsForVisTools(Vector<IDLVisTool> visTools) {
        StringBuffer sb = new StringBuffer();
        sb.append("<extension point=\"org.eclipse.ui.popupMenus\">");
        sb.append(" <viewerContribution");
        sb.append("       targetID=\"org.eclipse.debug.ui.VariableView\"");
        sb.append("      id=\"org.eclipse.debug.ui.variablesView.popupMenu\">");
        for (IDLVisTool visTool : visTools) {
            sb.append(IDLVisTool.getXmlActionForVisTool(visTool));
        }
        sb.append(" </viewerContribution>");
        sb.append("</extension>");
        return sb.toString();
    }

    public void createNewVisUsingVariables(String actionProcName, String idlVariables, String additionalKeywords) {
        String keywords;
        String command = actionProcName;
        if (idlVariables != null && idlVariables.trim().length() > 0) {
            command = String.valueOf(command) + ", " + idlVariables;
        }
        if (additionalKeywords != null && additionalKeywords.trim().length() > 0 && (keywords = IDLVisTool.doMacroVariableExpansionOnStaticArgs(additionalKeywords, actionProcName, idlVariables)).length() > 0) {
            command = String.valueOf(command) + ", " + keywords;
        }
        ToolPalette2IDLComms.executeString(command);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doMacroVariableExpansionOnStaticArgs(String replaceString, String procName, String idlVariables) {
        String[] varArray = idlVariables != null ? idlVariables.split(",") : new String[]{};
        int i = 0;
        while (i < varArray.length) {
            String string = varArray[i];
            if (string.length() != 0) {
                int index;
                if (string.trim().startsWith("'")) {
                    index = string.indexOf(39);
                    string = string.substring(index + 1);
                }
                if (string.trim().endsWith("'")) {
                    index = string.lastIndexOf(39);
                    string = string.substring(0, index);
                }
                varArray[i] = string;
            }
            ++i;
        }
        StringBuilder buffer = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        int length = replaceString.length();
        int i2 = 0;
        while (i2 < length) {
            block31: {
                char c;
                block30: {
                    c = replaceString.charAt(i2);
                    if (c != '%' || i2 >= length - 1) break block30;
                    c = Character.toUpperCase(replaceString.charAt(++i2));
                    switch (c) {
                        case 'D': {
                            buffer.append(IDLVisTool.getDate());
                            break;
                        }
                        case 'T': {
                            buffer.append(IDLVisTool.getTime());
                            break;
                        }
                        case 'F': {
                            buffer.append(IDLVisTool.editorPath().toOSString());
                            break;
                        }
                        case 'P': {
                            IPath path = IDLVisTool.editorPath();
                            if (!path.isEmpty()) {
                                buffer.append(path.removeLastSegments(1).addTrailingSeparator().toOSString());
                                break;
                            }
                            break block31;
                        }
                        case 'N': {
                            IPath path = IDLVisTool.editorPath();
                            if (!path.isEmpty()) {
                                buffer.append(path.removeFileExtension().lastSegment());
                                break;
                            }
                            break block31;
                        }
                        case 'B': {
                            IPath path = IDLVisTool.editorPath();
                            if (!path.isEmpty()) {
                                buffer.append(path.lastSegment());
                                break;
                            }
                            break block31;
                        }
                        case 'S': {
                            String selectedText;
                            ITextSelection selection = ToolPaletteView.getInstance().getTextSelection();
                            if (selection != null && !selection.isEmpty() && (selectedText = selection.getText()) != null) {
                                buffer.append(selectedText);
                                break;
                            }
                            break block31;
                        }
                        case 'L': {
                            buffer.append(IDLVisTool.getLineOfCaret());
                            break;
                        }
                        case '?': {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            if (window == null) {
                                buffer.append(' ');
                                break;
                            }
                            InputDialog dialog = new InputDialog(window.getShell(), Messages.IDLVisTool_EnterText, Messages.IDLVisTool_EnterActionText, null, null);
                            if (dialog.open() == 0) {
                                buffer.append(dialog.getValue());
                                break;
                            }
                            buffer.append(' ');
                            break;
                        }
                        case '%': {
                            buffer.append('%');
                            break;
                        }
                        default: {
                            sb.delete(0, sb.length());
                            while (i2 <= replaceString.length() - 1) {
                                char ch = replaceString.charAt(i2);
                                if (Character.isDigit(ch)) {
                                    sb.append(ch);
                                    ++i2;
                                    continue;
                                }
                                --i2;
                                break;
                            }
                            if (sb.length() > 0) {
                                try {
                                    int index = Integer.parseInt(sb.toString());
                                    if (index == 0) {
                                        buffer.append(procName);
                                        break;
                                    }
                                    if (index > 0 && index - 1 <= varArray.length - 1) {
                                        buffer.append(varArray[index - 1].trim());
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {}
                                break;
                            }
                            break block31;
                        }
                    }
                    break block31;
                }
                buffer.append(c);
            }
            ++i2;
        }
        return IDLVisTool.removeKeywordsContainingInvalidIDLVariableNames(buffer.toString());
    }

    private static String removeKeywordsContainingInvalidIDLVariableNames(String theStaticArgs) {
        int stop;
        int start;
        String staticArgs = theStaticArgs;
        ArrayList<Integer> indexes = IDLVisTool.getIndexesOfCommasInStaticArgs(staticArgs);
        int i = 0;
        while (i < indexes.size()) {
            start = i == 0 ? 0 : indexes.get(i - 1) + 1;
            if (IDLVisTool.invalidStaticArgChunk(staticArgs, start, stop = i == 0 ? indexes.get(0) - 1 : indexes.get(i) - 1)) {
                staticArgs = IDLVisTool.removeChunk(staticArgs, start, stop + 1);
                int nCharsDeleted = stop + 1 - start;
                int j = i;
                while (j < indexes.size()) {
                    int idx = indexes.get(j);
                    indexes.set(j, idx - nCharsDeleted - 1);
                    ++j;
                }
            }
            ++i;
        }
        start = indexes.size() == 0 ? 0 : indexes.get(indexes.size() - 1) + 1;
        if (IDLVisTool.invalidStaticArgChunk(staticArgs, start, stop = staticArgs.length() - 1)) {
            staticArgs = IDLVisTool.removeChunk(staticArgs, start - 1, stop);
        }
        return staticArgs;
    }

    private static boolean invalidStaticArgChunk(String staticArgs, int start, int stop) {
        String keywordValue;
        block10: {
            int equalIndex;
            block9: {
                block8: {
                    try {
                        if (staticArgs != null && staticArgs.length() != 0) break block8;
                        return false;
                    }
                    catch (Exception exception) {
                        return true;
                    }
                }
                equalIndex = IDLVisTool.findEqualIndex(staticArgs.substring(start, stop));
                if (equalIndex != -1) break block9;
                return false;
            }
            keywordValue = staticArgs.substring(start + ++equalIndex, stop + 1).trim();
            if (keywordValue.charAt(0) != '\'' && keywordValue.charAt(0) != '=') break block10;
            return false;
        }
        boolean bValid = IDLVisTool.validIDLVariableName(keywordValue);
        if (bValid) {
            bValid = IDLVisTool.isIDLVariableInStackFrame(keywordValue);
        }
        if (!bValid) {
            bValid = IDLVisTool.isValueANumericConstant(keywordValue);
        }
        if (!bValid) {
            bValid = IDLVisTool.isValueIDLArrayConstant(keywordValue);
        }
        return !bValid;
    }

    private static boolean isValueANumericConstant(String idlVarName) {
        boolean bValid = true;
        try {
            Float.parseFloat(idlVarName);
        }
        catch (Exception exception) {
            bValid = false;
        }
        return bValid;
    }

    private static boolean isValueIDLArrayConstant(String idlVarName) {
        return idlVarName.startsWith("[");
    }

    private static int findEqualIndex(String sourceString) {
        boolean bInsideQuote = false;
        char[] chars = sourceString.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '\'' || c == '\"') {
                bInsideQuote = !bInsideQuote;
            } else if (!bInsideQuote && c == '=') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static String removeChunk(String staticArgs, int start, int stop) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < staticArgs.length()) {
            if (start > i || i > stop) {
                sb.append(staticArgs.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    private static ArrayList<Integer> getIndexesOfCommasInStaticArgs(String staticArgs) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        boolean bInsideQuote = false;
        char[] chars = staticArgs.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '\'' || c == '\"') {
                bInsideQuote = !bInsideQuote;
            } else if (!bInsideQuote && c == ',') {
                indexes.add(new Integer(i));
            }
            ++i;
        }
        return indexes;
    }

    public static IDLVariable getIDLVariable(String var) {
        IDLStackFrame frame;
        IDLThread thread;
        IDLDebugTarget target;
        IIDLProcessProxy proxy = IDLProcessManager.getActiveProcess();
        if (proxy != null && (target = proxy.getDebugTarget()) != null && (thread = target.getThread()) != null && (frame = thread.getTopIDLStackFrame()) != null) {
            return frame.getIDLVariable(var);
        }
        return null;
    }

    public static boolean isIDLVariableInStackFrame(String var) {
        return IDLVisTool.getIDLVariable(var) != null;
    }

    public static boolean validIDLVariableName(String var) {
        char[] chars = var.toCharArray();
        if (chars == null || chars.length == 0) {
            return false;
        }
        int i = 0;
        while (i < chars.length) {
            boolean valid;
            char c = chars[i];
            if (i == 0) {
                valid = Character.isLetter(c) || c == '_';
            } else {
                boolean bl = valid = Character.isLetter(c) || Character.isDigit(c) || c == '$' || c == '_';
            }
            if (!valid) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String getTime() {
        Date now = new Date();
        String strDate = DateFormat.getTimeInstance(2).format(now);
        return strDate;
    }

    private static String getDate() {
        Date now = new Date();
        String strDate = DateFormat.getDateInstance(3).format(now);
        return strDate;
    }

    private static IPath editorPath() {
        IEditorPart activeEditor = IDLVisTool.getActiveEditor();
        if (activeEditor == null) {
            return new Path("");
        }
        IEditorInput editorInput = activeEditor.getEditorInput();
        IPath path = IDLEditorUtilities.getEditorsAbsolutePath((IEditorInput)editorInput);
        return path != null ? path : new Path("");
    }

    private static IEditorPart getActiveEditor() {
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (ww == null) {
            return null;
        }
        IWorkbenchPage activePage = ww.getActivePage();
        if (activePage == null) {
            return null;
        }
        return activePage.getActiveEditor();
    }

    private static int getLineOfCaret() {
        ITextEditor textEditor;
        block7: {
            IEditorPart activeEditor;
            block6: {
                try {
                    activeEditor = IDLVisTool.getActiveEditor();
                    if (activeEditor != null) break block6;
                    return 0;
                }
                catch (Exception exception) {
                    return 0;
                }
            }
            textEditor = (ITextEditor)activeEditor.getAdapter(ITextEditor.class);
            IEditorInput editorInput = activeEditor.getEditorInput();
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)editorInput);
            if (!(textEditor instanceof ProEditor)) break block7;
            int caret = ((ProEditor)textEditor).getCaretOffset();
            try {
                return document.getLineOfOffset(caret) + 1;
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
        }
        ITextSelection select = (ITextSelection)textEditor.getSelectionProvider().getSelection();
        int caret = select.getEndLine() + 1;
        return caret;
    }

    protected int findNumVariables(String idlVariables) {
        String[] vars = idlVariables.split(",");
        return vars.length;
    }

    public void createNewVisUsingFirstMatchingActionSignature(String idlVariables) {
        String additionalKeywords = null;
        String actionProcName = null;
        int numVariables = this.findNumVariables(idlVariables);
        String[] sigIds = this.getActionSignatureIdsInShowOrder();
        int i = 0;
        while (i < sigIds.length) {
            ActionSig sig = this.m_actionSigs.get(sigIds[i]);
            if (sig != null && sig.m_argNames != null && sig.m_argNames.size() == numVariables) {
                additionalKeywords = sig.m_staticArgs;
                actionProcName = sig.m_procName;
                ToolPaletteView.getInstance().fillActionBar(i, sig, idlVariables);
                break;
            }
            ++i;
        }
        if (actionProcName != null) {
            this.createNewVisUsingVariables(actionProcName, idlVariables, additionalKeywords);
        }
    }

    public static void overplotVisUsingCommand(String overPlotCommand, String plotID) {
        String command = "iSetCurrent, '" + plotID + "', /SHOW";
        ToolPalette2IDLComms.executeString(command);
        ToolPalette2IDLComms.executeString(overPlotCommand);
    }

    public static void overplotVisUsingVariables(String idlVariables, String plotID) {
        if (plotID == null || plotID.length() == 0 || idlVariables == null || idlVariables.length() == 0) {
            return;
        }
        String command = "iSetCurrent, '" + plotID + "', /SHOW";
        ToolPalette2IDLComms.executeString(command);
        String[] idlVars = idlVariables.split(",");
        int i = 0;
        while (i < idlVars.length) {
            String varname = idlVars[i].trim();
            if (varname.startsWith("'")) {
                command = "iOpen, " + varname + ", /VISUALIZE, /OVERPLOT";
                ToolPalette2IDLComms.executeString(command);
            } else {
                IDLValue value;
                long[] dims;
                IDLVariable var = IDLVisTool.getIDLVariable(varname);
                if (var != null && var.isArray() && !var.isOneElementArray() && (dims = (value = (IDLValue)var.getValue()).getDimensions()) != null) {
                    long mindim = dims[0];
                    int j = 1;
                    while (j < dims.length) {
                        if (dims[j] < mindim) {
                            mindim = dims[j];
                        }
                        ++j;
                    }
                    String procName = null;
                    String keywords = IDLVisTool.doMacroVariableExpansionOnStaticArgs("GEOTIFF=%1_geotiff, RGB_TABLE=%1_pal, /OVERPLOT", "", varname);
                    if (dims.length == 1 && dims[0] > 1L) {
                        procName = "iPlot";
                    } else if (dims.length == 2 || dims.length == 3 && mindim <= 4L) {
                        procName = keywords.indexOf("GEOTIFF") >= 0 ? "iMap" : "iImage";
                    } else if (dims.length == 3) {
                        procName = "iVolume";
                    }
                    if (procName != null) {
                        command = String.valueOf(procName) + ", " + varname;
                        if (keywords != null && keywords.length() > 0) {
                            command = String.valueOf(command) + ", " + keywords;
                        }
                        ToolPalette2IDLComms.executeString(command);
                    }
                }
            }
            ++i;
        }
    }

    public void closeActionSignature(ActionSig sig) {
        String sigIdToClose = sig.m_title.toLowerCase();
        int i = 0;
        while (i < this.m_actionShowOrder.size()) {
            String sigId = this.m_actionShowOrder.get(i);
            if (sigIdToClose.equalsIgnoreCase(sigId)) {
                this.m_actionShowOrder.remove(i);
                break;
            }
            ++i;
        }
        ActionSig sigToClose = this.getActionSig(sigIdToClose);
        if (sigToClose != null && sigToClose.isUserDefined()) {
            this.m_actionSigs.remove(sigIdToClose);
        }
    }

    protected void replaceActionSignatureInShowOrder(String existing_title, String new_title) {
        int i = 0;
        while (i < this.m_actionShowOrder.size()) {
            String sigId = this.m_actionShowOrder.get(i);
            if (existing_title.equalsIgnoreCase(sigId)) {
                this.m_actionShowOrder.remove(i);
                this.m_actionShowOrder.insertElementAt(new_title.toLowerCase(), i);
                break;
            }
            ++i;
        }
    }

    public void changeActionTitle(String existing_title, String new_title) {
        this.replaceActionSignatureInShowOrder(existing_title, new_title);
        ActionSig sig = this.m_actionSigs.get(existing_title.toLowerCase());
        this.m_actionSigs.remove(existing_title.toLowerCase());
        this.m_actionSigs.put(new_title.toLowerCase(), sig);
    }

    protected void addActionSignature(ActionSig.ActionType actionType, int systemOrUser, String actionProcName, String overplotcmd, ArrayList<String> argNames, String staticArgs, String description, String theTitle) {
        String title = theTitle;
        if (title == null) {
            title = this.generateUniqueActionTitle(null);
        }
        this.m_actionSigs.put(title.toLowerCase(), new ActionSig(actionType, systemOrUser, actionProcName, overplotcmd, argNames, staticArgs, description, title));
    }

    public void addActionSignature(ActionSig.ActionType actionType, int systemOrUser, String actionProcName, String overplotcmd, ArrayList<String> argNames, String staticArgs, String description, String theTitle, String replaceSigId) {
        String title = theTitle;
        if (title == null) {
            title = this.generateUniqueActionTitle(null);
        }
        this.addActionSignature(actionType, systemOrUser, actionProcName, overplotcmd, argNames, staticArgs, description, title);
        if (replaceSigId != null) {
            this.replaceActionSignatureInShowOrder(replaceSigId, title);
        } else {
            if (this.m_actionShowOrder == null) {
                this.m_actionShowOrder = new Vector();
            }
            this.m_actionShowOrder.add(0, title.toLowerCase());
            if (this.m_actionBarNumber2ListOfVarsDropped != null) {
                HashMap<Integer, String[]> map = new HashMap<Integer, String[]>();
                for (Integer barIndex : this.m_actionBarNumber2ListOfVarsDropped.keySet()) {
                    String[] values = this.m_actionBarNumber2ListOfVarsDropped.get(barIndex);
                    Integer newBarIndex = new Integer(barIndex + 1);
                    map.put(newBarIndex, values);
                }
                this.m_actionBarNumber2ListOfVarsDropped = map;
            }
        }
    }

    public String[] getActionSignatureIdsInShowOrder() {
        ArrayList<String> list = new ArrayList<String>();
        this.cleanupShowOrderVector();
        if (this.m_actionShowOrder == null) {
            for (String actionId : this.m_actionSigs.keySet()) {
                list.add(actionId.toLowerCase());
            }
            Collections.sort(list);
            this.m_actionShowOrder = new Vector(list);
        } else {
            for (String actionId : this.m_actionShowOrder) {
                list.add(actionId.toLowerCase());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public boolean isShowOrderCustomized() {
        this.cleanupShowOrderVector();
        String[] showOrder = this.getActionSignatureIdsInShowOrder();
        if (showOrder.length != this.m_originalSystemActionShowOrder.size()) {
            return true;
        }
        int i = 0;
        for (String id : this.m_originalSystemActionShowOrder) {
            if (!id.equalsIgnoreCase(showOrder[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void cleanupShowOrderVector() {
        if (this.m_actionShowOrder == null) {
            return;
        }
        Iterator<String> iterator = this.m_actionShowOrder.iterator();
        while (iterator.hasNext()) {
            String sigId = iterator.next();
            if (this.m_actionSigs.get(sigId) != null) continue;
            iterator.remove();
        }
    }

    public Vector<ActionSig> getUserDefinedActions() {
        Vector<ActionSig> actions = new Vector<ActionSig>();
        String[] actionIds = this.getActionSignatureIdsInShowOrder();
        int i = 0;
        while (i < actionIds.length) {
            ActionSig sig = this.m_actionSigs.get(actionIds[i]);
            if (sig != null && sig.isUserDefined()) {
                actions.add(sig);
            }
            ++i;
        }
        return actions;
    }

    public boolean isSystemActionBarsIntact() {
        String[] showOrder = this.getActionSignatureIdsInShowOrder();
        if (showOrder.length < this.m_originalSystemActionShowOrder.size()) {
            return true;
        }
        int i = 0;
        while (i < this.m_originalSystemActionShowOrder.size()) {
            String id = this.m_originalSystemActionShowOrder.get(i);
            if (!id.equalsIgnoreCase(showOrder[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setActionShowOrder(Vector<String> showOrderVector) {
        Vector<String> toRemove = new Vector<String>(showOrderVector.size());
        int i = 0;
        while (i < showOrderVector.size()) {
            ActionSig id = this.m_actionSigs.get(showOrderVector.get(i));
            if (id == null) {
                toRemove.add(showOrderVector.get(i));
            }
            ++i;
        }
        if (toRemove.size() > 0) {
            showOrderVector.removeAll(toRemove);
        }
        this.m_actionShowOrder = showOrderVector;
    }

    public ActionSig getActionSig(String sigId) {
        return this.m_actionSigs.get(sigId.toLowerCase());
    }

    public static IDLVisTool findTool(Vector<IDLVisTool> vec, String tool_name) {
        for (IDLVisTool vt : vec) {
            if (!vt.getToolName().equalsIgnoreCase(tool_name)) continue;
            return vt;
        }
        return null;
    }

    public void backupActionSignatures() {
        this.m_actionShowOrderBackup = (Vector)this.m_actionShowOrder.clone();
        this.m_actionSigsBackup = (HashMap)this.m_actionSigs.clone();
    }

    public void removeAllActionSigBackups() {
        this.m_actionShowOrderBackup = null;
        for (ActionSig sig : this.m_actionSigs.values()) {
            sig.cancelEdits(false);
        }
    }

    public void restoreBackupActionSignatures() {
        this.m_actionShowOrder = this.m_actionShowOrderBackup;
        this.m_actionShowOrderBackup = null;
        this.m_actionSigs = this.m_actionSigsBackup;
        for (ActionSig sig : this.m_actionSigs.values()) {
            sig.cancelEdits(true);
        }
    }

    public void restoreSystemDefinedActionBars() {
        String[] showOrder = this.getActionSignatureIdsInShowOrder();
        ArrayList<String> showOrderList = new ArrayList<String>(Arrays.asList(showOrder));
        int i = 0;
        while (i < showOrderList.size()) {
            if (this.m_originalSystemActionShowOrder.contains(showOrderList.get(i))) {
                showOrderList.remove(i);
                continue;
            }
            ++i;
        }
        this.m_actionShowOrder = new Vector<String>(this.m_originalSystemActionShowOrder);
        i = 0;
        while (i < showOrderList.size()) {
            this.m_actionShowOrder.add(showOrderList.get(i));
            ++i;
        }
    }

    public void swapActionSigShowOrderIndexes(int sourceIndex, int dropIndex) {
        String o1 = this.m_actionShowOrder.get(sourceIndex);
        String o2 = this.m_actionShowOrder.get(dropIndex);
        this.m_actionShowOrder.set(dropIndex, o1);
        this.m_actionShowOrder.set(sourceIndex, o2);
        this.m_focusIndex = dropIndex;
    }

    public void moveAfterActionSig(int origIndex, int theAfterIndex) {
        int afterIndex = theAfterIndex + 1;
        String o1 = this.m_actionShowOrder.get(origIndex);
        this.m_actionShowOrder.remove(origIndex);
        if (afterIndex > origIndex) {
            --afterIndex;
        }
        this.m_actionShowOrder.insertElementAt(o1, afterIndex);
    }

    public void moveBeforeActionSig(int origIndex, int theBeforeIndex) {
        int beforeIndex = theBeforeIndex;
        String o1 = this.m_actionShowOrder.get(origIndex);
        this.m_actionShowOrder.remove(origIndex);
        if (beforeIndex > origIndex) {
            --beforeIndex;
        }
        this.m_actionShowOrder.insertElementAt(o1, beforeIndex);
    }

    public int getFocusIndex() {
        int index = this.m_focusIndex;
        this.m_focusIndex = 0;
        return index;
    }

    public void clearActionBarDropStates() {
        this.m_actionBarNumber2ListOfVarsDropped.clear();
    }

    public String[] getActionBarDropState(int actionBarIndex) {
        Integer actionBarIndexClass = new Integer(actionBarIndex);
        return this.m_actionBarNumber2ListOfVarsDropped.get(actionBarIndexClass);
    }

    public void setActionBarDropState(int actionBarIndex, String[] idlVariableNames) {
        Integer actionBarIndexClass = new Integer(actionBarIndex);
        if (this.m_actionBarNumber2ListOfVarsDropped.containsKey(actionBarIndexClass)) {
            this.m_actionBarNumber2ListOfVarsDropped.remove(actionBarIndexClass);
        }
        this.m_actionBarNumber2ListOfVarsDropped.put(actionBarIndexClass, idlVariableNames);
    }

    public void setToolName(String toolName, boolean bBackup) {
        if (bBackup && this.m_toolNameBackup == null) {
            this.m_toolNameBackup = this.m_toolName;
        }
        this.m_toolName = toolName;
    }

    protected void disposeIconImage() {
        if (this.m_iconImage != null && this.m_iconImage != m_default32_image && !this.m_iconImage.isDisposed()) {
            this.m_iconImage.dispose();
        }
    }

    public void setIconFilename(String iconFilename, boolean bBackup) {
        if (bBackup && this.m_largeIconFilenameBackup.equalsIgnoreCase(DEFAULT_ICON)) {
            this.m_largeIconFilenameBackup = this.m_iconFilename;
        }
        this.m_iconFilename = iconFilename;
        this.disposeIconImage();
        this.m_iconImage = null;
    }

    public void revertToBackup() {
        if (this.m_toolNameBackup != null) {
            this.m_toolName = this.m_toolNameBackup;
            this.m_toolNameBackup = null;
        }
        if (!this.m_largeIconFilenameBackup.equalsIgnoreCase(DEFAULT_ICON)) {
            this.m_iconFilename = this.m_largeIconFilenameBackup;
            this.m_largeIconFilenameBackup = DEFAULT_ICON;
            this.disposeIconImage();
            this.m_iconImage = null;
        }
    }

    public void releaseBackupData() {
        this.m_toolNameBackup = null;
        this.m_largeIconFilenameBackup = DEFAULT_ICON;
    }

    public void invokeFirstNoArgumentActionBar() {
        String additionalKeywords = null;
        String actionProcName = null;
        String[] sigIds = this.getActionSignatureIdsInShowOrder();
        int i = 0;
        while (i < sigIds.length) {
            ActionSig sig = this.m_actionSigs.get(sigIds[i]);
            if (sig.m_argNames.size() == 0) {
                additionalKeywords = sig.m_staticArgs;
                actionProcName = sig.m_procName;
                break;
            }
            ++i;
        }
        if (actionProcName != null) {
            this.createNewVisUsingVariables(actionProcName, null, additionalKeywords);
        }
    }

    public static void setOverplotDragData(String overplotCommand) {
        m_overplotDragData = overplotCommand;
    }

    public static String getOverplotDragData() {
        return m_overplotDragData;
    }

    public String generateUniqueActionTitle(String inBaseName) {
        String toolName;
        String baseName = inBaseName == null || inBaseName.trim().length() == 0 ? (toolName = this.m_toolName.toLowerCase()) : inBaseName.trim();
        String sigId = baseName;
        boolean bFound = true;
        int i = 1;
        while (bFound) {
            if (!this.m_actionSigs.containsKey(sigId.toLowerCase())) {
                bFound = false;
                continue;
            }
            sigId = String.valueOf(baseName) + " (" + i + ")";
            ++i;
        }
        return sigId;
    }

    public void removeActionSigFromShowOrder(String title) {
        this.m_actionShowOrder.remove(title.toLowerCase());
    }

    public void addActionSigToShowOrder(String title) {
        if (this.m_actionShowOrder == null) {
            this.m_actionShowOrder = new Vector();
        }
        this.m_actionShowOrder.add(title.toLowerCase());
    }

    public void removeActionSignature(String title) {
        this.m_actionSigs.remove(title.toLowerCase());
    }

    public void rememberSystemActionOrder() {
        this.m_originalSystemActionShowOrder = (Vector)this.m_actionShowOrder.clone();
    }

    public static void setHandleToActionBeingDrug(ActionSig handleToActionBeingDrug) {
        m_handleToActionBeingDrug = handleToActionBeingDrug;
    }

    public static ActionSig getHandleToActionBeingDrug() {
        return m_handleToActionBeingDrug;
    }

    public boolean containsSig(ActionSig sig) {
        if (this.m_actionSigs == null) {
            return false;
        }
        ActionSig as = this.m_actionSigs.get(sig.m_title.toLowerCase());
        if (as == null) {
            return false;
        }
        if (as == sig) {
            return true;
        }
        return as.compareTo(sig) == 0;
    }

    public void raiseCurrentIToolWindow() {
        ToolPalette2IDLComms.silentExecuteString("if iGetCurrent() then iSetCurrent, iGetCurrent(), /SHOW");
    }
}

