/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette;

import com.rsi.idldt.core.IDLNotifyListener;
import com.rsi.idldt.core.ResponseManager;
import com.rsi.idldt.toolpalette.ItoolClosedListener;
import com.rsi.idldt.toolpalette.ItoolIconChangeListener;
import com.rsi.idldt.toolpalette.views.ExistingVisView;
import com.rsi.jdml.IDLVariable;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.swt.graphics.ImageData;

public class ExistingVisDataModel {
    protected Vector<IDLNotifyListener> m_idlListeners = new Vector();
    protected HashMap<String, VisToolData> m_visToolDataHash = new HashMap();

    public ExistingVisDataModel() {
        this.registerIDLNotifications();
    }

    public void unregisterIDLNotifications() {
        for (IDLNotifyListener listener : this.m_idlListeners) {
            ResponseManager.removeIDLNotifyListener((IDLNotifyListener)listener);
        }
    }

    protected void addResponseManagerListener(IDLNotifyListener listener) {
        ResponseManager.addIDLNotifyListener((IDLNotifyListener)listener);
        this.m_idlListeners.add(listener);
    }

    protected void registerIDLNotifications() {
        this.addResponseManagerListener(new ItoolIconChangeListener());
        this.addResponseManagerListener(new ItoolClosedListener());
        IDLNotifyListener listener = new IDLNotifyListener("IDLReset"){

            public void handleIDLNotification(IDLVariable parm1, IDLVariable parm2) {
                ExistingVisDataModel.this.handleRemovalOfAllVisualizations();
            }
        };
        this.addResponseManagerListener(listener);
        listener = new IDLNotifyListener("IDLitSetCurrent"){

            public void handleIDLNotification(IDLVariable parm1, IDLVariable parm2) {
                ExistingVisDataModel.this.handleCurrentItoolChanged(parm1);
            }
        };
        this.addResponseManagerListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRemovalOfAllVisualizations() {
        HashMap<String, VisToolData> hashMap = this.m_visToolDataHash;
        synchronized (hashMap) {
            this.m_visToolDataHash.clear();
        }
        ExistingVisView[] evvs = ExistingVisView.getInstances();
        if (evvs != null) {
            ExistingVisView[] existingVisViewArray = evvs;
            int n = evvs.length;
            int n2 = 0;
            while (n2 < n) {
                ExistingVisView evv = existingVisViewArray[n2];
                evv.removeAllVisualizations();
                ++n2;
            }
        }
    }

    protected void handleCurrentItoolChanged(IDLVariable parm1) {
        ExistingVisView[] evvs = ExistingVisView.getInstances();
        if (evvs != null) {
            String toolID = parm1.getString();
            if (toolID == null) {
                return;
            }
            ExistingVisView[] existingVisViewArray = evvs;
            int n = evvs.length;
            int n2 = 0;
            while (n2 < n) {
                ExistingVisView evv = existingVisViewArray[n2];
                evv.handleCurrentItoolChanged(toolID.trim());
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleVisToolIconChange(String plotID, String plotTitle, ImageData imageData) {
        HashMap<String, VisToolData> hashMap = this.m_visToolDataHash;
        synchronized (hashMap) {
            if (this.m_visToolDataHash.containsKey(plotID)) {
                this.m_visToolDataHash.remove(plotID);
            }
            this.m_visToolDataHash.put(plotID, new VisToolData(plotID, plotTitle, imageData));
        }
        ExistingVisView[] evvs = ExistingVisView.getInstances();
        if (evvs != null) {
            ExistingVisView[] existingVisViewArray = evvs;
            int n = evvs.length;
            int n2 = 0;
            while (n2 < n) {
                ExistingVisView evv = existingVisViewArray[n2];
                evv.handleVisToolIconChange(plotID, plotTitle, imageData);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRemovalOfVisToolButton(String plotID) {
        HashMap<String, VisToolData> hashMap = this.m_visToolDataHash;
        synchronized (hashMap) {
            if (this.m_visToolDataHash.containsKey(plotID)) {
                this.m_visToolDataHash.remove(plotID);
            }
        }
        ExistingVisView[] evvs = ExistingVisView.getInstances();
        if (evvs != null) {
            ExistingVisView[] existingVisViewArray = evvs;
            int n = evvs.length;
            int n2 = 0;
            while (n2 < n) {
                ExistingVisView evv = existingVisViewArray[n2];
                evv.handleRemovalOfVisToolButton(plotID);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateView() {
        ExistingVisView[] evvs = ExistingVisView.getInstances();
        if (evvs == null) {
            return;
        }
        HashMap<String, VisToolData> hashMap = this.m_visToolDataHash;
        synchronized (hashMap) {
            for (VisToolData vtd : this.m_visToolDataHash.values()) {
                ExistingVisView[] existingVisViewArray = evvs;
                int n = evvs.length;
                int n2 = 0;
                while (n2 < n) {
                    ExistingVisView evv = existingVisViewArray[n2];
                    evv.handleVisToolIconChange(vtd.m_plotId, vtd.m_plotTitle, vtd.m_imageData);
                    ++n2;
                }
            }
        }
    }

    public class VisToolData {
        public String m_plotId;
        public String m_plotTitle;
        public ImageData m_imageData;

        public VisToolData(String plotId, String plotTitle, ImageData imageData) {
            this.m_plotId = plotId;
            this.m_plotTitle = plotTitle;
            this.m_imageData = imageData;
        }
    }
}

