/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette;

import com.rsi.idldt.toolpalette.ToolCatalogParser;
import com.rsi.idldt.toolpalette.internal.ui.ActionBar;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionSig
implements Comparable<ActionSig> {
    private static final String STRING_ITOOL = "iTool";
    private static final String STRING_DIRECT_GRAPHICS = "DirectGraphics";
    private static final String STRING_OBJECT_GRAPHICS = "ObjectGraphics";
    private static final String STRING_PROCESSING = "Processing";
    public ActionType m_actionType;
    public Composite m_plotBar;
    public String m_procName;
    public String m_overplotCmd = null;
    public ArrayList<String> m_argNames;
    public String m_staticArgs;
    public String m_desc;
    public String m_title;
    protected ActionSig m_backupSig;
    public int m_sigSystemOrUser = 0;
    private ActionBar m_actionBar;

    public ActionSig(int systemOrUser) {
        this.m_sigSystemOrUser = systemOrUser;
    }

    public ActionSig(ActionType actionType, int systemOrUser, String actionProcName, String overplotCmd, ArrayList<String> argNames, String staticArgs, String desc, String title) {
        this.m_actionType = actionType;
        this.m_sigSystemOrUser = systemOrUser;
        this.m_procName = actionProcName.toUpperCase();
        this.m_overplotCmd = overplotCmd;
        this.m_argNames = argNames;
        this.m_staticArgs = staticArgs;
        this.m_desc = desc;
        this.m_title = title;
        if (this.m_staticArgs != null) {
            this.m_staticArgs = ToolCatalogParser.removeDuplicateWhitespace(this.m_staticArgs);
        }
        if (this.m_desc != null) {
            this.m_desc = ToolCatalogParser.removeDuplicateWhitespace(this.m_desc);
        }
        if (this.m_title != null) {
            this.m_title = ToolCatalogParser.removeDuplicateWhitespace(this.m_title);
        }
    }

    public boolean isUserDefined() {
        return this.m_sigSystemOrUser == 1;
    }

    public boolean isSystemDefined() {
        return this.m_sigSystemOrUser == 0;
    }

    public void applyEdits(ActionSig sig) {
        if (this.m_backupSig == null) {
            this.m_backupSig = new ActionSig(this.m_sigSystemOrUser);
            this.m_backupSig.m_procName = this.m_procName;
            this.m_backupSig.m_overplotCmd = this.m_overplotCmd;
            this.m_backupSig.m_actionType = this.m_actionType;
            this.m_backupSig.m_argNames = this.m_argNames;
            this.m_backupSig.m_staticArgs = this.m_staticArgs;
            this.m_backupSig.m_desc = this.m_desc;
            this.m_backupSig.m_title = this.m_title;
        }
        this.m_procName = sig.m_procName;
        this.m_overplotCmd = sig.m_overplotCmd;
        this.m_actionType = sig.m_actionType;
        this.m_argNames = sig.m_argNames;
        this.m_staticArgs = sig.m_staticArgs;
        this.m_desc = sig.m_desc;
        this.m_title = sig.m_title;
    }

    public void cancelEdits(boolean bRevertBack) {
        if (this.m_backupSig == null) {
            return;
        }
        if (bRevertBack) {
            this.m_procName = this.m_backupSig.m_procName;
            this.m_overplotCmd = this.m_backupSig.m_overplotCmd;
            this.m_actionType = this.m_backupSig.m_actionType;
            this.m_argNames = this.m_backupSig.m_argNames;
            this.m_staticArgs = this.m_backupSig.m_staticArgs;
            this.m_desc = this.m_backupSig.m_desc;
            this.m_title = this.m_backupSig.m_title;
        }
        this.m_backupSig = null;
    }

    public String getCommaDelimitedArgNames() {
        StringBuffer b = new StringBuffer();
        int nSize = this.m_argNames.size();
        int i = 0;
        while (i < nSize) {
            String argName = this.m_argNames.get(i);
            b.append(argName.trim());
            if (i + 1 < nSize) {
                b.append(", ");
            }
            ++i;
        }
        String argNames = b.toString().trim();
        if (argNames.length() == 0) {
            argNames = null;
        }
        return argNames;
    }

    public void setActionBar(ActionBar actionBar) {
        this.m_actionBar = actionBar;
    }

    public void setOverplotCommand(String overplotCmd) {
        this.m_overplotCmd = overplotCmd;
    }

    public boolean hasOverplotCommand() {
        if (this.m_overplotCmd != null && this.m_overplotCmd.trim().length() == 0) {
            this.m_overplotCmd = null;
        }
        return this.m_overplotCmd != null;
    }

    public ActionBar getActionBar() {
        return this.m_actionBar;
    }

    public static ActionType getActionTypeFromString(String actionType) {
        if (actionType.equalsIgnoreCase(STRING_PROCESSING)) {
            return ActionType.PROCESSING;
        }
        if (actionType.equalsIgnoreCase(STRING_OBJECT_GRAPHICS)) {
            return ActionType.OBJECTGRAPHICS;
        }
        if (actionType.equalsIgnoreCase(STRING_DIRECT_GRAPHICS)) {
            return ActionType.DIRECTGRAPHICS;
        }
        return ActionType.ITOOL;
    }

    protected static String getActionTypeAsString(ActionType type) {
        if (type == ActionType.PROCESSING) {
            return STRING_PROCESSING;
        }
        if (type == ActionType.OBJECTGRAPHICS) {
            return STRING_OBJECT_GRAPHICS;
        }
        if (type == ActionType.DIRECTGRAPHICS) {
            return STRING_DIRECT_GRAPHICS;
        }
        return STRING_ITOOL;
    }

    public String getActionTypeAsString() {
        return ActionSig.getActionTypeAsString(this.m_actionType);
    }

    public static String[] getAllActionTypesAsString() {
        ActionType[] types = ActionType.values();
        String[] strValues = new String[types.length];
        int i = 0;
        ActionType[] actionTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ActionType type = actionTypeArray[n2];
            strValues[i] = ActionSig.getActionTypeAsString(type);
            ++i;
            ++n2;
        }
        return strValues;
    }

    @Override
    public int compareTo(ActionSig o) {
        int compare = this.m_title.compareTo(o.m_title);
        if (compare != 0) {
            return compare;
        }
        compare = this.m_procName.compareTo(o.m_procName);
        if (compare != 0) {
            return compare;
        }
        if (this.m_argNames.size() < o.m_argNames.size()) {
            return -1;
        }
        if (this.m_argNames.size() > o.m_argNames.size()) {
            return 1;
        }
        compare = this.m_staticArgs.compareTo(o.m_staticArgs);
        if (compare != 0) {
            return compare;
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ActionType {
        PROCESSING,
        DIRECTGRAPHICS,
        OBJECTGRAPHICS,
        ITOOL;

    }
}

