/*
 * Decompiled with CFR 0.152.
 */
package com.idl.javaidl;

import com.idl.javaidl.JIDLCanvas;
import com.idl.javaidl.JIDLCursorSupport;
import com.idl.javaidl.JIDLEventExtra;
import com.idl.javaidl.JIDLException;
import com.idl.javaidl.JIDLLong;
import com.idl.javaidl.JIDLNotifyListener;
import com.idl.javaidl.JIDLObjectI;
import com.idl.javaidl.JIDLOutputListener;
import com.idl.javaidl.JIDLPlatform;
import com.idl.javaidl.JIDLProcessInitializer;
import com.idl.javaidl.JIDLProcessLock;
import com.idl.javaidl.JIDLReturnObject;
import com.idl.javaidl.JIDLShutdownThread;
import java.awt.EventQueue;
import java.awt.event.ComponentEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JIDLPAL {
    private static final String BML_LIB_NAME = "idl_bml";
    private static final String AWT_LIB_NAME = "awt";
    private static final String JAWT_LIB_NAME = "jawt";
    private static final String JAVA_EXPORT_LIB_NAME = "javaidlb";
    private static String g_JavaBinLocation;
    private static String g_JavapalBinLocation;
    private static String g_BMLBinLocation;
    private long m_cookie;
    private JIDLObjectI m_object;
    private boolean m_bInBMLTransaction;
    private boolean m_bObjCreated;
    private int m_iOPSFlags;
    private String m_sProcessName;
    private JIDLProcessLock m_lock;
    private String m_sClassName;
    private String m_sLastError;
    private Vector m_IDLNotifyListeners;
    private static Hashtable g_cookieToPALMapping;
    private Vector m_IDLOutputListeners;
    private static boolean g_bIsListeningToIDL;
    private static int g_debugLevel;
    public static final int JAVAPAL_ERRCODE = -999;
    protected static final int AWTEVENT_RESIZED = 101;
    protected static final int AWTEVENT_SHIFT_MASK = 1;
    protected static final int AWTEVENT_CTRL_MASK = 2;
    protected static final int AWTEVENT_META_MASK = 4;
    protected static final int AWTEVENT_ALT_MASK = 8;
    protected static final int AWTEVENT_ALT_GRAPH_MASK = 32;
    protected static final int AWTEVENT_BUTTON1_MASK = 16;
    protected static final int AWTEVENT_BUTTON2_MASK = 8;
    protected static final int AWTEVENT_BUTTON3_MASK = 4;
    protected static final int AWTEVENT_MOUSE_CLICKED = 500;
    protected static final int AWTEVENT_MOUSE_DRAGGED = 506;
    protected static final int AWTEVENT_MOUSE_ENTERED = 504;
    protected static final int AWTEVENT_MOUSE_EXITED = 505;
    protected static final int AWTEVENT_MOUSE_MOVED = 503;
    protected static final int AWTEVENT_MOUSE_WHEEL_MOVED = 507;
    protected static final int AWTEVENT_MOUSE_PRESSED = 501;
    protected static final int AWTEVENT_MOUSE_RELEASED = 502;
    protected static final int AWTEVENT_KEY_RELEASED = 402;
    protected static final int AWTEVENT_KEY_PRESSED = 401;
    protected static final int AWTEVENT_VK_SHIFT = 16;
    protected static final int AWTEVENT_VK_CONTROL = 17;
    protected static final int AWTEVENT_VK_CAPS_LOCK = 20;
    protected static final int AWTEVENT_VK_META = 157;
    protected static final int AWTEVENT_VK_LEFT = 37;
    protected static final int AWTEVENT_VK_RIGHT = 39;
    protected static final int AWTEVENT_VK_UP = 38;
    protected static final int AWTEVENT_VK_DOWN = 40;
    protected static final int AWTEVENT_VK_PAGE_UP = 33;
    protected static final int AWTEVENT_VK_PAGE_DOWN = 34;
    protected static final int AWTEVENT_VK_HOME = 36;
    protected static final int AWTEVENT_VK_END = 35;
    protected static final int AWTEVENT_VK_DELETE = 127;
    protected static final int AWTEVENT_VK_ENTER = 10;
    public static final int GC_GLDEPTH = 1;
    public static final int GC_MESADEPTH = 2;
    public static final int GC_GLID = 3;
    public static final int GC_MESAID = 4;
    static /* synthetic */ Class class$com$idl$javaidl$JIDLCursorSupport;

    private static native void nativeInitJPAL();

    private static native void nativeShutdownJPAL();

    private static native boolean nativeIsRetValBad(long var0);

    public static native void dumpMemoryMap();

    private native void nativeThrowJIDLException(long var1, String var3, String var4);

    private native String nativeGetLastBMLError(JIDLLong var1);

    private native long nativeAbort(long var1);

    private native long nativeBMLBeginTransaction(long var1);

    private native void nativeBMLEndTransaction(long var1);

    private native long nativeRegisterWrapper(String var1, int var2, String var3);

    private native long nativeReleaseWrapper(long var1);

    private native long nativeCreateObject(long var1, int var3, Object[] var4, int[] var5, JIDLProcessInitializer var6, long var7, String var9);

    private native long nativeDestroyObject(long var1);

    private native long nativeCallProcedure(long var1, String var3, int var4, Object[] var5, int[] var6);

    private native JIDLReturnObject nativeCallFunction(long var1, String var3, int var4, Object[] var5, int[] var6, int var7);

    private native long nativeSetProperty(long var1, String var3, Object var4, int var5);

    private native JIDLReturnObject nativeGetProperty(long var1, String var3, int var4);

    private native long nativeOnEvent(long var1, ComponentEvent var3, JIDLEventExtra var4);

    private native long nativeOnExpose(long var1, JIDLCanvas var3);

    private static native int nativeGetDebugLevel();

    private static native void nativeRegisterOutputCallback();

    private native void nativeRegisterNotifyCallback(long var1);

    private native void nativeUnregisterNotifyCallback(long var1);

    public static void shutdownJPAL() {
        JIDLPAL.nativeShutdownJPAL();
    }

    public JIDLPAL(JIDLObjectI jIDLObjectI, String string) {
        JIDLPAL.printDebug("   =JIDLPAL::JIDLPAL()");
        this.m_cookie = 0L;
        this.m_object = jIDLObjectI;
        this.m_bInBMLTransaction = false;
        this.m_bObjCreated = false;
        this.m_sLastError = null;
        this.m_IDLNotifyListeners = null;
        this.m_IDLOutputListeners = null;
        this.setProcessMembers(string);
        this.m_lock = JIDLProcessLock.Instance(string);
    }

    private void setProcessMembers(String string) {
        if (!this.isObjectCreated()) {
            if (string == null || string.equals("")) {
                this.m_iOPSFlags = 0;
                this.m_sProcessName = "";
            } else {
                this.m_iOPSFlags = 1;
                this.m_sProcessName = string;
            }
        }
    }

    public String getIDLObjectClassName() {
        return this.m_sClassName;
    }

    public synchronized String getProcessName() {
        return this.m_sProcessName;
    }

    public synchronized void setProcessName(String string) {
        this.setProcessMembers(string);
    }

    private boolean verifyOPSName(int n, String string) {
        boolean bl = true;
        if (n == 1) {
            if (string == null || string.equals("")) {
                bl = false;
            } else {
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (Character.isLetterOrDigit(c) || c == '_' || c == '$') continue;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createObject(String string) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            this.createObject(string, 0, null, null, null, 0L, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createObject(String string, int n, Object[] objectArray, int[] nArray, JIDLProcessInitializer jIDLProcessInitializer) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            this.createObject(string, n, objectArray, nArray, jIDLProcessInitializer, 0L, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createObject(String string, int n, Object[] objectArray, int[] nArray) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            this.createObject(string, n, objectArray, nArray, null, 0L, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createObject(String string, int n, Object[] objectArray, int[] nArray, JIDLProcessInitializer jIDLProcessInitializer, long l, String string2) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            long l2 = 0L;
            if (!this.verifyOPSName(this.m_iOPSFlags, this.m_sProcessName)) {
                this.setLastError("Invalid OPS server name");
                this.throwJIDLException(-999L, "createObject", false);
            }
            this.m_cookie = this.nativeRegisterWrapper(string, this.m_iOPSFlags, this.m_sProcessName);
            if (JIDLPAL.nativeIsRetValBad(this.m_cookie)) {
                this.throwJIDLException(this.m_cookie, "RegisterWrapper", false);
            }
            JIDLPAL.addCookieToPALMapping(this.m_cookie, this);
            this.beginTransaction(this.m_cookie);
            l2 = this.nativeCreateObject(this.m_cookie, n, objectArray, nArray, jIDLProcessInitializer, l, string2);
            if (JIDLPAL.nativeIsRetValBad(l2)) {
                JIDLLong jIDLLong = new JIDLLong(0L);
                String string3 = this.nativeGetLastBMLError(jIDLLong);
                this.setLastError(string3);
                JIDLPAL.removeCookieToPALMapping(this.m_cookie);
                this.nativeReleaseWrapper(this.m_cookie);
                this.throwJIDLException(l2, "CreateObject", true);
            }
            this.endTransaction(this.m_cookie);
            this.m_sClassName = string;
            this.m_bObjCreated = true;
        }
    }

    public synchronized boolean isObjectCreated() {
        return this.m_bObjCreated;
    }

    private void verifyObjectCreated() {
        if (!this.m_bObjCreated) {
            throw new JIDLException(-1L, "Object has not been created.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject() {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            this.verifyObjectCreated();
            long l = 0L;
            JIDLPAL.printDebug("   >JIDLPAL::destroyObject()");
            JIDLPAL.removeCookieToPALMapping(this.m_cookie);
            this.beginTransaction(this.m_cookie);
            l = this.nativeDestroyObject(this.m_cookie);
            this.m_bObjCreated = false;
            long l2 = this.nativeReleaseWrapper(this.m_cookie);
            if (JIDLPAL.nativeIsRetValBad(l)) {
                this.throwJIDLException(l, "DestroyObject", true);
            }
            if (JIDLPAL.nativeIsRetValBad(l2)) {
                this.throwJIDLException(l2, "ReleaseWrapper", true);
            }
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::destroyObject()");
        }
    }

    public synchronized long getCookie() {
        return this.m_cookie;
    }

    public synchronized JIDLObjectI getObject() {
        return this.m_object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callProcedure(String string) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            this.callProcedure(string, 0, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callProcedure(String string, int n, Object[] objectArray, int[] nArray) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            JIDLPAL.printDebug("   >JIDLPAL::callProcedure(" + string + ")");
            this.verifyObjectCreated();
            this.printParams(n, objectArray, nArray);
            this.beginTransaction(this.m_cookie);
            long l = this.nativeCallProcedure(this.m_cookie, string, n, objectArray, nArray);
            if (JIDLPAL.nativeIsRetValBad(l)) {
                this.throwJIDLException(l, "CallProcedure", true);
            }
            this.printParams(n, objectArray, nArray);
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::callProcedure");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callFunction(String string) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            return this.callFunction(string, 0, null, null, 16384);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callFunction(String string, int n, Object[] objectArray, int[] nArray) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            return this.callFunction(string, n, objectArray, nArray, 16384);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callFunction(String string, int n, Object[] objectArray, int[] nArray, int n2) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            JIDLReturnObject jIDLReturnObject = null;
            this.verifyObjectCreated();
            JIDLPAL.printDebug("   >JIDLPAL::callFunction(" + string + ")");
            this.printParams(n, objectArray, nArray);
            this.beginTransaction(this.m_cookie);
            jIDLReturnObject = this.nativeCallFunction(this.m_cookie, string, n, objectArray, nArray, n2);
            this.printParams(n, objectArray, nArray);
            long l = jIDLReturnObject.getStatus();
            if (JIDLPAL.nativeIsRetValBad(l)) {
                this.throwJIDLException(l, "CallFunction", true);
            }
            Object object = jIDLReturnObject.getObject();
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::callFunction oResult=" + object);
            return object;
        }
    }

    private native int nativeComputeGCData(String var1);

    public boolean computeGCData() {
        long l = this.nativeComputeGCData(this.m_sProcessName);
        return !JIDLPAL.nativeIsRetValBad(l);
    }

    private native long nativeGetGCData(long var1);

    public long getGCData(long l) {
        return this.nativeGetGCData(l);
    }

    private native int nativeAttachObject(long var1, long var3, String var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int attachObject(long l, String string) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            return this.nativeAttachObject(this.m_cookie, l, string);
        }
    }

    public native long nativeObjRefCookie2HVID(long var1, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long objRefCookie2HVID(long l) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            return this.nativeObjRefCookie2HVID(this.m_cookie, l);
        }
    }

    private boolean OKtoProcessEvent() {
        return this.isObjectCreated() && this.m_cookie > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long OnExpose(JIDLCanvas jIDLCanvas) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            long l = -1L;
            if (this.OKtoProcessEvent()) {
                this.beginTransaction(this.m_cookie);
                l = this.nativeOnExpose(this.m_cookie, jIDLCanvas);
                this.endTransaction(this.m_cookie);
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long OnEvent(ComponentEvent componentEvent, JIDLEventExtra jIDLEventExtra) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            long l = -1L;
            if (this.OKtoProcessEvent()) {
                this.beginTransaction(this.m_cookie);
                l = this.nativeOnEvent(this.m_cookie, componentEvent, jIDLEventExtra);
                this.endTransaction(this.m_cookie);
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String string) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            return this.getProperty(string, 16384);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String string, int n) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            JIDLReturnObject jIDLReturnObject = null;
            this.verifyObjectCreated();
            JIDLPAL.printDebug("   >JIDLPAL::getProperty(" + string + ")");
            this.beginTransaction(this.m_cookie);
            jIDLReturnObject = this.nativeGetProperty(this.m_cookie, string, n);
            long l = jIDLReturnObject.getStatus();
            if (JIDLPAL.nativeIsRetValBad(l)) {
                this.throwJIDLException(l, "GetProperty", true);
            }
            Object object = jIDLReturnObject.getObject();
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::getProperty()");
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String string, Object object, int n) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            this.verifyObjectCreated();
            long l = 0L;
            JIDLPAL.printDebug("   >JIDLPAL::setProperty(" + string + ")");
            this.beginTransaction(this.m_cookie);
            l = this.nativeSetProperty(this.m_cookie, string, object, n);
            if (JIDLPAL.nativeIsRetValBad(l)) {
                this.throwJIDLException(l, "SetProperty", true);
            }
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::callProperty");
        }
    }

    private native String nativeGetObjVariableName(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIDLObjectVariableName() {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            String string = "";
            this.verifyObjectCreated();
            JIDLPAL.printDebug("   >JIDLPAL::getIDLObjectVariableName() cookie=" + this.m_cookie);
            this.beginTransaction(this.m_cookie);
            string = this.nativeGetObjVariableName(this.m_cookie);
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::getIDLObjectVariableName() sVar=" + string);
            return string;
        }
    }

    private native JIDLReturnObject nativeGetIDLVariable(long var1, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getIDLVariable(String string) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            JIDLReturnObject jIDLReturnObject = null;
            this.verifyObjectCreated();
            JIDLPAL.printDebug("   >JIDLPAL::getIDLVariable(" + string + ") cookie=" + this.m_cookie);
            this.beginTransaction(this.m_cookie);
            jIDLReturnObject = this.nativeGetIDLVariable(this.m_cookie, string);
            long l = jIDLReturnObject.getStatus();
            if (JIDLPAL.nativeIsRetValBad(l)) {
                this.throwJIDLException(l, "GetIDLVariable", true);
            }
            Object object = jIDLReturnObject.getObject();
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::getIDLVariable() oVar=" + object);
            return object;
        }
    }

    private native int nativeSetIDLVariable(long var1, String var3, Object var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIDLVariable(String string, Object object) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            long l = 0L;
            JIDLPAL.printDebug("   >JIDLPAL::setIDLVariable(" + string + ") cookie=" + this.m_cookie);
            this.verifyObjectCreated();
            this.beginTransaction(this.m_cookie);
            l = this.nativeSetIDLVariable(this.m_cookie, string, object);
            if (JIDLPAL.nativeIsRetValBad(l)) {
                this.throwJIDLException(l, "SetIDLVariable", true);
            }
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::setIDLVariable");
        }
    }

    private native int nativeExecuteString(long var1, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeString(String string) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            long l = 0L;
            JIDLPAL.printDebug("   >JIDLPAL::executeString(" + string + ") cookie=" + this.m_cookie);
            this.verifyObjectCreated();
            this.beginTransaction(this.m_cookie);
            l = this.nativeExecuteString(this.m_cookie, string);
            if (JIDLPAL.nativeIsRetValBad(l)) {
                this.throwJIDLException(l, "ExecuteString", true);
            }
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::executeString");
        }
    }

    public synchronized void addIDLOutputListener(JIDLOutputListener jIDLOutputListener) {
        if (jIDLOutputListener != null) {
            if (this.m_IDLOutputListeners == null) {
                this.m_IDLOutputListeners = new Vector(1);
            }
            if (!this.m_IDLOutputListeners.contains(jIDLOutputListener)) {
                this.m_IDLOutputListeners.add(jIDLOutputListener);
                if (!g_bIsListeningToIDL) {
                    JIDLPAL.nativeRegisterOutputCallback();
                    g_bIsListeningToIDL = true;
                }
            }
        }
    }

    public synchronized void removeIDLOutputListener(JIDLOutputListener jIDLOutputListener) {
        if (this.m_IDLOutputListeners != null && jIDLOutputListener != null) {
            this.m_IDLOutputListeners.remove(jIDLOutputListener);
        }
    }

    public void broadcastIDLOutput(String string) {
        if (this.m_IDLOutputListeners != null && !this.m_IDLOutputListeners.isEmpty()) {
            for (int i = 0; i < this.m_IDLOutputListeners.size(); ++i) {
                JIDLOutputListener jIDLOutputListener = (JIDLOutputListener)this.m_IDLOutputListeners.elementAt(i);
                jIDLOutputListener.IDLoutput(this.m_object, string);
            }
        }
    }

    protected static void routeIDLOutputToObject(long l, String string) {
        final JIDLPAL jIDLPAL = JIDLPAL.getPALFromCookie(l);
        final String string2 = string;
        if (jIDLPAL != null) {
            try {
                if (jIDLPAL.canRouteInThisThread()) {
                    jIDLPAL.broadcastIDLOutput(string2);
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                jIDLPAL.broadcastIDLOutput(string2);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void broadcastCursorChange(String string) {
        if ((class$com$idl$javaidl$JIDLCursorSupport == null ? (class$com$idl$javaidl$JIDLCursorSupport = JIDLPAL.class$("com.idl.javaidl.JIDLCursorSupport")) : class$com$idl$javaidl$JIDLCursorSupport).isAssignableFrom(this.m_object.getClass())) {
            ((JIDLCursorSupport)((Object)this.m_object)).setCursor(string);
        }
    }

    protected static void routeCursorChangeToObject(long l, String string) {
        final JIDLPAL jIDLPAL = JIDLPAL.getPALFromCookie(l);
        final String string2 = string;
        if (jIDLPAL != null) {
            try {
                if (jIDLPAL.canRouteInThisThread()) {
                    jIDLPAL.broadcastCursorChange(string2);
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                jIDLPAL.broadcastCursorChange(string2);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public synchronized void addIDLNotifyListener(JIDLNotifyListener jIDLNotifyListener) {
        if (jIDLNotifyListener != null) {
            if (this.m_IDLNotifyListeners == null) {
                this.m_IDLNotifyListeners = new Vector(1);
            }
            if (!this.m_IDLNotifyListeners.contains(jIDLNotifyListener)) {
                this.m_IDLNotifyListeners.add(jIDLNotifyListener);
                this.nativeRegisterNotifyCallback(this.m_cookie);
            }
        }
    }

    public synchronized void removeIDLNotifyListener(JIDLNotifyListener jIDLNotifyListener) {
        if (this.m_IDLNotifyListeners != null && jIDLNotifyListener != null) {
            this.m_IDLNotifyListeners.remove(jIDLNotifyListener);
        }
        if (this.m_IDLNotifyListeners == null || this.m_IDLNotifyListeners.size() == 0) {
            this.nativeUnregisterNotifyCallback(this.m_cookie);
        }
    }

    private void broadcastNotify(String string, String string2) {
        if (this.m_IDLNotifyListeners != null && !this.m_IDLNotifyListeners.isEmpty()) {
            JIDLNotifyListener jIDLNotifyListener = null;
            for (int i = 0; i < this.m_IDLNotifyListeners.size(); ++i) {
                jIDLNotifyListener = (JIDLNotifyListener)this.m_IDLNotifyListeners.elementAt(i);
                jIDLNotifyListener.OnIDLNotify(this.m_object, string, string2);
            }
        }
    }

    protected static void routeNotifyToObject(long l, String string, String string2) {
        final JIDLPAL jIDLPAL = JIDLPAL.getPALFromCookie(l);
        final String string3 = string;
        final String string4 = string2;
        if (jIDLPAL != null) {
            try {
                if (jIDLPAL.canRouteInThisThread()) {
                    jIDLPAL.broadcastNotify(string3, string4);
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                jIDLPAL.broadcastNotify(string3, string4);
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void abort() {
        long l = 0L;
        this.verifyObjectCreated();
        l = this.nativeAbort(this.m_cookie);
        if (l == -2003L) {
            this.throwSpecificException(l, "Current object not allowed to abort another object's IDL activity.", false, "abort");
        } else if (l == -2004L) {
            this.throwSpecificException(l, "There is no IDL activity to abort.", false, "abort");
        }
        if (JIDLPAL.nativeIsRetValBad(l)) {
            this.throwJIDLException(l, "abort", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction(long l) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            long l2 = 0L;
            l2 = this.nativeBMLBeginTransaction(l);
            if (JIDLPAL.nativeIsRetValBad(l2)) {
                this.throwJIDLException(l2, "beginTransaction", false);
            }
            this.m_bInBMLTransaction = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction(long l) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            if (this.m_bInBMLTransaction) {
                this.nativeBMLEndTransaction(l);
            }
            this.m_bInBMLTransaction = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwSpecificException(long l, String string, boolean bl, String string2) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            if (bl) {
                this.endTransaction(this.m_cookie);
            }
            if (l == 0L && JIDLPAL.getTrackedObjectsCount() == 0) {
                System.err.println("Fatal error: The BML/IDL have failed initialization");
                System.err.println("Often this due to a library mismatch or missing library");
                System.err.println("Check for existence of and BML compatability with the following libraries:");
                System.err.println("  libidl.so (Unix)           / idl.dll (Windows)");
                System.err.println("  libidl_ops.so (Unix)       / idl_ops.dll (Windows)");
                System.err.println("  libidl_ipcclient.so (Unix) / idl_ipcclient.dll (Windows)");
            }
            this.nativeThrowJIDLException(l, string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwJIDLException(long l, String string, boolean bl) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            String string2 = null;
            long l2 = 0L;
            string2 = this.getLastError();
            if (string2 != null) {
                l2 = -999L;
            } else {
                JIDLLong jIDLLong = new JIDLLong(0L);
                string2 = this.nativeGetLastBMLError(jIDLLong);
                l2 = jIDLLong.longValue();
            }
            if (string2 == null) {
                l2 = -999L;
                string2 = "Unknown JavaPAL error occurred";
            }
            this.throwSpecificException(l2, string2, bl, string);
        }
    }

    public static int getTrackedObjectsCount() {
        return g_cookieToPALMapping.size();
    }

    public static JIDLObjectI[] getAllTrackedObjects() {
        int n = g_cookieToPALMapping.size();
        if (n == 0) {
            return null;
        }
        JIDLObjectI[] jIDLObjectIArray = new JIDLObjectI[n];
        int n2 = 0;
        Enumeration enumeration = g_cookieToPALMapping.elements();
        while (enumeration.hasMoreElements()) {
            JIDLPAL jIDLPAL = (JIDLPAL)enumeration.nextElement();
            JIDLObjectI jIDLObjectI = jIDLPAL.getObject();
            jIDLObjectIArray[n2++] = jIDLObjectI;
        }
        return jIDLObjectIArray;
    }

    private static JIDLPAL getPALFromCookie(long l) {
        Object v = g_cookieToPALMapping.get(new Long(l));
        return (JIDLPAL)v;
    }

    private static void addCookieToPALMapping(long l, Object object) {
        g_cookieToPALMapping.put(new Long(l), object);
    }

    private static void removeCookieToPALMapping(long l) {
        if (g_cookieToPALMapping != null) {
            g_cookieToPALMapping.remove(new Long(l));
        }
    }

    protected static void setLastError(long l, String string) {
        JIDLPAL jIDLPAL = JIDLPAL.getPALFromCookie(l);
        if (jIDLPAL != null) {
            jIDLPAL.setLastError(string);
        }
    }

    public synchronized void setLastError(String string) {
        this.m_sLastError = string;
    }

    public synchronized String getLastError() {
        String string = this.m_sLastError;
        this.m_sLastError = null;
        return string;
    }

    private boolean canRouteInThisThread() {
        boolean bl = false;
        if (!this.m_object.isObjectDisplayable()) {
            bl = true;
        } else if (EventQueue.isDispatchThread()) {
            bl = true;
        }
        return bl;
    }

    private static void printDebug(String string) {
        if (g_debugLevel > 0) {
            System.out.println(string);
        }
    }

    private void printParams(int n, Object[] objectArray, int[] nArray) {
        JIDLPAL.printDebug("      argc=" + n);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] != null) {
                    JIDLPAL.printDebug("      arg[" + i + "]: " + " hash:" + objectArray[i].hashCode() + " class:" + objectArray[i].getClass().toString() + " flags:0x0" + Integer.toHexString(nArray[i]));
                    continue;
                }
                JIDLPAL.printDebug("      arg[" + i + "]: null");
            }
        }
    }

    public String toString() {
        return "" + this.getClass().getName() + "[cookie=" + this.m_cookie + " bObjCreated=" + this.m_bObjCreated + "]";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        g_debugLevel = 0;
        g_JavaBinLocation = JIDLPlatform.getJavaLibraryLocation();
        g_JavapalBinLocation = JIDLPlatform.getJavaPALLibraryLocation();
        g_BMLBinLocation = JIDLPlatform.getBMLLibraryLocation();
        if (!JIDLPlatform.isWindows() || JIDLPlatform.loadNeededLibrary(g_BMLBinLocation, BML_LIB_NAME) < 0) {
            // empty if block
        }
        if (JIDLPlatform.platformSupportsOutOfProcessGraphics()) {
            if (JIDLPlatform.loadNeededLibrary(g_JavaBinLocation, AWT_LIB_NAME) < 0) {
                // empty if block
            }
            if (JIDLPlatform.loadNeededLibrary(g_JavaBinLocation, JAWT_LIB_NAME) < 0) {
                // empty if block
            }
        }
        if (JIDLPlatform.loadNeededLibrary(g_JavapalBinLocation, JAVA_EXPORT_LIB_NAME) < 0) {
            // empty if block
        }
        JIDLPAL.nativeInitJPAL();
        g_debugLevel = JIDLPAL.nativeGetDebugLevel();
        g_cookieToPALMapping = new Hashtable();
        g_bIsListeningToIDL = false;
        Runtime.getRuntime().addShutdownHook(new JIDLShutdownThread());
    }
}

