/*
 * Decompiled with CFR 0.152.
 */
package com.idl.javaidl;

import com.idl.javaidl.JIDLComponentListener;
import com.idl.javaidl.JIDLCursorSupport;
import com.idl.javaidl.JIDLEventExtra;
import com.idl.javaidl.JIDLException;
import com.idl.javaidl.JIDLJAWT;
import com.idl.javaidl.JIDLKeyEventExtra;
import com.idl.javaidl.JIDLKeyListener;
import com.idl.javaidl.JIDLMouseListener;
import com.idl.javaidl.JIDLMouseMotionListener;
import com.idl.javaidl.JIDLMouseWheelListener;
import com.idl.javaidl.JIDLNotifyListener;
import com.idl.javaidl.JIDLObjectI;
import com.idl.javaidl.JIDLOutputListener;
import com.idl.javaidl.JIDLPAL;
import com.idl.javaidl.JIDLPlatform;
import com.idl.javaidl.JIDLProcessInitializer;
import com.idl.javaidl.JIDLX11SunJDKReflection;
import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Vector;
import javax.swing.JPopupMenu;

public abstract class JIDLCanvas
extends Canvas
implements JIDLObjectI,
ComponentListener,
KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
JIDLMouseListener,
JIDLMouseMotionListener,
JIDLMouseWheelListener,
JIDLKeyListener,
JIDLComponentListener,
JIDLCursorSupport {
    public static final int OPENGL_RENDERER = 0;
    public static final int IDL_SOFTWARE_RENDERER = 1;
    private JIDLPAL m_interface;
    private String m_sClass;
    private JIDLJAWT m_jawt;
    private long m_hwnd;
    private boolean m_bObjCreated;
    private boolean m_isDestroyed;
    protected String m_keywords;
    private Vector m_IDLComponentListeners;
    private Vector m_IDLMouseListeners;
    private Vector m_IDLMouseWheelListeners;
    private Vector m_IDLMouseMotionListeners;
    private Vector m_IDLKeyListeners;
    private int m_lastX;
    private int m_lastY;

    private static GraphicsConfiguration chooseGC(int n, String string) {
        JIDLPAL jIDLPAL = new JIDLPAL(null, "IDL$GCCHOOSER");
        if (jIDLPAL.computeGCData()) {
            int n2;
            long l;
            long l2;
            if (n == 0) {
                l2 = jIDLPAL.getGCData(1L);
                l = jIDLPAL.getGCData(3L);
            } else {
                l2 = jIDLPAL.getGCData(2L);
                l = jIDLPAL.getGCData(4L);
            }
            GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
            for (n2 = 0; n2 < graphicsConfigurationArray.length; ++n2) {
                long l3 = JIDLX11SunJDKReflection.graphicsConfigurationGetVisualID(graphicsConfigurationArray[n2]);
                if (l3 != l) continue;
                return graphicsConfigurationArray[n2];
            }
            for (n2 = 0; n2 < graphicsConfigurationArray.length; ++n2) {
                int n3 = graphicsConfigurationArray[n2].getColorModel().getPixelSize();
                if ((long)n3 != l2) continue;
                return graphicsConfigurationArray[n2];
            }
        }
        return null;
    }

    public JIDLCanvas(String string, String string2, int n) {
        super(JIDLCanvas.chooseGC(string2 == "" ? n : 1, string2));
        if (!JIDLPlatform.platformSupportsGraphics()) {
            throw new JIDLException(-1L, "JIDLCanvas is not supported on this platform.");
        }
        if (string2 != "") {
            n = 1;
            if (!JIDLPlatform.platformSupportsOutOfProcessGraphics()) {
                throw new JIDLException(-1L, "JIDLCanvas is not supported on this platform.");
            }
        }
        this.m_sClass = string;
        this.m_jawt = null;
        this.m_hwnd = 0L;
        this.m_bObjCreated = false;
        this.m_isDestroyed = false;
        this.m_IDLKeyListeners = null;
        this.m_IDLMouseListeners = null;
        this.m_IDLMouseWheelListeners = null;
        this.m_IDLMouseMotionListeners = null;
        this.m_lastX = 0;
        this.m_lastY = 0;
        this.m_keywords = "RENDERER=" + Integer.toString(n).trim();
        this.m_interface = new JIDLPAL(this, string2);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    public JIDLCanvas(String string, String string2) {
        this(string, string2, 1);
    }

    public JIDLCanvas(String string, int n, String string2) {
        this(string, string2);
    }

    public void createObject() {
        this.createObject(0, null, null, null);
    }

    public void createObject(JIDLProcessInitializer jIDLProcessInitializer) {
        this.createObject(0, null, null, jIDLProcessInitializer);
    }

    public void createObject(int n, Object[] objectArray, int[] nArray) {
        this.createObject(n, objectArray, nArray, null);
    }

    public synchronized void createObject(int n, Object[] objectArray, int[] nArray, JIDLProcessInitializer jIDLProcessInitializer) {
        if (this.m_isDestroyed) {
            throw new JIDLException(-1L, "Wrapper has been destroyed.");
        }
        if (this.m_interface != null) {
            this.m_jawt = new JIDLJAWT(this);
            if (this.m_jawt != null) {
                this.m_hwnd = this.m_jawt.getWindowHandle();
            }
            if (this.m_hwnd <= 0L) {
                this.m_hwnd = 0L;
                this.m_jawt = null;
                throw new JIDLException(-1L, "Unable to acquire native display area for use by JIDLCanvas");
            }
            try {
                this.m_interface.createObject(this.m_sClass, n, objectArray, nArray, jIDLProcessInitializer, this.m_hwnd, this.m_keywords);
                this.initListeners();
                this.addKeyListener(this);
                this.addMouseListener(this);
                this.addMouseWheelListener(this);
                this.addMouseMotionListener(this);
                this.addComponentListener(this);
                this.repaint();
            }
            catch (JIDLException jIDLException) {
                this.m_hwnd = 0L;
                this.m_jawt = null;
                this.m_bObjCreated = false;
                throw jIDLException;
            }
            this.m_bObjCreated = true;
        }
    }

    public void initListeners() {
        this.addIDLComponentListener(this);
        this.addIDLKeyListener(this);
        this.addIDLMouseWheelListener(this);
        this.addIDLMouseListener(this);
        this.addIDLMouseMotionListener(this);
    }

    public synchronized void destroyObject() {
        this.m_jawt = null;
        this.m_hwnd = 0L;
        if (this.m_bObjCreated && this.m_interface != null) {
            this.m_interface.destroyObject();
        }
        this.removeNotify();
        this.m_interface = null;
        this.m_isDestroyed = true;
        this.m_bObjCreated = false;
    }

    public boolean isObjectCreated() {
        return this.m_bObjCreated;
    }

    public boolean isObjectDisplayable() {
        return true;
    }

    public boolean isObjCreated() {
        return this.isObjectCreated();
    }

    public void abort() {
        if (this.m_interface != null) {
            this.m_interface.abort();
        }
    }

    public long getCookie() {
        long l = -1L;
        if (this.m_interface != null) {
            l = this.m_interface.getCookie();
        }
        return l;
    }

    public String getProcessName() {
        if (this.m_interface != null) {
            return this.m_interface.getProcessName();
        }
        return "";
    }

    public void setProcessName(String string) {
        if (this.m_interface != null) {
            this.m_interface.setProcessName(string);
        }
    }

    public String getIDLObjectClassName() {
        return this.m_sClass;
    }

    public String getClassName() {
        return this.getIDLObjectClassName();
    }

    public void callProcedure(String string) {
        if (this.m_interface != null) {
            this.m_interface.callProcedure(string, 0, null, null);
        }
    }

    public void callProcedure(String string, int n, Object[] objectArray, int[] nArray) {
        if (this.m_interface != null) {
            this.m_interface.callProcedure(string, n, objectArray, nArray);
        }
    }

    public Object callFunction(String string, int n) {
        return this.callFunction(string, 0, null, null, n);
    }

    public Object callFunction(String string, int n, Object[] objectArray, int[] nArray, int n2) {
        Object object = null;
        if (this.m_interface != null) {
            object = this.m_interface.callFunction(string, n, objectArray, nArray, n2);
        }
        return object;
    }

    public Object getProperty(String string, int n) {
        Object object = null;
        if (this.m_interface != null) {
            object = this.m_interface.getProperty(string, n);
        }
        return object;
    }

    public void setProperty(String string, Object object, int n) {
        if (this.m_interface != null) {
            this.m_interface.setProperty(string, object, n);
        }
    }

    public String getObjVariableName() {
        return this.getIDLObjectVariableName();
    }

    public String getIDLObjectVariableName() {
        String string = "";
        if (this.m_interface != null) {
            string = this.m_interface.getIDLObjectVariableName();
        }
        return string;
    }

    public Object getIDLVariable(String string) {
        Object object = null;
        if (this.m_interface != null) {
            object = this.m_interface.getIDLVariable(string);
        }
        return object;
    }

    public void setIDLVariable(String string, Object object) {
        if (this.m_interface != null) {
            this.m_interface.setIDLVariable(string, object);
        }
    }

    public void executeString(String string) {
        if (this.m_interface != null) {
            this.m_interface.executeString(string);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public synchronized void draw() {
        if (this.m_bObjCreated && this.m_hwnd > 0L && this.m_jawt != null && this.m_interface != null) {
            if (this.m_IDLComponentListeners != null) {
                JIDLComponentListener jIDLComponentListener = null;
                for (int i = 0; i < this.m_IDLComponentListeners.size(); ++i) {
                    jIDLComponentListener = (JIDLComponentListener)this.m_IDLComponentListeners.elementAt(i);
                    jIDLComponentListener.IDLcomponentExposed(this);
                }
            } else {
                this.IDLcomponentExposed(this);
            }
        }
    }

    public void paint(Graphics graphics) {
        this.draw();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public final void componentResized(ComponentEvent componentEvent) {
        if (this.m_IDLComponentListeners != null) {
            JIDLComponentListener jIDLComponentListener = null;
            for (int i = 0; i < this.m_IDLComponentListeners.size(); ++i) {
                jIDLComponentListener = (JIDLComponentListener)this.m_IDLComponentListeners.elementAt(i);
                jIDLComponentListener.IDLcomponentResized(this, componentEvent);
            }
        } else {
            this.IDLcomponentResized(this, componentEvent);
        }
    }

    public final void mousePressed(MouseEvent mouseEvent) {
        if (this.m_IDLMouseListeners != null) {
            JIDLMouseListener jIDLMouseListener = null;
            for (int i = 0; i < this.m_IDLMouseListeners.size(); ++i) {
                jIDLMouseListener = (JIDLMouseListener)this.m_IDLMouseListeners.elementAt(i);
                jIDLMouseListener.IDLmousePressed(this, mouseEvent);
            }
        }
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_IDLMouseListeners != null) {
            JIDLMouseListener jIDLMouseListener = null;
            for (int i = 0; i < this.m_IDLMouseListeners.size(); ++i) {
                jIDLMouseListener = (JIDLMouseListener)this.m_IDLMouseListeners.elementAt(i);
                jIDLMouseListener.IDLmouseReleased(this, mouseEvent);
            }
        }
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
        if (this.m_IDLMouseListeners != null) {
            JIDLMouseListener jIDLMouseListener = null;
            for (int i = 0; i < this.m_IDLMouseListeners.size(); ++i) {
                jIDLMouseListener = (JIDLMouseListener)this.m_IDLMouseListeners.elementAt(i);
                jIDLMouseListener.IDLmouseEntered(this, mouseEvent);
            }
        }
        if (this.m_IDLKeyListeners != null) {
            this.requestFocus();
        }
    }

    public final void mouseExited(MouseEvent mouseEvent) {
        if (this.m_IDLMouseListeners != null) {
            JIDLMouseListener jIDLMouseListener = null;
            for (int i = 0; i < this.m_IDLMouseListeners.size(); ++i) {
                jIDLMouseListener = (JIDLMouseListener)this.m_IDLMouseListeners.elementAt(i);
                jIDLMouseListener.IDLmouseExited(this, mouseEvent);
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.m_lastX = mouseWheelEvent.getX();
        this.m_lastY = mouseWheelEvent.getY();
        if (this.m_IDLMouseWheelListeners != null) {
            JIDLMouseWheelListener jIDLMouseWheelListener = null;
            for (int i = 0; i < this.m_IDLMouseWheelListeners.size(); ++i) {
                jIDLMouseWheelListener = (JIDLMouseWheelListener)this.m_IDLMouseWheelListeners.elementAt(i);
                jIDLMouseWheelListener.IDLmouseWheelMoved(this, mouseWheelEvent);
            }
        }
    }

    public final void mouseMoved(MouseEvent mouseEvent) {
        this.m_lastX = mouseEvent.getX();
        this.m_lastY = mouseEvent.getY();
        if (this.m_IDLMouseMotionListeners != null) {
            JIDLMouseMotionListener jIDLMouseMotionListener = null;
            for (int i = 0; i < this.m_IDLMouseMotionListeners.size(); ++i) {
                jIDLMouseMotionListener = (JIDLMouseMotionListener)this.m_IDLMouseMotionListeners.elementAt(i);
                jIDLMouseMotionListener.IDLmouseMoved(this, mouseEvent);
            }
        }
    }

    public final void mouseDragged(MouseEvent mouseEvent) {
        this.m_lastX = mouseEvent.getX();
        this.m_lastY = mouseEvent.getY();
        if (this.m_IDLMouseMotionListeners != null) {
            JIDLMouseMotionListener jIDLMouseMotionListener = null;
            for (int i = 0; i < this.m_IDLMouseMotionListeners.size(); ++i) {
                jIDLMouseMotionListener = (JIDLMouseMotionListener)this.m_IDLMouseMotionListeners.elementAt(i);
                jIDLMouseMotionListener.IDLmouseDragged(this, mouseEvent);
            }
        }
    }

    public final void keyPressed(KeyEvent keyEvent) {
        if (this.m_IDLKeyListeners != null) {
            JIDLKeyListener jIDLKeyListener = null;
            for (int i = 0; i < this.m_IDLKeyListeners.size(); ++i) {
                jIDLKeyListener = (JIDLKeyListener)this.m_IDLKeyListeners.elementAt(i);
                jIDLKeyListener.IDLkeyPressed(this, keyEvent, this.m_lastX, this.m_lastY);
            }
        }
    }

    public final void keyReleased(KeyEvent keyEvent) {
        if (this.m_IDLKeyListeners != null) {
            JIDLKeyListener jIDLKeyListener = null;
            for (int i = 0; i < this.m_IDLKeyListeners.size(); ++i) {
                jIDLKeyListener = (JIDLKeyListener)this.m_IDLKeyListeners.elementAt(i);
                jIDLKeyListener.IDLkeyReleased(this, keyEvent, this.m_lastX, this.m_lastY);
            }
        }
    }

    protected void postIDLEvent(ComponentEvent componentEvent, JIDLEventExtra jIDLEventExtra) {
        if (this.m_interface != null && componentEvent != null) {
            this.m_interface.OnEvent(componentEvent, jIDLEventExtra);
        }
    }

    public void addIDLComponentListener(JIDLComponentListener jIDLComponentListener) {
        if (jIDLComponentListener != null) {
            if (this.m_IDLComponentListeners == null) {
                this.m_IDLComponentListeners = new Vector(1);
            }
            if (!this.m_IDLComponentListeners.contains(jIDLComponentListener)) {
                this.m_IDLComponentListeners.add(jIDLComponentListener);
            }
        }
    }

    public void removeIDLComponentListener(JIDLComponentListener jIDLComponentListener) {
        if (this.m_IDLComponentListeners != null && jIDLComponentListener != null) {
            this.m_IDLComponentListeners.remove(jIDLComponentListener);
        }
    }

    public synchronized void IDLcomponentExposed(JIDLObjectI jIDLObjectI) {
        long l;
        if (this.m_bObjCreated && this.m_hwnd > 0L && this.m_jawt != null && this.m_interface != null && (l = this.m_jawt.lock()) != 0L) {
            this.m_interface.OnExpose(this);
            this.m_jawt.unlock();
        }
    }

    public synchronized void IDLcomponentResized(JIDLObjectI jIDLObjectI, ComponentEvent componentEvent) {
        if (this.m_bObjCreated) {
            this.postIDLEvent(componentEvent, null);
        }
    }

    public void addIDLKeyListener(JIDLKeyListener jIDLKeyListener) {
        if (jIDLKeyListener != null) {
            if (this.m_IDLKeyListeners == null) {
                this.m_IDLKeyListeners = new Vector(1);
            }
            if (!this.m_IDLKeyListeners.contains(jIDLKeyListener)) {
                this.m_IDLKeyListeners.add(jIDLKeyListener);
            }
        }
    }

    public void removeIDLKeyListener(JIDLKeyListener jIDLKeyListener) {
        if (this.m_IDLKeyListeners != null && jIDLKeyListener != null) {
            this.m_IDLKeyListeners.remove(jIDLKeyListener);
        }
    }

    public void IDLkeyPressed(JIDLObjectI jIDLObjectI, KeyEvent keyEvent, int n, int n2) {
        this.postIDLEvent(keyEvent, new JIDLKeyEventExtra(n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isCapsLocked() {
        boolean bl = false;
        bl = this.getToolkit().getLockingKeyState(20);
        return bl;
    }

    public void IDLkeyReleased(JIDLObjectI jIDLObjectI, KeyEvent keyEvent, int n, int n2) {
        this.postIDLEvent(keyEvent, new JIDLKeyEventExtra(n, n2));
    }

    public void addIDLMouseWheelListener(JIDLMouseWheelListener jIDLMouseWheelListener) {
        if (jIDLMouseWheelListener != null) {
            if (this.m_IDLMouseWheelListeners == null) {
                this.m_IDLMouseWheelListeners = new Vector(1);
            }
            if (!this.m_IDLMouseWheelListeners.contains(jIDLMouseWheelListener)) {
                this.m_IDLMouseWheelListeners.add(jIDLMouseWheelListener);
            }
        }
    }

    public void removeIDLMouseWheelListener(JIDLMouseWheelListener jIDLMouseWheelListener) {
        if (this.m_IDLMouseWheelListeners != null && jIDLMouseWheelListener != null) {
            this.m_IDLMouseWheelListeners.remove(jIDLMouseWheelListener);
        }
    }

    public void IDLmouseWheelMoved(JIDLObjectI jIDLObjectI, MouseWheelEvent mouseWheelEvent) {
        this.postIDLEvent(mouseWheelEvent, null);
    }

    public void addIDLMouseListener(JIDLMouseListener jIDLMouseListener) {
        if (jIDLMouseListener != null) {
            if (this.m_IDLMouseListeners == null) {
                this.m_IDLMouseListeners = new Vector(1);
            }
            if (!this.m_IDLMouseListeners.contains(jIDLMouseListener)) {
                this.m_IDLMouseListeners.add(jIDLMouseListener);
            }
        }
    }

    public void removeIDLMouseListener(JIDLMouseListener jIDLMouseListener) {
        if (this.m_IDLMouseListeners != null && jIDLMouseListener != null) {
            this.m_IDLMouseListeners.remove(jIDLMouseListener);
        }
    }

    public void IDLmousePressed(JIDLObjectI jIDLObjectI, MouseEvent mouseEvent) {
        this.postIDLEvent(mouseEvent, null);
    }

    public void IDLmouseReleased(JIDLObjectI jIDLObjectI, MouseEvent mouseEvent) {
        this.postIDLEvent(mouseEvent, null);
    }

    public void IDLmouseEntered(JIDLObjectI jIDLObjectI, MouseEvent mouseEvent) {
        this.postIDLEvent(mouseEvent, null);
    }

    public void IDLmouseExited(JIDLObjectI jIDLObjectI, MouseEvent mouseEvent) {
        this.postIDLEvent(mouseEvent, null);
    }

    public void addIDLMouseMotionListener(JIDLMouseMotionListener jIDLMouseMotionListener) {
        if (jIDLMouseMotionListener != null) {
            if (this.m_IDLMouseMotionListeners == null) {
                this.m_IDLMouseMotionListeners = new Vector(1);
            }
            if (!this.m_IDLMouseMotionListeners.contains(jIDLMouseMotionListener)) {
                this.m_IDLMouseMotionListeners.add(jIDLMouseMotionListener);
            }
        }
    }

    public void removeIDLMouseMotionListener(JIDLMouseMotionListener jIDLMouseMotionListener) {
        if (this.m_IDLMouseMotionListeners != null && jIDLMouseMotionListener != null) {
            this.m_IDLMouseMotionListeners.remove(jIDLMouseMotionListener);
        }
    }

    public void IDLmouseDragged(JIDLObjectI jIDLObjectI, MouseEvent mouseEvent) {
        this.postIDLEvent(mouseEvent, null);
    }

    public void IDLmouseMoved(JIDLObjectI jIDLObjectI, MouseEvent mouseEvent) {
        this.postIDLEvent(mouseEvent, null);
    }

    public void addIDLOutputListener(JIDLOutputListener jIDLOutputListener) {
        if (this.m_interface != null && jIDLOutputListener != null) {
            this.m_interface.addIDLOutputListener(jIDLOutputListener);
        }
    }

    public void removeIDLOutputListener(JIDLOutputListener jIDLOutputListener) {
        if (this.m_interface != null && jIDLOutputListener != null) {
            this.m_interface.removeIDLOutputListener(jIDLOutputListener);
        }
    }

    public void addIDLNotifyListener(JIDLNotifyListener jIDLNotifyListener) {
        if (this.m_interface != null && jIDLNotifyListener != null) {
            this.m_interface.addIDLNotifyListener(jIDLNotifyListener);
        }
    }

    public void removeIDLNotifyListener(JIDLNotifyListener jIDLNotifyListener) {
        if (this.m_interface != null && jIDLNotifyListener != null) {
            this.m_interface.removeIDLNotifyListener(jIDLNotifyListener);
        }
    }

    public int mapIDLCursorToJavaCursor(String string) {
        if (string.equals("ARROW") || string.equals("UP_ARROW")) {
            return 0;
        }
        if (string.equals("IBEAM") || string.equals("ICON")) {
            return 2;
        }
        if (string.equals("CROSSHAIR") || string.equals("ORIGINAL")) {
            return 1;
        }
        if (string.equals("HOURGLASS")) {
            return 3;
        }
        if (string.equals("MOVE")) {
            return 13;
        }
        if (string.equals("SIZE_NW")) {
            return 6;
        }
        if (string.equals("SIZE_SE")) {
            return 5;
        }
        if (string.equals("SIZE_NE")) {
            return 7;
        }
        if (string.equals("SIZE_SW")) {
            return 4;
        }
        if (string.equals("SIZE_EW")) {
            return 11;
        }
        if (string.equals("SIZE_NS")) {
            return 8;
        }
        return 0;
    }

    public void setCursor(String string) {
        int n = this.mapIDLCursorToJavaCursor(string);
        super.setCursor(Cursor.getPredefinedCursor(n));
    }

    public String toString() {
        if (this.isObjectCreated()) {
            return "" + this.getClass().getName() + "[class=" + this.m_sClass + ", cookie=" + this.getCookie() + ", process=" + this.getProcessName() + ", HWND=" + this.m_hwnd + "]";
        }
        return "" + this.getClass().getName() + "[class=" + this.m_sClass + ", cookie=" + this.getCookie() + ", Object not created." + "]";
    }
}

