/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.core.internal.databinding.Util;
import org.eclipse.core.internal.databinding.beans.ListenerSupport;
import org.eclipse.core.runtime.Assert;

public class JavaBeanPropertyObservableMap
extends ObservableMap
implements IBeanObservable {
    private final Object object;
    private boolean updating = false;
    private PropertyDescriptor descriptor;
    private ListenerSupport listenerSupport;

    public JavaBeanPropertyObservableMap(Realm realm, Object object, PropertyDescriptor descriptor) {
        this(realm, object, descriptor, true);
    }

    public JavaBeanPropertyObservableMap(Realm realm, Object object, PropertyDescriptor descriptor, boolean attachListeners) {
        super(realm, new HashMap());
        this.object = object;
        this.descriptor = descriptor;
        if (attachListeners) {
            PropertyChangeListener listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (!JavaBeanPropertyObservableMap.this.updating) {
                        JavaBeanPropertyObservableMap.this.getRealm().exec(new Runnable(this, event){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ PropertyChangeEvent val$event;
                            {
                                this.this$1 = var1_1;
                                this.val$event = propertyChangeEvent;
                            }

                            public void run() {
                                Map oldValue = JavaBeanPropertyObservableMap.access$1(1.access$0(this.this$1));
                                Map newValue = (Map)this.val$event.getNewValue();
                                JavaBeanPropertyObservableMap.access$2(1.access$0(this.this$1), new HashMap<K, V>(newValue));
                                JavaBeanPropertyObservableMap.access$3(1.access$0(this.this$1), Diffs.computeMapDiff((Map)oldValue, (Map)newValue));
                            }
                        });
                    }
                }

                static /* synthetic */ JavaBeanPropertyObservableMap access$0(1 var0) {
                    return var0.JavaBeanPropertyObservableMap.this;
                }
            };
            this.listenerSupport = new ListenerSupport(listener, descriptor.getName());
            this.listenerSupport.hookListener(this.object);
        }
        this.wrappedMap.putAll(this.getMap());
    }

    private Object primGetMap() {
        try {
            Method readMethod = this.descriptor.getReadMethod();
            if (!readMethod.isAccessible()) {
                readMethod.setAccessible(true);
            }
            return readMethod.invoke(this.object, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        Assert.isTrue((boolean)false, (String)"Could not read collection values");
        return null;
    }

    private void primSetMap(Object newValue) {
        Exception ex = null;
        try {
            Method writeMethod = this.descriptor.getWriteMethod();
            if (!writeMethod.isAccessible()) {
                writeMethod.setAccessible(true);
            }
            writeMethod.invoke(this.object, newValue);
            return;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        throw new BindingException("Could not write collection values", (Throwable)ex);
    }

    private Map getMap() {
        HashMap result = (HashMap)this.primGetMap();
        if (result == null) {
            result = new HashMap();
        }
        return result;
    }

    private void setMap() {
        this.primSetMap(new HashMap(this.wrappedMap));
    }

    public Object put(Object key, Object value) {
        this.checkRealm();
        this.updating = true;
        try {
            Object result = this.wrappedMap.put(key, value);
            if (!Util.equals((Object)result, (Object)value)) {
                this.setMap();
                if (result == null) {
                    this.fireMapChange(Diffs.createMapDiffSingleAdd((Object)key, (Object)value));
                } else {
                    this.fireMapChange(Diffs.createMapDiffSingleChange((Object)key, (Object)result, (Object)value));
                }
            }
            Object object = result;
            return object;
        }
        finally {
            this.updating = false;
        }
    }

    public void putAll(Map map) {
        this.checkRealm();
        this.updating = true;
        try {
            HashSet addedKeys = new HashSet(map.size());
            HashMap changes = new HashMap(map.size());
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Object newValue;
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                Object oldValue = this.wrappedMap.put(key, newValue = entry.getValue());
                if (oldValue == null) {
                    addedKeys.add(key);
                    continue;
                }
                if (Util.equals(oldValue, newValue)) continue;
                changes.put(key, oldValue);
            }
            if (!addedKeys.isEmpty() || !changes.isEmpty()) {
                this.setMap();
                this.fireMapChange(Diffs.createMapDiff(addedKeys, (Set)Collections.EMPTY_SET, changes.keySet(), changes, (Map)this.wrappedMap));
            }
        }
        finally {
            this.updating = false;
        }
    }

    public Object remove(Object key) {
        this.checkRealm();
        this.updating = true;
        try {
            Object result = this.wrappedMap.remove(key);
            if (result != null) {
                this.setMap();
                this.fireMapChange(Diffs.createMapDiffSingleRemove((Object)key, result));
            }
            Object v = result;
            return v;
        }
        finally {
            this.updating = false;
        }
    }

    public void clear() {
        this.checkRealm();
        if (this.wrappedMap.isEmpty()) {
            return;
        }
        this.updating = true;
        try {
            Map oldMap = this.wrappedMap;
            this.wrappedMap = new HashMap();
            this.setMap();
            this.fireMapChange(Diffs.computeMapDiff((Map)oldMap, (Map)Collections.EMPTY_MAP));
        }
        finally {
            this.updating = false;
        }
    }

    public Object getObserved() {
        return this.object;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.descriptor;
    }

    public synchronized void dispose() {
        if (this.listenerSupport != null) {
            this.listenerSupport.dispose();
            this.listenerSupport = null;
        }
        super.dispose();
    }

    static /* synthetic */ Map access$1(JavaBeanPropertyObservableMap javaBeanPropertyObservableMap) {
        return javaBeanPropertyObservableMap.wrappedMap;
    }

    static /* synthetic */ void access$2(JavaBeanPropertyObservableMap javaBeanPropertyObservableMap, Map map) {
        javaBeanPropertyObservableMap.wrappedMap = map;
    }

    static /* synthetic */ void access$3(JavaBeanPropertyObservableMap javaBeanPropertyObservableMap, MapDiff mapDiff) {
        javaBeanPropertyObservableMap.fireMapChange(mapDiff);
    }
}

