/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.Converters;
import sun.nio.cs.HistoricallyNamedCharset;

public abstract class StreamEncoder
extends Writer {
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 8192;
    private volatile boolean isOpen = true;

    private StreamEncoder() {
    }

    private StreamEncoder(Object object) {
        super(object);
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Stream closed");
        }
    }

    abstract void implWrite(char[] var1, int var2, int var3) throws IOException;

    abstract void implFlushBuffer() throws IOException;

    abstract void implFlush() throws IOException;

    abstract void implClose() throws IOException;

    abstract String encodingName();

    public static StreamEncoder forOutputStreamWriter(OutputStream outputStream, Object object, String string) throws UnsupportedEncodingException {
        String string2 = string;
        if (string2 == null) {
            string2 = Converters.getDefaultEncodingName();
        }
        if (!Converters.isCached(1, string2)) {
            try {
                if (Charset.isSupported(string2)) {
                    return new CharsetSE(outputStream, object, Charset.forName(string2));
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
        }
        return new ConverterSE(outputStream, object, string2);
    }

    public static StreamEncoder forOutputStreamWriter(OutputStream outputStream, Object object, Charset charset) {
        return new CharsetSE(outputStream, object, charset);
    }

    public static StreamEncoder forOutputStreamWriter(OutputStream outputStream, Object object, CharsetEncoder charsetEncoder) {
        return new CharsetSE(outputStream, object, charsetEncoder);
    }

    public static StreamEncoder forEncoder(WritableByteChannel writableByteChannel, CharsetEncoder charsetEncoder, int n) {
        return new CharsetSE(writableByteChannel, charsetEncoder, n);
    }

    public String getEncoding() {
        if (this.isOpen()) {
            return this.encodingName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new IOException("Stream closed");
            }
            this.implFlushBuffer();
        }
    }

    public void write(int n) throws IOException {
        char[] cArray = new char[]{(char)n};
        this.write(cArray, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            this.implWrite(cArray, n, n2);
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        char[] cArray = new char[n2];
        string.getChars(n, n + n2, cArray, 0);
        this.write(cArray, 0, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.implFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen) {
                return;
            }
            this.implClose();
            this.isOpen = false;
        }
    }

    private boolean isOpen() {
        return this.isOpen;
    }

    private static class CharsetSE
    extends StreamEncoder {
        private Charset cs;
        private CharsetEncoder encoder;
        private ByteBuffer bb;
        private final OutputStream out;
        private WritableByteChannel ch;
        private boolean haveLeftoverChar = false;
        private char leftoverChar;
        private CharBuffer lcb = null;

        private CharsetSE(OutputStream outputStream, Object object, Charset charset) {
            this(outputStream, object, charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
        }

        private CharsetSE(OutputStream outputStream, Object object, CharsetEncoder charsetEncoder) {
            super(object);
            this.out = outputStream;
            this.ch = null;
            this.cs = charsetEncoder.charset();
            this.encoder = charsetEncoder;
            if (this.ch == null) {
                this.bb = ByteBuffer.allocate(8192);
            }
        }

        private CharsetSE(WritableByteChannel writableByteChannel, CharsetEncoder charsetEncoder, int n) {
            this.out = null;
            this.ch = writableByteChannel;
            this.cs = charsetEncoder.charset();
            this.encoder = charsetEncoder;
            this.bb = ByteBuffer.allocate(n < 0 ? 8192 : n);
        }

        private void writeBytes() throws IOException {
            int n;
            this.bb.flip();
            int n2 = this.bb.limit();
            int n3 = this.bb.position();
            assert (n3 <= n2);
            int n4 = n = n3 <= n2 ? n2 - n3 : 0;
            if (n > 0) {
                if (this.ch != null) {
                    if (this.ch.write(this.bb) != n) assert (false) : n;
                } else {
                    this.out.write(this.bb.array(), this.bb.arrayOffset() + n3, n);
                }
            }
            this.bb.clear();
        }

        private void flushLeftoverChar(CharBuffer charBuffer, boolean bl) throws IOException {
            if (!this.haveLeftoverChar && !bl) {
                return;
            }
            if (this.lcb == null) {
                this.lcb = CharBuffer.allocate(2);
            } else {
                this.lcb.clear();
            }
            if (this.haveLeftoverChar) {
                this.lcb.put(this.leftoverChar);
            }
            if (charBuffer != null && charBuffer.hasRemaining()) {
                this.lcb.put(charBuffer.get());
            }
            this.lcb.flip();
            while (this.lcb.hasRemaining() || bl) {
                CoderResult coderResult = this.encoder.encode(this.lcb, this.bb, bl);
                if (coderResult.isUnderflow()) {
                    if (!this.lcb.hasRemaining()) break;
                    throw new Error();
                }
                if (coderResult.isOverflow()) {
                    assert (this.bb.position() > 0);
                    this.writeBytes();
                    continue;
                }
                coderResult.throwException();
            }
            this.haveLeftoverChar = false;
        }

        void implWrite(char[] cArray, int n, int n2) throws IOException {
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
            if (this.haveLeftoverChar) {
                this.flushLeftoverChar(charBuffer, false);
            }
            while (charBuffer.hasRemaining()) {
                CoderResult coderResult = this.encoder.encode(charBuffer, this.bb, false);
                if (coderResult.isUnderflow()) {
                    assert (charBuffer.remaining() <= 1) : charBuffer.remaining();
                    if (charBuffer.remaining() != 1) break;
                    this.haveLeftoverChar = true;
                    this.leftoverChar = charBuffer.get();
                    break;
                }
                if (coderResult.isOverflow()) {
                    assert (this.bb.position() > 0);
                    this.writeBytes();
                    continue;
                }
                coderResult.throwException();
            }
        }

        void implFlushBuffer() throws IOException {
            if (this.bb.position() > 0) {
                this.writeBytes();
            }
        }

        void implFlush() throws IOException {
            this.implFlushBuffer();
            if (this.out != null) {
                this.out.flush();
            }
        }

        void implClose() throws IOException {
            CoderResult coderResult;
            this.flushLeftoverChar(null, true);
            while (!(coderResult = this.encoder.flush(this.bb)).isUnderflow()) {
                if (coderResult.isOverflow()) {
                    assert (this.bb.position() > 0);
                    this.writeBytes();
                    continue;
                }
                coderResult.throwException();
            }
            if (this.bb.position() > 0) {
                this.writeBytes();
            }
            if (this.ch != null) {
                this.ch.close();
            } else {
                this.out.close();
            }
        }

        String encodingName() {
            return this.cs instanceof HistoricallyNamedCharset ? ((HistoricallyNamedCharset)((Object)this.cs)).historicalName() : this.cs.name();
        }
    }

    private static class ConverterSE
    extends StreamEncoder {
        private final OutputStream out;
        private final CharToByteConverter ctb;
        private final byte[] bb;
        private int nextByte = 0;
        private int nBytes = 0;

        private ConverterSE(OutputStream outputStream, Object object, String string) throws UnsupportedEncodingException {
            super(object);
            this.out = outputStream;
            this.ctb = CharToByteConverter.getConverter(string);
            this.bb = new byte[8192];
            this.nBytes = 8192;
        }

        private ConverterSE(WritableByteChannel writableByteChannel, String string) throws UnsupportedEncodingException {
            this(Channels.newOutputStream(writableByteChannel), null, string);
            this.lock = this;
        }

        void implWrite(char[] cArray, int n, int n2) throws IOException {
            int n3 = n;
            int n4 = n + n2;
            boolean bl = false;
            while (n3 < n4) {
                boolean bl2 = false;
                try {
                    this.nextByte += this.ctb.convertAny(cArray, n3, n4, this.bb, this.nextByte, this.nBytes);
                    n3 = n4;
                }
                catch (ConversionBufferFullException conversionBufferFullException) {
                    int n5 = this.ctb.nextCharIndex();
                    if (n5 == n3 && bl) {
                        throw new CharConversionException("Output buffer too small");
                    }
                    n3 = n5;
                    bl2 = true;
                    this.nextByte = this.ctb.nextByteIndex();
                }
                if (this.nextByte < this.nBytes && !bl2) continue;
                this.out.write(this.bb, 0, this.nextByte);
                this.nextByte = 0;
                bl = true;
            }
        }

        void implFlushBuffer() throws IOException {
            if (this.nextByte > 0) {
                this.out.write(this.bb, 0, this.nextByte);
                this.nextByte = 0;
            }
        }

        void implFlush() throws IOException {
            this.implFlushBuffer();
            this.out.flush();
        }

        void implClose() throws IOException {
            while (true) {
                try {
                    this.nextByte += this.ctb.flushAny(this.bb, this.nextByte, this.nBytes);
                }
                catch (ConversionBufferFullException conversionBufferFullException) {
                    this.nextByte = this.ctb.nextByteIndex();
                }
                if (this.nextByte == 0) break;
                if (this.nextByte <= 0) continue;
                this.out.write(this.bb, 0, this.nextByte);
                this.nextByte = 0;
            }
            this.out.close();
        }

        String encodingName() {
            return this.ctb.getCharacterEncoding();
        }
    }
}

