/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapCharBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.StringCharBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CharBuffer
extends Buffer
implements Comparable<CharBuffer>,
Appendable,
CharSequence,
Readable {
    final char[] hb;
    final int offset;
    boolean isReadOnly;

    CharBuffer(int n, int n2, int n3, int n4, char[] cArray, int n5) {
        super(n, n2, n3, n4);
        this.hb = cArray;
        this.offset = n5;
    }

    CharBuffer(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null, 0);
    }

    public static CharBuffer allocate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapCharBuffer(n, n);
    }

    public static CharBuffer wrap(char[] cArray, int n, int n2) {
        try {
            return new HeapCharBuffer(cArray, n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static CharBuffer wrap(char[] cArray) {
        return CharBuffer.wrap(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(CharBuffer charBuffer) throws IOException {
        int n = charBuffer.remaining();
        int n2 = this.remaining();
        if (n2 == 0) {
            return -1;
        }
        int n3 = Math.min(n2, n);
        int n4 = this.limit();
        if (n < n2) {
            this.limit(this.position() + n3);
        }
        try {
            if (n3 > 0) {
                charBuffer.put(this);
            }
        }
        finally {
            this.limit(n4);
        }
        return n3;
    }

    public static CharBuffer wrap(CharSequence charSequence, int n, int n2) {
        try {
            return new StringCharBuffer(charSequence, n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static CharBuffer wrap(CharSequence charSequence) {
        return CharBuffer.wrap(charSequence, 0, charSequence.length());
    }

    public abstract CharBuffer slice();

    public abstract CharBuffer duplicate();

    public abstract CharBuffer asReadOnlyBuffer();

    public abstract char get();

    public abstract CharBuffer put(char var1);

    public abstract char get(int var1);

    public abstract CharBuffer put(int var1, char var2);

    public CharBuffer get(char[] cArray, int n, int n2) {
        CharBuffer.checkBounds(n, n2, cArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            cArray[i] = this.get();
        }
        return this;
    }

    public CharBuffer get(char[] cArray) {
        return this.get(cArray, 0, cArray.length);
    }

    public CharBuffer put(CharBuffer charBuffer) {
        if (charBuffer == this) {
            throw new IllegalArgumentException();
        }
        int n = charBuffer.remaining();
        if (n > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < n; ++i) {
            this.put(charBuffer.get());
        }
        return this;
    }

    public CharBuffer put(char[] cArray, int n, int n2) {
        CharBuffer.checkBounds(n, n2, cArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.put(cArray[i]);
        }
        return this;
    }

    public final CharBuffer put(char[] cArray) {
        return this.put(cArray, 0, cArray.length);
    }

    public CharBuffer put(String string, int n, int n2) {
        CharBuffer.checkBounds(n, n2 - n, string.length());
        for (int i = n; i < n2; ++i) {
            this.put(string.charAt(i));
        }
        return this;
    }

    public final CharBuffer put(String string) {
        return this.put(string, 0, string.length());
    }

    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final char[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public abstract CharBuffer compact();

    public abstract boolean isDirect();

    public int hashCode() {
        int n = 1;
        int n2 = this.position();
        for (int i = this.limit() - 1; i >= n2; --i) {
            n = 31 * n + this.get(i);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CharBuffer)) {
            return false;
        }
        CharBuffer charBuffer = (CharBuffer)object;
        if (this.remaining() != charBuffer.remaining()) {
            return false;
        }
        int n = this.position();
        int n2 = this.limit() - 1;
        int n3 = charBuffer.limit() - 1;
        while (n2 >= n) {
            char c;
            char c2 = this.get(n2);
            if (c2 != (c = charBuffer.get(n3)) && (c2 == c2 || c == c)) {
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    @Override
    public int compareTo(CharBuffer charBuffer) {
        int n = this.position() + Math.min(this.remaining(), charBuffer.remaining());
        int n2 = this.position();
        int n3 = charBuffer.position();
        while (n2 < n) {
            char c;
            char c2 = this.get(n2);
            if (c2 != (c = charBuffer.get(n3)) && (c2 == c2 || c == c)) {
                if (c2 < c) {
                    return -1;
                }
                return 1;
            }
            ++n2;
            ++n3;
        }
        return this.remaining() - charBuffer.remaining();
    }

    @Override
    public String toString() {
        return this.toString(this.position(), this.limit());
    }

    abstract String toString(int var1, int var2);

    @Override
    public final int length() {
        return this.remaining();
    }

    @Override
    public final char charAt(int n) {
        return this.get(this.position() + this.checkIndex(n, 1));
    }

    @Override
    public abstract CharSequence subSequence(int var1, int var2);

    @Override
    public CharBuffer append(CharSequence charSequence) {
        if (charSequence == null) {
            return this.put("null");
        }
        return this.put(((Object)charSequence).toString());
    }

    @Override
    public CharBuffer append(CharSequence charSequence, int n, int n2) {
        CharSequence charSequence2 = charSequence == null ? "null" : charSequence;
        return this.put(((Object)charSequence2.subSequence(n, n2)).toString());
    }

    @Override
    public CharBuffer append(char c) {
        return this.put(c);
    }

    public abstract ByteOrder order();
}

