/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import sun.awt.windows.ThemeReader;
import sun.security.action.GetPropertyAction;
import sun.swing.CachedPainter;

class XPStyle {
    private static XPStyle xp;
    private SkinPainter skinPainter = new SkinPainter();
    private static Boolean themeActive;
    private HashMap<String, Skin> skinMap;
    private HashMap<String, Border> borderMap;
    private HashMap<String, Color> colorMap;
    private boolean flatMenus = XPStyle.getSysBoolean("flatmenus");

    static synchronized void invalidateStyle() {
        xp = null;
        themeActive = null;
    }

    static synchronized XPStyle getXP() {
        if (themeActive == null) {
            GetPropertyAction getPropertyAction;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            themeActive = (Boolean)toolkit.getDesktopProperty("win.xpstyle.themeActive");
            if (themeActive == null) {
                themeActive = Boolean.FALSE;
            }
            if (themeActive.booleanValue() && AccessController.doPrivileged(getPropertyAction = new GetPropertyAction("swing.noxp")) == null && ThemeReader.isThemed() && !(UIManager.getLookAndFeel() instanceof WindowsClassicLookAndFeel)) {
                xp = new XPStyle();
            }
        }
        return xp;
    }

    private static String makeKey(Component component, String string, String string2, String string3) {
        String string4;
        String string5 = string;
        if (component instanceof JComponent && (string4 = (String)((JComponent)component).getClientProperty("XPStyle.subAppName")) != null) {
            string5 = string4 + "::" + string5;
        }
        if (string2 != null) {
            string5 = string5 + "(" + string2 + ")";
        }
        if (string3 != null) {
            string5 = string5 + "." + string3;
        }
        return string5;
    }

    String getString(Component component, String string, String string2, String string3) {
        return XPStyle.getEnumName(component, string, string2, string3);
    }

    private static String getEnumName(Component component, String string, String string2, String string3) {
        String string4 = XPStyle.makeKey(component, string, string2, string3);
        Part part = Part.getPart(XPStyle.getWidgetAndPart(string4));
        int n = Prop.getPropValue(string4);
        int n2 = ThemeReader.getEnum(part.getWidget(), part.value, State.getStateValue(string4), n);
        if (n2 == -1) {
            return null;
        }
        return Enum.getEnum(n, n2).enumName;
    }

    int getInt(Component component, String string, String string2, String string3, int n) {
        String string4 = XPStyle.makeKey(component, string, string2, string3);
        Part part = Part.getPart(XPStyle.getWidgetAndPart(string4));
        int n2 = Prop.getPropValue(string4);
        return ThemeReader.getInt(part.getWidget(), part.value, State.getStateValue(string4), n2);
    }

    Dimension getDimension(Component component, String string, String string2, String string3) {
        String string4 = XPStyle.makeKey(component, string, string2, string3);
        Part part = Part.getPart(XPStyle.getWidgetAndPart(string4));
        int n = Prop.getPropValue(string4);
        return ThemeReader.getPosition(part.getWidget(), part.value, State.getStateValue(string4), n);
    }

    Point getPoint(Component component, String string, String string2, String string3) {
        String string4 = XPStyle.makeKey(component, string, string2, string3);
        Part part = Part.getPart(XPStyle.getWidgetAndPart(string4));
        int n = Prop.getPropValue(string4);
        Dimension dimension = ThemeReader.getPosition(part.getWidget(), part.value, State.getStateValue(string4), n);
        if (dimension != null) {
            return new Point(dimension.width, dimension.height);
        }
        return null;
    }

    Insets getMargin(Component component, String string, String string2, String string3) {
        String string4 = XPStyle.makeKey(component, string, string2, string3);
        Part part = Part.getPart(XPStyle.getWidgetAndPart(string4));
        int n = Prop.getPropValue(string4);
        return ThemeReader.getThemeMargins(part.getWidget(), part.value, State.getStateValue(string4), n);
    }

    synchronized Color getColor(Component component, String string, String string2, String string3, Color color) {
        String string4 = XPStyle.makeKey(component, string, string2, string3);
        Color color2 = this.colorMap.get(string4);
        if (color2 == null) {
            Part part = Part.getPart(XPStyle.getWidgetAndPart(string4));
            int n = Prop.getPropValue(string4);
            color2 = ThemeReader.getColor(part.getWidget(), part.value, State.getStateValue(string4), n);
            if (color2 != null) {
                color2 = new ColorUIResource(color2);
                this.colorMap.put(string4, color2);
            }
        }
        return color2 != null ? color2 : color;
    }

    synchronized Border getBorder(Component component, String string) {
        if (string == "menu") {
            if (this.flatMenus) {
                return new XPFillBorder(UIManager.getColor("InternalFrame.borderShadow"), 1);
            }
            return null;
        }
        String string2 = XPStyle.makeKey(component, string, null, null);
        Border border = this.borderMap.get(string2);
        if (border == null) {
            Insets insets;
            String string3 = XPStyle.getEnumName(component, string, null, "bgtype");
            if ("borderfill".equalsIgnoreCase(string3)) {
                int n = this.getInt(component, string, null, "bordersize", 1);
                Color color = this.getColor(component, string, null, "bordercolor", Color.black);
                border = new XPFillBorder(color, n);
            } else if ("imagefile".equalsIgnoreCase(string3) && (insets = this.getMargin(component, string, null, "sizingmargins")) != null) {
                border = this.getBoolean(component, string, null, "borderonly") ? new XPImageBorder(component, string) : (string == "toolbar.button" ? new XPEmptyBorder(new Insets(3, 3, 3, 3)) : new XPEmptyBorder(insets));
            }
            if (border != null) {
                this.borderMap.put(string, border);
            }
        }
        return border;
    }

    synchronized Skin getSkin(Component component, String string) {
        String string2 = XPStyle.makeKey(component, string, null, null);
        Skin skin = this.skinMap.get(string2);
        if (skin == null) {
            skin = new Skin(string2);
            this.skinMap.put(string2, skin);
        }
        return skin;
    }

    private XPStyle() {
        this.skinMap = new HashMap();
        this.colorMap = new HashMap();
        this.borderMap = new HashMap();
    }

    private boolean getBoolean(Component component, String string, String string2, String string3) {
        String string4 = XPStyle.makeKey(component, string, string2, string3);
        Part part = Part.getPart(XPStyle.getWidgetAndPart(string4));
        int n = Prop.getPropValue(string4);
        return ThemeReader.getBoolean(part.getWidget(), part.value, State.getStateValue(string4), n);
    }

    private static String getWidgetAndPart(String string) {
        int n;
        int n2 = string.lastIndexOf(46);
        if (n2 > 0 && string.length() > n2 + 1 && (n2 = (string = string.substring(0, n2)).lastIndexOf(40)) > 0 && (n = string.indexOf(41, n2)) == string.length() - 1) {
            string = string.substring(0, n2);
        }
        return string;
    }

    private static Dimension getPartSize(String string, int n) {
        Part part = Part.getPart(string);
        return ThemeReader.getPartSize(part.getWidget(), part.value, n);
    }

    private static boolean getSysBoolean(String string) {
        Prop prop = Prop.getProp(string);
        return ThemeReader.getSysBoolean("window", prop.value);
    }

    static {
        themeActive = null;
        XPStyle.invalidateStyle();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Enum {
        BT_IMAGEFILE(Prop.TMT_BGTYPE, "imagefile", 0),
        BT_BORDERFILL(Prop.TMT_BGTYPE, "borderfill", 1),
        TST_SINGLE(Prop.TMT_TEXTSHADOWTYPE, "single", 1),
        TST_CONTINUOUS(Prop.TMT_TEXTSHADOWTYPE, "continuous", 2);

        private final Prop prop;
        private final String enumName;
        private final int value;

        private Enum(Prop prop, String string2, int n2) {
            this.prop = prop;
            this.enumName = string2;
            this.value = n2;
        }

        public String toString() {
            return (Object)((Object)this.prop) + "=" + this.enumName + "=" + this.value;
        }

        private static Enum getEnum(String string) {
            for (Enum enum_ : Enum.values()) {
                if (!enum_.enumName.equals(string)) continue;
                return enum_;
            }
            return null;
        }

        private static Enum getEnum(int n, int n2) {
            for (Enum enum_ : Enum.values()) {
                if (enum_.prop.value != n || enum_.value != n2) continue;
                return enum_;
            }
            return null;
        }
    }

    static class GlyphButton
    extends JButton {
        private Skin skin;
        private Image glyphImage;
        private boolean vertical;

        public GlyphButton(Component component, String string) {
            XPStyle xPStyle = XPStyle.getXP();
            this.skin = xPStyle.getSkin(component, string);
            this.setBorder(null);
            this.setContentAreaFilled(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void paintComponent(Graphics graphics) {
            int n = 0;
            if (!this.isEnabled()) {
                n = 3;
            } else if (this.getModel().isPressed()) {
                n = 2;
            } else if (this.getModel().isRollover()) {
                n = 1;
            }
            Dimension dimension = this.getSize();
            this.skin.paintSkin(graphics, 0, 0, dimension.width, dimension.height, n);
        }

        protected void paintBorder(Graphics graphics) {
        }

        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Part {
        BP_PUSHBUTTON("button.pushbutton", 1),
        BP_RADIOBUTTON("button.radiobutton", 2),
        BP_CHECKBOX("button.checkbox", 3),
        BP_GROUPBOX("button.groupbox", 4),
        CP_COMBOBOX("combobox", 0),
        CP_DROPDOWNBUTTON("combobox.dropdownbutton", 1),
        EP_EDIT("edit", 0),
        EP_EDITTEXT("edit.edittext", 1),
        HP_HEADERITEM("header.headeritem", 1),
        LBP_LISTBOX("listbox", 0),
        LVP_LISTVIEW("listview", 0),
        MP_MENUITEM("menu.menuitem", 1),
        MP_MENUDROPDOWN("menu.menudropdown", 2),
        PP_PROGRESS("progress", 0),
        PP_BAR("progress.bar", 1),
        PP_BARVERT("progress.barvert", 2),
        PP_CHUNK("progress.chunk", 3),
        PP_CHUNKVERT("progress.chunkvert", 4),
        RP_GRIPPER("rebar.gripper", 1),
        RP_GRIPPERVERT("rebar.grippervert", 2),
        SBP_ARROWBTN("scrollbar.arrowbtn", 1),
        SBP_THUMBBTNHORZ("scrollbar.thumbbtnhorz", 2),
        SBP_THUMBBTNVERT("scrollbar.thumbbtnvert", 3),
        SBP_LOWERTRACKHORZ("scrollbar.lowertrackhorz", 4),
        SBP_LOWERTRACKVERT("scrollbar.lowertrackvert", 5),
        SBP_GRIPPERHORZ("scrollbar.gripperhorz", 8),
        SBP_GRIPPERVERT("scrollbar.grippervert", 9),
        SPNP_SPINUP("spin.up", 1),
        SPNP_SPINDOWN("spin.down", 2),
        TABP_TABITEM("tab.tabitem", 1),
        TABP_TABITEMLEFTEDGE("tab.tabitemleftedge", 2),
        TABP_TABITEMRIGHTEDGE("tab.tabitemrightedge", 3),
        TABP_PANE("tab.pane", 9),
        TP_TOOLBAR("toolbar", 0),
        TP_PLACESBAR("placesbar::toolbar", 0),
        TP_BUTTON("toolbar.button", 1),
        TP_PLACESBARBUTTON("placesbar::toolbar.button", 1),
        TP_SEPARATOR("toolbar.separator", 5),
        TP_SEPARATORVERT("toolbar.separatorvert", 6),
        TKP_TRACK("trackbar.track", 1),
        TKP_TRACKVERT("trackbar.trackvert", 2),
        TKP_THUMB("trackbar.thumb", 3),
        TKP_THUMBBOTTOM("trackbar.thumbbottom", 4),
        TKP_THUMBTOP("trackbar.thumbtop", 5),
        TKP_THUMBVERT("trackbar.thumbvert", 6),
        TKP_THUMBLEFT("trackbar.thumbleft", 7),
        TKP_THUMBRIGHT("trackbar.thumbright", 8),
        TKP_TICS("trackbar.tics", 9),
        TKP_TICSVERT("trackbar.ticsvert", 10),
        TVP_TREEVIEW("treeview", 0),
        TVP_GLYPH("treeview.glyph", 2),
        WP_WINDOW("window", 0),
        WP_CAPTION("window.caption", 1),
        WP_MINCAPTION("window.mincaption", 3),
        WP_MAXCAPTION("window.maxcaption", 5),
        WP_FRAMELEFT("window.frameleft", 7),
        WP_FRAMERIGHT("window.frameright", 8),
        WP_FRAMEBOTTOM("window.framebottom", 9),
        WP_MINBUTTON("window.minbutton", 15),
        WP_MAXBUTTON("window.maxbutton", 17),
        WP_CLOSEBUTTON("window.closebutton", 18),
        WP_RESTOREBUTTON("window.restorebutton", 21);

        private final int value;
        private final String name;

        private Part(String string2, int n2) {
            this.value = n2;
            this.name = string2;
        }

        public String getWidget() {
            int n = this.name.indexOf(".");
            return n > 0 ? this.name.substring(0, n) : this.name;
        }

        public String toString() {
            return this.name + "=" + this.value;
        }

        private static Part getPart(String string) {
            for (Part part : Part.values()) {
                if (!part.name.equals(string)) continue;
                return part;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Prop {
        TMT_COLOR("color", Color.class, 204),
        TMT_SIZE("size", Dimension.class, 207),
        TMT_FLATMENUS("flatmenus", Boolean.class, 1001),
        TMT_BORDERONLY("borderonly", Boolean.class, 2203),
        TMT_BORDERSIZE("bordersize", Integer.class, 2403),
        TMT_PROGRESSCHUNKSIZE("progresschunksize", Integer.class, 2411),
        TMT_PROGRESSSPACESIZE("progressspacesize", Integer.class, 2412),
        TMT_TEXTSHADOWOFFSET("textshadowoffset", Point.class, 3402),
        TMT_NORMALSIZE("normalsize", Dimension.class, 3409),
        TMT_SIZINGMARGINS("sizingmargins", Insets.class, 3601),
        TMT_CONTENTMARGINS("contentmargins", Insets.class, 3602),
        TMT_CAPTIONMARGINS("captionmargins", Insets.class, 3603),
        TMT_BORDERCOLOR("bordercolor", Color.class, 3801),
        TMT_FILLCOLOR("fillcolor", Color.class, 3802),
        TMT_TEXTCOLOR("textcolor", Color.class, 3803),
        TMT_TEXTSHADOWCOLOR("textshadowcolor", Color.class, 3818),
        TMT_BGTYPE("bgtype", Integer.class, 4001),
        TMT_TEXTSHADOWTYPE("textshadowtype", Integer.class, 4010);

        private final String propName;
        private final Class type;
        private final int value;

        private Prop(String string2, Class clazz, int n2) {
            this.propName = string2;
            this.type = clazz;
            this.value = n2;
        }

        public String toString() {
            return this.propName + "[" + this.type.getName() + "] = " + this.value;
        }

        private static Prop getProp(String string) {
            for (Prop prop : Prop.values()) {
                if (!prop.propName.equals(string)) continue;
                return prop;
            }
            return null;
        }

        private static int getPropValue(String string) {
            String string2 = string;
            int n = string.lastIndexOf(46);
            if (n > 0 && string.length() > n + 1) {
                string2 = string.substring(n + 1);
            }
            return Prop.getProp((String)string2).value;
        }
    }

    class Skin {
        private String category;
        private Dimension size = null;

        private Skin(String string) {
            this.category = string;
        }

        Insets getContentMargin() {
            return XPStyle.this.getMargin(null, this.category, null, "sizingmargins");
        }

        private int getWidth(int n) {
            if (this.size == null) {
                this.size = XPStyle.getPartSize(this.category, n);
            }
            return this.size.width;
        }

        int getWidth() {
            return this.getWidth(1);
        }

        private int getHeight(int n) {
            if (this.size == null) {
                this.size = XPStyle.getPartSize(this.category, n);
            }
            return this.size.height;
        }

        int getHeight() {
            return this.getHeight(1);
        }

        void paintSkin(Graphics graphics, int n, int n2, int n3) {
            this.paintSkin(graphics, n, n2, this.getWidth(n3 + 1), this.getHeight(n3 + 1), n3);
        }

        void paintSkin(Graphics graphics, Rectangle rectangle, int n) {
            this.paintSkin(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n);
        }

        void paintSkin(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            XPStyle.this.skinPainter.paint(null, graphics, n, n2, n3, n4, this.category, n5);
        }

        void paintSkin(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
            String string = XPStyle.getEnumName(null, this.category, null, "bgtype");
            if (bl && "borderfill".equalsIgnoreCase(string)) {
                return;
            }
            XPStyle.this.skinPainter.paint(null, graphics, n, n2, n3, n4, this.category, n5);
        }
    }

    private static class SkinPainter
    extends CachedPainter {
        SkinPainter() {
            super(30);
            this.flush();
        }

        protected void paintToImage(Component component, Image image, Graphics graphics, int n, int n2, Object[] objectArray) {
            String string = (String)objectArray[0];
            int n3 = (Integer)objectArray[1] + 1;
            Part part = Part.getPart(string);
            WritableRaster writableRaster = ((BufferedImage)image).getRaster();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            ThemeReader.paintBackground(dataBufferInt.getData(), part.getWidget(), part.value, n3, 0, 0, n, n2, n);
        }

        protected Image createImage(Component component, int n, int n2, GraphicsConfiguration graphicsConfiguration, Object[] objectArray) {
            return new BufferedImage(n, n2, 2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        ETS_NORMAL(Part.EP_EDITTEXT, "normal", 1),
        ETS_DISABLED(Part.EP_EDITTEXT, "disabled", 4),
        ETS_READONLY(Part.EP_EDITTEXT, "readonly", 6),
        PBS_NORMAL(Part.BP_PUSHBUTTON, "normal", 1),
        PBS_HOT(Part.BP_PUSHBUTTON, "hot", 2),
        PBS_PRESSED(Part.BP_PUSHBUTTON, "pressed", 3),
        PBS_DISABLED(Part.BP_PUSHBUTTON, "disabled", 4),
        PBS_DEFAULTED(Part.BP_PUSHBUTTON, "defaulted", 5),
        RBS_UNCHECKEDNORMAL(Part.BP_RADIOBUTTON, "uncheckednormal", 1),
        RBS_UNCHECKEDHOT(Part.BP_RADIOBUTTON, "uncheckedhot", 2),
        RBS_UNCHECKEDPRESSED(Part.BP_RADIOBUTTON, "uncheckedpressed", 3),
        RBS_UNCHECKEDDISABLED(Part.BP_RADIOBUTTON, "uncheckeddisabled", 4),
        RBS_CHECKEDNORMAL(Part.BP_RADIOBUTTON, "checkednormal", 5),
        RBS_CHECKEDHOT(Part.BP_RADIOBUTTON, "checkedhot", 6),
        RBS_CHECKEDPRESSED(Part.BP_RADIOBUTTON, "checkedpressed", 7),
        RBS_CHECKEDDISABLED(Part.BP_RADIOBUTTON, "checkeddisabled", 8),
        CBS_UNCHECKEDNORMAL(Part.BP_CHECKBOX, "uncheckednormal", 1),
        CBS_UNCHECKEDHOT(Part.BP_CHECKBOX, "uncheckedhot", 2),
        CBS_UNCHECKEDPRESSED(Part.BP_CHECKBOX, "uncheckedpressed", 3),
        CBS_UNCHECKEDDISABLED(Part.BP_CHECKBOX, "uncheckeddisabled", 4),
        CBS_CHECKEDNORMAL(Part.BP_CHECKBOX, "checkednormal", 5),
        CBS_CHECKEDHOT(Part.BP_CHECKBOX, "checkedhot", 6),
        CBS_CHECKEDPRESSED(Part.BP_CHECKBOX, "checkedpressed", 7),
        CBS_CHECKEDDISABLED(Part.BP_CHECKBOX, "checkeddisabled", 8),
        CBS_MIXEDNORMAL(Part.BP_CHECKBOX, "mixednormal", 9),
        CBS_MIXEDHOT(Part.BP_CHECKBOX, "mixedhot", 10),
        CBS_MIXEDPRESSED(Part.BP_CHECKBOX, "mixedpressed", 11),
        CBS_MIXEDDISABLED(Part.BP_CHECKBOX, "mixeddisabled", 12),
        TS_NORMAL(Part.TP_BUTTON, "normal", 1),
        TS_HOT(Part.TP_BUTTON, "hot", 2),
        TS_PRESSED(Part.TP_BUTTON, "pressed", 3),
        TS_DISABLED(Part.TP_BUTTON, "disabled", 4),
        CS_ACTIVE(Part.WP_CAPTION, "active", 1),
        FS_ACTIVE(Part.WP_WINDOW, "active", 1);

        private final Part part;
        private final String stateName;
        private final int value;

        private State(Part part, String string2, int n2) {
            this.part = part;
            this.stateName = string2;
            this.value = n2;
        }

        public String toString() {
            return (Object)((Object)this.part) + "(" + this.stateName + "=" + this.value + ")";
        }

        private static int getStateValue(String string) {
            int n;
            String string2 = "";
            String string3 = null;
            int n2 = string.lastIndexOf(46);
            if (n2 > 0 && string.length() > n2 + 1 && (n2 = (string2 = string.substring(0, n2)).lastIndexOf(40)) > 0 && (n = string2.indexOf(41, n2)) == string2.length() - 1) {
                string3 = string2.substring(n2 + 1, n);
                string2 = string2.substring(0, n2);
            }
            return string3 != null ? State.getState((String)string2, string3).value : 0;
        }

        private static State getState(String string, String string2) {
            for (State state : State.values()) {
                if (!state.part.name.equals(string) || string2 != null && !state.stateName.equals(string2)) continue;
                return state;
            }
            return null;
        }
    }

    private class XPEmptyBorder
    extends EmptyBorder
    implements UIResource {
        XPEmptyBorder(Insets insets) {
            super(insets.top + 2, insets.left + 2, insets.bottom + 2, insets.right + 2);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, this.getBorderInsets());
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets = super.getBorderInsets(component, insets);
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                Insets insets3 = ((AbstractButton)component).getMargin();
                if (component.getParent() instanceof JToolBar && !(component instanceof JRadioButton) && !(component instanceof JCheckBox) && insets3 instanceof InsetsUIResource) {
                    insets.top -= 2;
                    insets.left -= 2;
                    insets.bottom -= 2;
                    insets.right -= 2;
                } else {
                    insets2 = insets3;
                }
            } else if (component instanceof JToolBar) {
                insets2 = ((JToolBar)component).getMargin();
            } else if (component instanceof JTextComponent) {
                insets2 = ((JTextComponent)component).getMargin();
            }
            if (insets2 != null) {
                insets.top = insets2.top + 2;
                insets.left = insets2.left + 2;
                insets.bottom = insets2.bottom + 2;
                insets.right = insets2.right + 2;
            }
            return insets;
        }
    }

    private class XPFillBorder
    extends LineBorder
    implements UIResource {
        XPFillBorder(Color color, int n) {
            super(color, n);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            } else if (component instanceof JToolBar) {
                insets2 = ((JToolBar)component).getMargin();
            } else if (component instanceof JTextComponent) {
                insets2 = ((JTextComponent)component).getMargin();
            }
            insets.top = (insets2 != null ? insets2.top : 0) + this.thickness;
            insets.left = (insets2 != null ? insets2.left : 0) + this.thickness;
            insets.bottom = (insets2 != null ? insets2.bottom : 0) + this.thickness;
            insets.right = (insets2 != null ? insets2.right : 0) + this.thickness;
            return insets;
        }
    }

    private class XPImageBorder
    extends AbstractBorder
    implements UIResource {
        Skin skin;

        XPImageBorder(Component component, String string) {
            this.skin = XPStyle.this.getSkin(component, string);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            this.skin.paintSkin(graphics, n, n2, n3, n4, 0);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            Insets insets3 = this.skin.getContentMargin();
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            } else if (component instanceof JToolBar) {
                insets2 = ((JToolBar)component).getMargin();
            } else if (component instanceof JTextComponent) {
                insets2 = ((JTextComponent)component).getMargin();
            }
            insets.top = (insets2 != null ? insets2.top : 0) + insets3.top;
            insets.left = (insets2 != null ? insets2.left : 0) + insets3.left;
            insets.bottom = (insets2 != null ? insets2.bottom : 0) + insets3.bottom;
            insets.right = (insets2 != null ? insets2.right : 0) + insets3.right;
            return insets;
        }
    }
}

