/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.LazyModelPresentation;
import org.eclipse.debug.internal.ui.VariablesViewModelPresentation;
import org.eclipse.debug.internal.ui.actions.CollapseAllAction;
import org.eclipse.debug.internal.ui.actions.ConfigureColumnsAction;
import org.eclipse.debug.internal.ui.actions.variables.ChangeVariableValueAction;
import org.eclipse.debug.internal.ui.actions.variables.ShowTypesAction;
import org.eclipse.debug.internal.ui.actions.variables.ToggleDetailPaneAction;
import org.eclipse.debug.internal.ui.viewers.model.VirtualFindAction;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputRequestor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ViewerInputService;
import org.eclipse.debug.internal.ui.views.DebugModelPresentationContext;
import org.eclipse.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.debug.internal.ui.views.variables.AvailableLogicalStructuresAction;
import org.eclipse.debug.internal.ui.views.variables.SelectionDragAdapter;
import org.eclipse.debug.internal.ui.views.variables.ToggleLogicalStructureAction;
import org.eclipse.debug.internal.ui.views.variables.ToggleShowColumnsAction;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewMessages;
import org.eclipse.debug.internal.ui.views.variables.details.AvailableDetailPanesAction;
import org.eclipse.debug.internal.ui.views.variables.details.DetailPaneProxy;
import org.eclipse.debug.internal.ui.views.variables.details.IDetailPaneContainer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class VariablesView
extends AbstractDebugView
implements IDebugContextListener,
IPropertyChangeListener,
IDebugExceptionHandler,
IPerspectiveListener,
IModelChangedListener,
IViewerUpdateListener,
IDetailPaneContainer {
    private VariablesViewModelPresentation fModelPresentation;
    private SashForm fSashForm;
    private DetailPaneProxy fDetailPane;
    private boolean fTreeHasFocus = true;
    private ISelectionChangedListener fTreeSelectionChangedListener;
    private Listener fDetailPaneActivatedListener;
    private ViewerInputService fInputService;
    private IViewerInputRequestor fRequester = new IViewerInputRequestor(){

        public void viewerInputComplete(IViewerInputUpdate update) {
            if (!update.isCanceled()) {
                VariablesView.this.setViewerInput(update.getInputElement());
                VariablesView.this.showViewer();
                VariablesView.this.updateAction(VARIABLES_FIND_ELEMENT_ACTION);
                VariablesView.this.updateAction(FIND_ACTION);
            }
        }
    };
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{13, 6};
    private int[] fLastSashWeights;
    private boolean fToggledDetailOnce;
    private String fCurrentDetailPaneOrientation = "Variables.detail.orientation.hidden";
    private ToggleDetailPaneAction[] fToggleDetailPaneActions;
    private ConfigureColumnsAction fConfigureColumnsAction;
    protected String PREF_STATE_MEMENTO = "pref_state_memento.";
    public static final String LOGICAL_STRUCTURE_TYPE_PREFIX = "VAR_LS_";
    public static final String PRESENTATION_SHOW_LOGICAL_STRUCTURES = "PRESENTATION_SHOW_LOGICAL_STRUCTURES";
    protected static final String SASH_VIEW_PART = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".SASH_VIEW_PART";
    protected static final String SASH_DETAILS_PART = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".SASH_DETAILS_PART";
    protected static final String VARIABLES_FIND_ELEMENT_ACTION = String.valueOf(FIND_ACTION) + ".Variables";
    protected static final String VARIABLES_SELECT_ALL_ACTION = String.valueOf(SELECT_ALL_ACTION) + ".Variables";
    protected static final String VARIABLES_COPY_ACTION = String.valueOf(COPY_ACTION) + ".Variables";
    private Visitor fVisitor = new Visitor();
    private Job fTriggerDetailsJob = new UIJob("trigger details"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            VariablesView.this.refreshDetailPaneContents();
            return Status.OK_STATUS;
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void dispose() {
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).removeDebugContextListener(this);
        this.getSite().getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this);
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        TreeModelViewer viewer = this.getVariablesViewer();
        if (viewer != null) {
            viewer.removeModelChangedListener(this);
            viewer.removeViewerUpdateListener(this);
        }
        if (this.fDetailPane != null) {
            this.fDetailPane.dispose();
        }
        this.fInputService.dispose();
        super.dispose();
    }

    protected void setViewerInput(Object context) {
        Object current;
        if (context == null) {
            this.fDetailPane.display(null);
        }
        if ((current = this.getViewer().getInput()) == null && context == null) {
            return;
        }
        if (current != null && current.equals(context)) {
            return;
        }
        this.showViewer();
        this.getViewer().setInput(context);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (propertyName.equals("org.eclipse.debug.ui.changedDebugElement") || propertyName.equals("org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND") || propertyName.equals("org.eclipse.debug.ui.VariableTextFont")) {
            this.getViewer().refresh();
        }
    }

    public Viewer createViewer(Composite parent) {
        this.fTriggerDetailsJob.setSystem(true);
        this.fSashForm = new SashForm(parent, 0);
        this.fModelPresentation = new VariablesViewModelPresentation();
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        TreeModelViewer variablesViewer = this.createTreeViewer((Composite)this.fSashForm);
        this.fInputService = new ViewerInputService(variablesViewer, this.fRequester);
        this.fSashForm.setMaximizedControl(variablesViewer.getControl());
        this.fDetailPane = new DetailPaneProxy(this);
        this.fDetailPane.display(null);
        this.createOrientationActions(variablesViewer);
        IPreferenceStore prefStore = DebugUIPlugin.getDefault().getPreferenceStore();
        String orientation = prefStore.getString(this.getDetailPanePreferenceKey());
        int i = 0;
        while (i < this.fToggleDetailPaneActions.length) {
            this.fToggleDetailPaneActions[i].setChecked(this.fToggleDetailPaneActions[i].getOrientation().equals(orientation));
            ++i;
        }
        this.setDetailPaneOrientation(orientation);
        IMemento memento = this.getMemento();
        if (memento != null) {
            variablesViewer.initState(memento);
        }
        variablesViewer.addModelChangedListener(this);
        variablesViewer.addViewerUpdateListener(this);
        this.initDragAndDrop(variablesViewer);
        return variablesViewer;
    }

    protected void initDragAndDrop(TreeModelViewer viewer) {
        viewer.addDragSupport(1, new Transfer[]{LocalSelectionTransfer.getInstance()}, (DragSourceListener)new SelectionDragAdapter(viewer));
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        Integer sw;
        block14: {
            super.init(site, memento);
            this.PREF_STATE_MEMENTO = String.valueOf(this.PREF_STATE_MEMENTO) + site.getId();
            IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
            String string = store.getString(this.PREF_STATE_MEMENTO);
            if (string.length() > 0) {
                ByteArrayInputStream bin = new ByteArrayInputStream(string.getBytes());
                InputStreamReader reader = new InputStreamReader(bin);
                try {
                    try {
                        XMLMemento stateMemento = XMLMemento.createReadRoot((Reader)reader);
                        this.setMemento((IMemento)stateMemento);
                    }
                    catch (WorkbenchException workbenchException) {
                        try {
                            reader.close();
                            bin.close();
                        }
                        catch (IOException iOException) {}
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                        bin.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    reader.close();
                    bin.close();
                }
                catch (IOException iOException) {}
            }
        }
        IMemento mem = this.getMemento();
        this.setLastSashWeights(DEFAULT_SASH_WEIGHTS);
        if (mem != null && (sw = mem.getInteger(SASH_VIEW_PART)) != null) {
            int details;
            int view = sw;
            sw = mem.getInteger(SASH_DETAILS_PART);
            if (sw != null && view > -1 & (details = sw.intValue()) > -1) {
                this.setLastSashWeights(new int[]{view, details});
            }
        }
        site.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
    }

    public void partDeactivated(IWorkbenchPart part) {
        block12: {
            String id = part.getSite().getId();
            if (id.equals(this.getSite().getId())) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(bout);
                try {
                    try {
                        XMLMemento memento = XMLMemento.createWriteRoot((String)"VariablesViewMemento");
                        this.saveViewerState((IMemento)memento);
                        memento.save((Writer)writer);
                        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
                        String xmlString = bout.toString();
                        store.putValue(this.PREF_STATE_MEMENTO, xmlString);
                    }
                    catch (IOException iOException) {
                        try {
                            writer.close();
                            bout.close();
                        }
                        catch (IOException iOException2) {}
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                        bout.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    writer.close();
                    bout.close();
                }
                catch (IOException iOException) {}
            }
        }
        super.partDeactivated(part);
    }

    public void saveViewerState(IMemento memento) {
        if (this.fSashForm != null && !this.fSashForm.isDisposed()) {
            int[] weights = this.fSashForm.getWeights();
            memento.putInteger(SASH_VIEW_PART, weights[0]);
            memento.putInteger(SASH_DETAILS_PART, weights[1]);
        }
        this.getVariablesViewer().saveState(memento);
    }

    protected String getDetailPanePreferenceKey() {
        return "Variables.detail.orientation";
    }

    protected TreeModelViewer createTreeViewer(Composite parent) {
        int style = this.getViewerStyle();
        final TreeModelViewer variablesViewer = new TreeModelViewer(parent, style, new DebugModelPresentationContext(this.getPresentationContextId(), this.fModelPresentation));
        variablesViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                VariablesView.this.fTreeHasFocus = true;
                VariablesView.this.getSite().setSelectionProvider((ISelectionProvider)variablesViewer);
                VariablesView.this.setAction(SELECT_ALL_ACTION, VariablesView.this.getAction(VARIABLES_SELECT_ALL_ACTION));
                VariablesView.this.setAction(COPY_ACTION, VariablesView.this.getAction(VARIABLES_COPY_ACTION));
                VariablesView.this.setAction(FIND_ACTION, VariablesView.this.getAction(VARIABLES_FIND_ELEMENT_ACTION));
                VariablesView.this.getViewSite().getActionBars().updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                VariablesView.this.getSite().setSelectionProvider(null);
                VariablesView.this.setAction(SELECT_ALL_ACTION, null);
                VariablesView.this.setAction(COPY_ACTION, null);
                VariablesView.this.setAction(FIND_ACTION, null);
                VariablesView.this.getViewSite().getActionBars().updateActionBars();
            }
        });
        variablesViewer.getPresentationContext().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                IAction action;
                if ("PROPERTY_COLUMNS".equals(event.getProperty()) && (action = VariablesView.this.getAction("ShowTypeNames")) != null) {
                    action.setEnabled(event.getNewValue() == null);
                }
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)variablesViewer);
        variablesViewer.addPostSelectionChangedListener(this.getTreeSelectionChangedListener());
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).addDebugContextListener(this);
        return variablesViewer;
    }

    protected String getPresentationContextId() {
        return "org.eclipse.debug.ui.VariableView";
    }

    protected int getViewerStyle() {
        return 268501762;
    }

    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.variable_view_context";
    }

    public void setDetailPaneOrientation(String orientation) {
        if (orientation.equals(this.fCurrentDetailPaneOrientation)) {
            return;
        }
        if (orientation.equals("Variables.detail.orientation.hidden")) {
            this.hideDetailPane();
        } else {
            int vertOrHoriz = orientation.equals("Variables.detail.orientation.underneath") ? 512 : 256;
            this.fSashForm.setOrientation(vertOrHoriz);
            if ("Variables.detail.orientation.hidden".equals(this.fCurrentDetailPaneOrientation)) {
                this.showDetailPane();
            }
        }
        this.fCurrentDetailPaneOrientation = orientation;
        DebugUIPlugin.getDefault().getPreferenceStore().setValue(this.getDetailPanePreferenceKey(), orientation);
    }

    private void hideDetailPane() {
        if (this.fToggledDetailOnce) {
            this.setLastSashWeights(this.fSashForm.getWeights());
        }
        this.fSashForm.setMaximizedControl(this.getViewer().getControl());
    }

    private void showDetailPane() {
        this.fSashForm.setMaximizedControl(null);
        this.fSashForm.setWeights(this.getLastSashWeights());
        this.refreshDetailPaneContents();
        this.revealTreeSelection();
        this.fToggledDetailOnce = true;
    }

    protected void revealTreeSelection() {
        Object selected;
        ISelection selection;
        StructuredViewer viewer = (StructuredViewer)this.getViewer();
        if (viewer != null && (selection = viewer.getSelection()) instanceof IStructuredSelection && (selected = ((IStructuredSelection)selection).getFirstElement()) != null) {
            viewer.reveal(selected);
        }
    }

    protected int[] getLastSashWeights() {
        if (this.fLastSashWeights == null) {
            this.fLastSashWeights = DEFAULT_SASH_WEIGHTS;
        } else if (this.fLastSashWeights[0] < 0 || this.fLastSashWeights[1] < 0) {
            this.fLastSashWeights = DEFAULT_SASH_WEIGHTS;
        }
        return this.fLastSashWeights;
    }

    protected void setLastSashWeights(int[] weights) {
        this.fLastSashWeights = weights;
    }

    protected void createActions() {
        IHandlerService hs;
        Object action = new ShowTypesAction(this);
        this.setAction("ShowTypeNames", (IAction)action);
        action = new ToggleLogicalStructureAction(this);
        this.setAction("ToggleContentProviders", (IAction)action);
        action = new CollapseAllAction((TreeViewer)this.getViewer());
        this.setAction("CollapseAll", (IAction)action);
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((hs = (IHandlerService)iWorkbenchPartSite.getService((Class)clazz)) != null) {
            hs.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)new ActionHandler((IAction)action));
        }
        action = new ChangeVariableValueAction(this);
        action.setEnabled(false);
        this.setAction("ChangeVariableValue", (IAction)action);
        action = new VirtualFindAction(this.getVariablesViewer());
        this.setAction(VARIABLES_FIND_ELEMENT_ACTION, (IAction)action);
    }

    protected void createContextMenu(Control menuControl) {
        super.createContextMenu(menuControl);
        this.setAction(VARIABLES_COPY_ACTION, this.getAction(COPY_ACTION));
    }

    private void createOrientationActions(TreeModelViewer viewer) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fToggleDetailPaneActions = new ToggleDetailPaneAction[3];
        this.fToggleDetailPaneActions[0] = new ToggleDetailPaneAction(this, "Variables.detail.orientation.underneath", null);
        this.fToggleDetailPaneActions[1] = new ToggleDetailPaneAction(this, "Variables.detail.orientation.right", null);
        this.fToggleDetailPaneActions[2] = new ToggleDetailPaneAction(this, "Variables.detail.orientation.hidden", this.getToggleActionLabel());
        viewMenu.add((IContributionItem)new Separator());
        final MenuManager layoutSubMenu = new MenuManager(VariablesViewMessages.VariablesView_40);
        layoutSubMenu.setRemoveAllWhenShown(true);
        layoutSubMenu.add((IAction)this.fToggleDetailPaneActions[0]);
        layoutSubMenu.add((IAction)this.fToggleDetailPaneActions[1]);
        layoutSubMenu.add((IAction)this.fToggleDetailPaneActions[2]);
        viewMenu.add((IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator());
        this.fConfigureColumnsAction = new ConfigureColumnsAction(viewer);
        this.setAction("ToggleColmns", (IAction)new ToggleShowColumnsAction(viewer));
        layoutSubMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                layoutSubMenu.add((IAction)VariablesView.this.fToggleDetailPaneActions[0]);
                layoutSubMenu.add((IAction)VariablesView.this.fToggleDetailPaneActions[1]);
                layoutSubMenu.add((IAction)VariablesView.this.fToggleDetailPaneActions[2]);
                IAction action = VariablesView.this.getAction("ToggleColmns");
                ((IUpdate)action).update();
                if (action.isEnabled()) {
                    layoutSubMenu.add(action);
                }
                VariablesView.this.fConfigureColumnsAction.update();
                if (VariablesView.this.fConfigureColumnsAction.isEnabled()) {
                    layoutSubMenu.add((IAction)VariablesView.this.fConfigureColumnsAction);
                }
            }
        });
    }

    protected String getToggleActionLabel() {
        return VariablesViewMessages.VariablesView_41;
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator(this.getClass().getName()));
        tbm.add((IContributionItem)new Separator("renderGroup"));
        tbm.add(this.getAction("ShowTypeNames"));
        tbm.add(this.getAction("ToggleContentProviders"));
        tbm.add(this.getAction("CollapseAll"));
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyVariableGroup"));
        menu.add((IContributionItem)new Separator("variableGroup"));
        menu.add(this.getAction(VARIABLES_FIND_ELEMENT_ACTION));
        menu.add(this.getAction("ChangeVariableValue"));
        menu.add((IContributionItem)new Separator());
        Action action = new AvailableLogicalStructuresAction(this);
        if (action.isEnabled()) {
            menu.add((IAction)action);
        }
        action = new AvailableDetailPanesAction(this);
        if (this.isDetailPaneVisible() && action.isEnabled()) {
            menu.add((IAction)action);
        }
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("emptyNavigationGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected ISelectionChangedListener getTreeSelectionChangedListener() {
        if (this.fTreeSelectionChangedListener == null) {
            this.fTreeSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelectionProvider().equals(VariablesView.this.getViewer())) {
                        VariablesView.this.clearStatusLine();
                        if (VariablesView.this.fSashForm.getMaximizedControl() == VariablesView.this.getViewer().getControl()) {
                            return;
                        }
                        VariablesView.this.refreshDetailPaneContents();
                        VariablesView.this.treeSelectionChanged(event);
                    }
                }
            };
        }
        return this.fTreeSelectionChangedListener;
    }

    protected void treeSelectionChanged(SelectionChangedEvent event) {
    }

    public String getCurrentPaneID() {
        return this.fDetailPane.getCurrentPaneID();
    }

    public IStructuredSelection getCurrentSelection() {
        if (this.getViewer() != null) {
            return (IStructuredSelection)this.getViewer().getSelection();
        }
        return null;
    }

    public Composite getParentComposite() {
        return this.fSashForm;
    }

    public IWorkbenchPartSite getWorkbenchPartSite() {
        return this.getSite();
    }

    public void refreshDetailPaneContents() {
        this.fDetailPane.display(this.getCurrentSelection());
    }

    public void paneChanged(String newPaneID) {
        if (this.fDetailPaneActivatedListener == null) {
            this.fDetailPaneActivatedListener = new Listener(){

                public void handleEvent(Event event) {
                    VariablesView.this.fTreeHasFocus = false;
                }
            };
        }
        this.fDetailPane.getCurrentControl().addListener(26, this.fDetailPaneActivatedListener);
    }

    protected IDebugModelPresentation getModelPresentation() {
        if (this.fModelPresentation == null) {
            this.fModelPresentation = new VariablesViewModelPresentation();
        }
        return this.fModelPresentation;
    }

    public Object getAdapter(Class required) {
        Object adapter;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.debug.ui.IDebugModelPresentation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this.getModelPresentation();
        }
        if (this.fDetailPane != null && (adapter = this.fDetailPane.getAdapter(required)) != null) {
            return adapter;
        }
        return super.getAdapter(required);
    }

    protected void updateAction(String actionId) {
        IAction action = this.getAction(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected boolean isDetailPaneVisible() {
        return !this.fToggleDetailPaneActions[2].isChecked();
    }

    protected Control getDefaultControl() {
        return this.fSashForm;
    }

    public void handleException(DebugException e) {
        this.showMessage(e.getMessage());
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            this.contextActivated(event.getContext());
        }
    }

    protected void contextActivated(ISelection selection) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            Object source = ((IStructuredSelection)selection).getFirstElement();
            this.fInputService.resolveViewerInput(source);
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        IAction action = this.getAction("Double_Click_ActionId");
        if (action != null && action.isEnabled()) {
            action.run();
        }
    }

    public IDebugModelPresentation getPresentation(String id) {
        if (this.getViewer() instanceof StructuredViewer) {
            IDebugModelPresentation lp = this.getModelPresentation();
            if (lp instanceof DelegatingModelPresentation) {
                return ((DelegatingModelPresentation)lp).getPresentation(id);
            }
            if (lp instanceof LazyModelPresentation && ((LazyModelPresentation)lp).getDebugModelIdentifier().equals(id)) {
                return lp;
            }
        }
        return null;
    }

    public boolean isMainViewerAvailable() {
        return this.isAvailable();
    }

    protected IPresentationContext getPresentationContext() {
        return this.getVariablesViewer().getPresentationContext();
    }

    public void setShowLogicalStructure(boolean flag) {
        this.getPresentationContext().setProperty(PRESENTATION_SHOW_LOGICAL_STRUCTURES, flag);
    }

    public boolean isShowLogicalStructure() {
        Boolean show = (Boolean)this.getPresentationContext().getProperty(PRESENTATION_SHOW_LOGICAL_STRUCTURES);
        return show != null && show != false;
    }

    protected void becomesHidden() {
        this.setViewerInput(null);
        super.becomesHidden();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        ISelection selection = DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).getActiveContext();
        this.contextActivated(selection);
    }

    protected TreeModelViewer getVariablesViewer() {
        return (TreeModelViewer)this.getViewer();
    }

    protected void clearStatusLine() {
        IStatusLineManager manager = this.getViewSite().getActionBars().getStatusLineManager();
        manager.setErrorMessage(null);
        manager.setMessage(null);
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        if (changeId.equals("reset")) {
            this.setLastSashWeights(DEFAULT_SASH_WEIGHTS);
            this.fSashForm.setWeights(DEFAULT_SASH_WEIGHTS);
        }
    }

    public void modelChanged(IModelDelta delta, IModelProxy proxy) {
        this.fVisitor.reset();
        delta.accept(this.fVisitor);
    }

    public void updateComplete(IViewerUpdate update) {
        IStatus status = update.getStatus();
        if (!update.isCanceled()) {
            if (status != null && status.getCode() != 0) {
                this.showMessage(status.getMessage());
            } else {
                this.showViewer();
            }
        }
    }

    public void updateStarted(IViewerUpdate update) {
    }

    public synchronized void viewerUpdatesBegin() {
        IWorkbenchSiteProgressService progressService;
        this.fTriggerDetailsJob.cancel();
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((progressService = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
            progressService.incrementBusy();
        }
    }

    public synchronized void viewerUpdatesComplete() {
        IWorkbenchSiteProgressService progressService;
        if (this.fVisitor.isTriggerDetails()) {
            this.fTriggerDetailsJob.schedule();
        }
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((progressService = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
            progressService.decrementBusy();
        }
    }

    public void setFocus() {
        boolean success = false;
        if (!this.fTreeHasFocus && this.fDetailPane != null) {
            success = this.fDetailPane.setFocus();
        }
        if (!success && this.getViewer() != null) {
            this.getViewer().getControl().setFocus();
        }
    }

    protected ToggleDetailPaneAction getToggleDetailPaneAction(String orientation) {
        int i = 0;
        while (i < this.fToggleDetailPaneActions.length) {
            if (this.fToggleDetailPaneActions[i].getOrientation().equals(orientation)) {
                return this.fToggleDetailPaneActions[i];
            }
            ++i;
        }
        return null;
    }

    class Visitor
    implements IModelDeltaVisitor {
        private boolean fTriggerDetails = false;

        Visitor() {
        }

        public boolean visit(IModelDelta delta, int depth) {
            if ((delta.getFlags() & 0x400) > 0) {
                this.fTriggerDetails = true;
                return false;
            }
            return true;
        }

        public void reset() {
            this.fTriggerDetails = false;
        }

        public boolean isTriggerDetails() {
            return this.fTriggerDetails;
        }
    }
}

