/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.debug.internal.ui.viewers.model.ChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.ChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.HasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.InternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.ModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerAdapterService;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.jface.viewers.ILazyTreePathContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeModelContentProvider
extends ModelContentProvider
implements ILazyTreePathContentProvider {
    protected static final String[] STATE_PROPERTIES = new String[]{"org.eclipse.jface.text", "org.eclipse.jface.image"};

    protected void refilterChildren(TreePath path) {
        int[] filteredChildren;
        if (this.getViewer() != null && (filteredChildren = this.getFilteredChildren(path)) != null) {
            int i = 0;
            while (i < filteredChildren.length) {
                this.doUpdateElement(path, filteredChildren[i]);
                ++i;
            }
        }
    }

    protected synchronized void doUpdateChildCount(TreePath path) {
        Object element = this.getElement(path);
        IElementContentProvider contentAdapter = ViewerAdapterService.getContentProvider(element);
        if (contentAdapter != null) {
            ChildrenCountUpdate request = new ChildrenCountUpdate(this, this.getTreeViewer().getInput(), path, element, contentAdapter, this.getPresentationContext());
            this.schedule(request);
        }
    }

    protected synchronized void doUpdateElement(TreePath parentPath, int modelIndex) {
        Object parent = this.getElement(parentPath);
        IElementContentProvider contentAdapter = ViewerAdapterService.getContentProvider(parent);
        if (contentAdapter != null) {
            ChildrenUpdate request = new ChildrenUpdate(this, this.getTreeViewer().getInput(), parentPath, parent, modelIndex, contentAdapter, this.getPresentationContext());
            this.schedule(request);
        }
    }

    protected synchronized void doUpdateHasChildren(TreePath path) {
        Object element = this.getElement(path);
        IElementContentProvider contentAdapter = ViewerAdapterService.getContentProvider(element);
        if (contentAdapter != null) {
            HasChildrenUpdate request = new HasChildrenUpdate(this, this.getTreeViewer().getInput(), path, element, contentAdapter, this.getPresentationContext());
            this.schedule(request);
        }
    }

    protected IPresentationContext getPresentationContext() {
        return ((TreeModelViewer)this.getViewer()).getPresentationContext();
    }

    protected TreeViewer getTreeViewer() {
        return (TreeViewer)this.getViewer();
    }

    protected void handleAdd(IModelDelta delta) {
        if (DEBUG_CONTENT_PROVIDER) {
            System.out.println("handleAdd(" + delta.getElement() + ")");
        }
        this.doUpdateChildCount(this.getViewerTreePath(delta.getParentDelta()));
    }

    protected void handleContent(IModelDelta delta) {
        if (delta.getParentDelta() == null && delta.getChildCount() == 0 && !delta.getElement().equals(this.getViewer().getInput())) {
            return;
        }
        TreePath treePath = this.getViewerTreePath(delta);
        this.cancelSubtreeUpdates(treePath);
        this.getTreeViewer().refresh(this.getElement(treePath));
    }

    protected void handleCollapse(IModelDelta delta) {
        TreePath elementPath = this.getViewerTreePath(delta);
        this.getTreeViewer().setExpandedState((Object)elementPath, false);
    }

    protected void handleExpand(IModelDelta delta) {
        IModelDelta parentDelta = delta.getParentDelta();
        if (parentDelta != null) {
            this.handleExpand(parentDelta);
            this.expand(delta);
        }
    }

    protected void expand(IModelDelta delta) {
        int childCount = delta.getChildCount();
        int modelIndex = delta.getIndex();
        TreeViewer treeViewer = this.getTreeViewer();
        TreePath elementPath = this.getViewerTreePath(delta);
        if (modelIndex >= 0) {
            int viewIndex;
            TreePath parentPath = elementPath.getParentPath();
            if (parentPath == null) {
                parentPath = TreePath.EMPTY;
            }
            if ((viewIndex = this.modelToViewIndex(parentPath, modelIndex)) >= 0) {
                if (DEBUG_CONTENT_PROVIDER) {
                    System.out.println("[expand] replace(" + delta.getParentDelta().getElement() + ", (model) " + modelIndex + " (view) " + viewIndex + ", " + delta.getElement());
                }
                treeViewer.replace((Object)parentPath, viewIndex, delta.getElement());
            } else {
                viewIndex = this.unfilterElement(parentPath, delta.getElement(), modelIndex);
                if (viewIndex < 0) {
                    return;
                }
            }
        }
        if (childCount > 0) {
            int viewCount = this.modelToViewChildCount(elementPath, childCount);
            if (DEBUG_CONTENT_PROVIDER) {
                System.out.println("[expand] setChildCount(" + delta.getElement() + ", (model) " + childCount + " (view) " + viewCount);
            }
            treeViewer.setChildCount((Object)elementPath, viewCount);
            if (!treeViewer.getExpandedState((Object)elementPath)) {
                treeViewer.expandToLevel((Object)elementPath, 1);
            }
        }
    }

    protected int unfilterElement(TreePath parentPath, Object element, int modelIndex) {
        if (this.shouldFilter(parentPath, element)) {
            if (DEBUG_CONTENT_PROVIDER) {
                System.out.println("[unfilter] abort unfilter element: " + element + ", (model) " + modelIndex);
            }
            return -1;
        }
        this.clearFilteredChild(parentPath, modelIndex);
        int viewIndex = this.modelToViewIndex(parentPath, modelIndex);
        if (viewIndex >= 0) {
            if (DEBUG_CONTENT_PROVIDER) {
                System.out.println("[unfilter] insert(" + parentPath.getLastSegment() + ", (model) " + modelIndex + " (view) " + viewIndex + ", " + element);
            }
            this.getTreeViewer().insert((Object)parentPath, element, viewIndex);
            return viewIndex;
        }
        return -1;
    }

    protected void handleInsert(IModelDelta delta) {
        this.getTreeViewer().insert((Object)this.getViewerTreePath(delta.getParentDelta()), delta.getElement(), delta.getIndex());
    }

    protected void handleRemove(IModelDelta delta) {
        TreePath parentPath;
        if (DEBUG_CONTENT_PROVIDER) {
            System.out.println("handleRemove(" + delta.getElement() + ")");
        }
        IModelDelta parentDelta = delta.getParentDelta();
        InternalTreeModelViewer treeViewer = (InternalTreeModelViewer)this.getViewer();
        Widget parentItem = treeViewer.findItem(parentPath = this.getViewerTreePath(parentDelta));
        if (parentItem == null) {
            this.clearFilters(parentPath);
            return;
        }
        Object element = delta.getElement();
        if (this.removeElementFromFilters(parentPath, element)) {
            return;
        }
        int viewIndex = -1;
        int modelIndex = delta.getIndex();
        int unmappedIndex = -1;
        int itemCount = -1;
        if (modelIndex < 0) {
            Item[] children = treeViewer.getChildren(parentItem);
            itemCount = children.length;
            int i = 0;
            while (i < children.length) {
                Item item = children[i];
                Object data = item.getData();
                if (element.equals(data)) {
                    viewIndex = i;
                    modelIndex = this.viewToModelIndex(parentPath, i);
                    break;
                }
                if (data == null) {
                    unmappedIndex = i;
                }
                ++i;
            }
        } else {
            viewIndex = this.modelToViewIndex(parentPath, modelIndex);
        }
        if (modelIndex >= 0) {
            if (DEBUG_CONTENT_PROVIDER) {
                System.out.println(" - (found) remove(" + parentPath.getLastSegment() + ", viewIndex: " + viewIndex + " modelIndex: " + modelIndex);
            }
            this.rescheduleUpdates(parentPath, modelIndex);
            this.getTreeViewer().remove((Object)parentPath, viewIndex);
            this.removeElementFromFilters(parentPath, modelIndex);
            return;
        }
        if (unmappedIndex >= 0) {
            if (DEBUG_CONTENT_PROVIDER) {
                System.out.println(" - (not found) remove(" + parentPath.getLastSegment() + ", viewIndex: " + viewIndex + " modelIndex: " + modelIndex);
            }
            modelIndex = this.viewToModelIndex(parentPath, unmappedIndex);
            this.rescheduleUpdates(parentPath, modelIndex);
            this.getTreeViewer().remove((Object)parentPath, unmappedIndex);
            this.removeElementFromFilters(parentPath, modelIndex);
            return;
        }
        int modelCount = parentDelta.getChildCount();
        if (itemCount >= 0 && modelCount >= 0 && this.modelToViewChildCount(parentPath, modelCount) == itemCount) {
            return;
        }
        if (DEBUG_CONTENT_PROVIDER) {
            System.out.println(" - (not found) remove/refresh(" + delta.getElement());
        }
        this.getTreeViewer().remove((Object)this.getViewerTreePath(delta));
        this.clearFilters(parentPath);
        this.getTreeViewer().refresh(parentDelta.getElement());
    }

    protected void handleReplace(IModelDelta delta) {
        TreePath parentPath = this.getViewerTreePath(delta.getParentDelta());
        this.getTreeViewer().replace((Object)parentPath, delta.getIndex(), delta.getElement());
    }

    protected void handleSelect(IModelDelta delta) {
        IModelDelta parentDelta;
        TreePath parentPath;
        int viewIndex;
        int modelIndex = delta.getIndex();
        TreeViewer treeViewer = this.getTreeViewer();
        if (modelIndex >= 0 && (viewIndex = this.modelToViewIndex(parentPath = this.getViewerTreePath(parentDelta = delta.getParentDelta()), modelIndex)) >= 0) {
            int modelCount = parentDelta.getChildCount();
            if (modelCount > 0) {
                int viewCount = this.modelToViewChildCount(parentPath, modelCount);
                if (DEBUG_CONTENT_PROVIDER) {
                    System.out.println("[select] setChildCount(" + parentDelta.getElement() + ", (model) " + parentDelta.getChildCount() + " (view) " + viewCount);
                }
                treeViewer.setChildCount((Object)parentPath, viewCount);
            }
            if (DEBUG_CONTENT_PROVIDER) {
                System.out.println("[select] replace(" + parentDelta.getElement() + ", (model) " + modelIndex + " (view) " + viewIndex + ", " + delta.getElement());
            }
            treeViewer.replace((Object)parentPath, viewIndex, delta.getElement());
        }
        treeViewer.setSelection((ISelection)new TreeSelection(this.getViewerTreePath(delta)));
    }

    protected void handleState(IModelDelta delta) {
        this.getTreeViewer().update(delta.getElement(), STATE_PROPERTIES);
    }

    protected void handleReveal(IModelDelta delta) {
        IModelDelta parentDelta = delta.getParentDelta();
        if (parentDelta != null) {
            this.handleExpand(parentDelta);
            this.reveal(delta);
        }
    }

    protected void reveal(IModelDelta delta) {
        int modelIndex = delta.getIndex();
        InternalTreeModelViewer treeViewer = (InternalTreeModelViewer)this.getTreeViewer();
        TreePath elementPath = this.getViewerTreePath(delta);
        if (modelIndex >= 0) {
            Widget item;
            int viewIndex;
            TreePath parentPath = elementPath.getParentPath();
            if (parentPath == null) {
                parentPath = TreePath.EMPTY;
            }
            if ((viewIndex = this.modelToViewIndex(parentPath, modelIndex)) >= 0) {
                if (DEBUG_CONTENT_PROVIDER) {
                    System.out.println("[reveal] replace(" + delta.getParentDelta().getElement() + ", (model) " + modelIndex + " (view) " + viewIndex + ", " + delta.getElement());
                }
                treeViewer.replace(parentPath, viewIndex, delta.getElement());
            } else {
                viewIndex = this.unfilterElement(parentPath, delta.getElement(), modelIndex);
                if (viewIndex < 0) {
                    return;
                }
            }
            if (treeViewer.overrideSelection(treeViewer.getSelection(), (ISelection)new TreeSelection(elementPath)) && (item = treeViewer.findItem(elementPath)) instanceof TreeItem) {
                treeViewer.getTree().setTopItem((TreeItem)item);
            }
        }
    }

    protected void buildViewerState(ModelDelta delta) {
        Tree tree = (Tree)this.getViewer().getControl();
        TreeItem[] selection = tree.getSelection();
        HashSet<TreeItem> set = new HashSet<TreeItem>();
        int i = 0;
        while (i < selection.length) {
            set.add(selection[i]);
            ++i;
        }
        TreeItem[] items = tree.getItems();
        int i2 = 0;
        while (i2 < items.length) {
            this.buildViewerState(EMPTY_TREE_PATH, delta, items[i2], set, i2);
            ++i2;
        }
        TreeItem topItem = tree.getTopItem();
        if (topItem != null && topItem.getData() != null) {
            LinkedList<TreeItem> itemsInPath = new LinkedList<TreeItem>();
            TreeItem item = topItem;
            while (item != null) {
                itemsInPath.addFirst(item);
                item = item.getParentItem();
            }
            ModelDelta parentDelta = delta;
            Iterator itr = itemsInPath.iterator();
            while (itr.hasNext()) {
                TreeItem next = (TreeItem)itr.next();
                Object element = next.getData();
                int index = next.getParentItem() == null ? tree.indexOf(next) : next.getParentItem().indexOf(next);
                ModelDelta childDelta = parentDelta.getChildDelta(element);
                parentDelta = childDelta == null ? parentDelta.addNode(element, index, 0) : childDelta;
            }
            parentDelta.setFlags(parentDelta.getFlags() | 0x1000000);
        }
    }

    private void buildViewerState(TreePath parentPath, ModelDelta delta, TreeItem item, Set set, int index) {
        Object element = item.getData();
        if (element != null) {
            boolean expanded = item.getExpanded();
            boolean selected = set.contains(item);
            if (expanded || selected) {
                int flags = 0;
                if (expanded) {
                    flags |= 0x100000;
                }
                if (selected) {
                    flags |= 0x200000;
                }
                int modelIndex = this.viewToModelIndex(parentPath, index);
                TreePath elementPath = parentPath.createChildPath(element);
                int numChildren = this.viewToModelCount(elementPath, item.getItemCount());
                ModelDelta childDelta = delta.addNode(element, modelIndex, flags, numChildren);
                if (expanded) {
                    TreeItem[] items = item.getItems();
                    int i = 0;
                    while (i < items.length) {
                        this.buildViewerState(elementPath, childDelta, items[i], set, i);
                        ++i;
                    }
                }
            }
        }
    }

    protected void doInitialRestore(ModelDelta delta) {
        this.markRevealDelta(delta);
        Tree tree = (Tree)this.getViewer().getControl();
        TreeItem[] items = tree.getItems();
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            Object data = item.getData();
            if (data != null) {
                this.doRestore(new TreePath(new Object[]{data}), i, false, false);
            }
            ++i;
        }
    }

    private ModelDelta markRevealDelta(ModelDelta rootDelta) {
        final ModelDelta[] revealDelta = new ModelDelta[1];
        IModelDeltaVisitor visitor = new IModelDeltaVisitor(){

            public boolean visit(IModelDelta delta, int depth) {
                if ((delta.getFlags() & 0x1000000) != 0) {
                    revealDelta[0] = (ModelDelta)delta;
                }
                return revealDelta[0] == null;
            }
        };
        rootDelta.accept(visitor);
        if (revealDelta[0] != null) {
            ModelDelta parentDelta = (ModelDelta)revealDelta[0].getParentDelta();
            while (parentDelta.getParentDelta() != null) {
                revealDelta[0] = parentDelta;
                revealDelta[0].setFlags(revealDelta[0].getFlags() | 0x1000000);
                parentDelta = (ModelDelta)parentDelta.getParentDelta();
            }
        }
        return revealDelta[0];
    }

    public TreePath[] getParents(Object element) {
        return null;
    }

    public synchronized void updateChildCount(TreePath treePath, int currentChildCount) {
        if (DEBUG_CONTENT_PROVIDER) {
            System.out.println("updateChildCount(" + this.getElement(treePath) + ", " + currentChildCount + ")");
        }
        this.refilterChildren(treePath);
        this.doUpdateChildCount(treePath);
    }

    public synchronized void updateElement(TreePath parentPath, int viewIndex) {
        int modelIndex = this.viewToModelIndex(parentPath, viewIndex);
        if (DEBUG_CONTENT_PROVIDER) {
            System.out.println("updateElement(" + this.getElement(parentPath) + ", " + viewIndex + ") > modelIndex = " + modelIndex);
        }
        this.doUpdateElement(parentPath, modelIndex);
    }

    public synchronized void updateHasChildren(TreePath path) {
        if (DEBUG_CONTENT_PROVIDER) {
            System.out.println("updateHasChildren(" + this.getElement(path));
        }
        this.doUpdateHasChildren(path);
    }

    void doRestore(ModelDelta delta, boolean knowsHasChildren, boolean knowsChildCount) {
        TreePath treePath = this.getViewerTreePath(delta);
        InternalTreeModelViewer viewer = (InternalTreeModelViewer)this.getViewer();
        if (knowsHasChildren && (delta.getFlags() & 0x100000) != 0) {
            viewer.expandToLevel(treePath, 1);
            delta.setFlags(delta.getFlags() & 0xFFEFFFFF);
        }
        if ((delta.getFlags() & 0x200000) != 0) {
            viewer.setSelection((ISelection)new TreeSelection(treePath), false);
            delta.setFlags(delta.getFlags() & 0xFFDFFFFF);
        }
        if ((delta.getFlags() & 0x1000000) != 0) {
            TreePath itemPath;
            Widget topItem;
            delta.setFlags(delta.getFlags() & 0xFEFFFFFF);
            boolean setTopItem = true;
            IModelDelta[] childDeltas = delta.getChildDeltas();
            int i = 0;
            while (i < childDeltas.length) {
                IModelDelta childDelta = childDeltas[i];
                int modelIndex = childDelta.getIndex();
                if (modelIndex >= 0 && (childDelta.getFlags() & 0x1000000) != 0) {
                    setTopItem = false;
                }
                ++i;
            }
            if (setTopItem && (topItem = viewer.findItem(itemPath = this.getViewerTreePath(delta))) instanceof TreeItem) {
                viewer.getTree().setTopItem((TreeItem)topItem);
            }
        }
        if (knowsChildCount) {
            IModelDelta[] childDeltas = delta.getChildDeltas();
            int i = 0;
            while (i < childDeltas.length) {
                IModelDelta childDelta = childDeltas[i];
                int modelIndex = childDelta.getIndex();
                if (modelIndex >= 0 && (childDelta.getFlags() & 0x1000000) != 0) {
                    this.doUpdateElement(treePath, modelIndex);
                }
                ++i;
            }
        }
        this.checkIfRestoreComplete();
    }
}

