/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt;

import com.rsi.idldt.IDLDTPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.intro.config.IIntroContentProvider;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IDLRSSViewer
implements IIntroContentProvider {
    private static final String INTRO_SHOW_IN_BROWSER = "http://org.eclipse.ui.intro/openBrowser?url=";
    private static final int MAX_NEWS_ITEMS = 5;
    private static final String HREF_BULLET = "bullet";
    IIntroContentProviderSite m_site;
    boolean disposed;
    String m_id;
    FormToolkit m_toolkit;
    Composite m_parent;
    private Image bulletImage;
    List<NewsItem> items;
    private boolean bDoneParsingFeed = false;
    FormText formText;
    private Thread newsWorker;

    public void init(IIntroContentProviderSite site) {
        this.m_site = site;
    }

    public void createContent(String id, PrintWriter out) {
        if (this.disposed) {
            return;
        }
        this.m_id = id;
        if (!this.bDoneParsingFeed) {
            if (this.newsWorker == null) {
                Thread newsWorker1 = new Thread(new NewsFeed());
                newsWorker1.start();
            }
            out.print("<p class=\"status-text\">");
            if (this.m_id != null) {
                out.print("Loading " + this.m_id);
            }
            out.println("</p>");
        } else {
            if (this.items.size() > 0) {
                out.println("<ul id=\"rss-feed\">");
                int i = 0;
                while (i < this.items.size()) {
                    NewsItem item = this.items.get(i);
                    out.print("<li>");
                    out.print("<a class=\"topicList\" href=\"");
                    out.print(this.createExternalURL(item.url));
                    out.print('\"');
                    if (item.description != null) {
                        out.print(" title=\"");
                        out.print(item.description);
                        out.print('\"');
                    }
                    out.print('>');
                    out.print(item.label);
                    out.print("</a>");
                    out.println("</li>");
                    ++i;
                }
            } else {
                out.print("<p class=\"status-text\">");
                if (this.m_id != null) {
                    out.print(this.m_id);
                }
                out.println("</p>");
            }
            out.println("</ul>");
        }
    }

    public void createContent(String id, Composite parent, FormToolkit toolkit) {
        if (this.disposed) {
            return;
        }
        if (this.formText == null) {
            this.formText = toolkit.createFormText(parent, true);
            this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    IDLRSSViewer.this.doNavigate((String)e.getHref());
                }
            });
            ImageDescriptor desc = IDLDTPlugin.getImageDescriptor("intro/css/graphics/arrow.gif");
            if (desc != null) {
                this.bulletImage = desc.createImage();
                if (this.bulletImage != null) {
                    this.formText.setImage(HREF_BULLET, this.bulletImage);
                }
            }
            this.m_parent = parent;
            this.m_toolkit = toolkit;
            this.m_id = id;
            if (this.newsWorker == null) {
                Thread newsWorker1 = new Thread(new NewsFeed());
                newsWorker1.start();
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<form>");
        if (!this.bDoneParsingFeed) {
            buffer.append("<p>");
            if (this.m_id != null) {
                buffer.append("Loading " + this.m_id);
            }
            buffer.append("</p>");
        } else if (this.items.size() > 0) {
            int i = 0;
            while (i < this.items.size()) {
                NewsItem item = this.items.get(i);
                buffer.append("<li style=\"image\" value=\"");
                buffer.append(HREF_BULLET);
                buffer.append("\">");
                buffer.append("<a href=\"");
                buffer.append(item.url);
                buffer.append("\">");
                buffer.append(item.label);
                buffer.append("</a>");
                buffer.append("</li>");
                ++i;
            }
        } else {
            buffer.append("<p>");
            if (this.m_id != null) {
                buffer.append(this.m_id);
            }
            buffer.append("</p>");
        }
        buffer.append("</form>");
        this.formText.setText(buffer.toString(), true, false);
    }

    private String createExternalURL(String url) {
        try {
            return INTRO_SHOW_IN_BROWSER + URLEncoder.encode(url, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return INTRO_SHOW_IN_BROWSER + url;
        }
    }

    void doNavigate(final String url) {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IIntroURL introUrl = IntroURLFactory.createIntroURL((String)url);
                if (introUrl != null) {
                    introUrl.execute();
                    return;
                }
                IDLRSSViewer.this.openBrowser(url);
            }
        });
    }

    void openBrowser(String href) {
        try {
            URL url = new URL(href);
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            support.getExternalBrowser().openURL(url);
        }
        catch (PartInitException partInitException) {
        }
        catch (MalformedURLException malformedURLException) {}
    }

    void createNewsItems() {
        block14: {
            this.items = Collections.synchronizedList(new ArrayList());
            InputStream in = null;
            try {
                try {
                    URL url = new URL(this.m_id);
                    URLConnection con = url.openConnection();
                    con.setRequestProperty("User-Agent", "Mozilla/4.0");
                    in = con.getInputStream();
                    SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                    parser.parse(in, (DefaultHandler)new RSSHandler());
                }
                catch (Exception exception) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                    this.bDoneParsingFeed = true;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
                this.bDoneParsingFeed = true;
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            this.bDoneParsingFeed = true;
        }
    }

    void reflow(Control initiator) {
        Control c = initiator;
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
        c = initiator;
        while (c != null) {
            if (c instanceof Composite) {
                ((Composite)c).layout(true);
            }
            if (!((c = c.getParent()) instanceof ScrolledForm)) continue;
            ((ScrolledForm)c).reflow(true);
            break;
        }
        c = initiator;
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
    }

    public void dispose() {
        if (this.bulletImage != null) {
            this.bulletImage.dispose();
            this.bulletImage = null;
        }
        this.disposed = true;
    }

    class NewsFeed
    implements Runnable {
        NewsFeed() {
        }

        public void run() {
            if (IDLRSSViewer.this.disposed) {
                return;
            }
            IDLRSSViewer.this.createNewsItems();
            if (IDLRSSViewer.this.disposed) {
                return;
            }
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (((NewsFeed)NewsFeed.this).IDLRSSViewer.this.m_parent != null) {
                        IDLRSSViewer.this.createContent(((NewsFeed)NewsFeed.this).IDLRSSViewer.this.m_id, ((NewsFeed)NewsFeed.this).IDLRSSViewer.this.m_parent, ((NewsFeed)NewsFeed.this).IDLRSSViewer.this.m_toolkit);
                        IDLRSSViewer.this.reflow((Control)((NewsFeed)NewsFeed.this).IDLRSSViewer.this.formText);
                    }
                    ((NewsFeed)NewsFeed.this).IDLRSSViewer.this.m_site.reflow((IIntroContentProvider)IDLRSSViewer.this, true);
                }
            });
        }
    }

    class NewsItem {
        String label;
        String url;
        String description;

        NewsItem() {
        }
    }

    class RSSHandler
    extends DefaultHandler {
        private static final String ELEMENT_CHANNEL = "channel";
        private static final String ELEMENT_ITEM = "item";
        private static final String ELEMENT_TITLE = "title";
        private static final String ELEMENT_LINK = "link";
        private static final String ELEMENT_DESCRIPTION = "description";
        private Stack<String> stack = new Stack();
        private StringBuffer buf;
        private NewsItem item;

        RSSHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.stack.push(qName);
            this.buf = new StringBuffer();
            if ((!ELEMENT_TITLE.equals(qName) && !ELEMENT_LINK.equals(qName) && !ELEMENT_DESCRIPTION.equals(qName) || this.item == null) && ELEMENT_ITEM.equals(qName) && this.stack.size() == 3 && ELEMENT_CHANNEL.equals(this.stack.get(1)) && IDLRSSViewer.this.items.size() < 5) {
                this.item = new NewsItem();
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.stack.pop();
            if (this.item != null) {
                if (ELEMENT_TITLE.equals(qName)) {
                    this.item.label = this.buf.toString().trim();
                } else if (ELEMENT_LINK.equals(qName)) {
                    this.item.url = this.buf.toString().trim();
                } else if (ELEMENT_DESCRIPTION.equals(qName)) {
                    String s = this.buf.toString().trim();
                    this.item.description = s = s.replaceAll("<[^>]+>", "");
                } else if (ELEMENT_ITEM.equals(qName)) {
                    if (this.item.label != null && this.item.label.length() > 0 && this.item.url != null && this.item.url.length() > 0) {
                        IDLRSSViewer.this.items.add(this.item);
                    }
                    this.item = null;
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buf != null) {
                this.buf.append(new String(ch, start, length));
            }
        }
    }
}

