/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt;

import com.rsi.idldt.DisplayUtils;
import com.rsi.idldt.IDLHelp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpApplication;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.server.WebappManager;
import org.eclipse.osgi.util.NLS;

public class IDLHelpApplication
implements IApplication,
IExecutableExtension {
    private static final String APPLICATION_LOCK_FILE = ".applicationlock";
    private static final int STATE_EXITING = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_RESTARTING = 2;
    private static int status = 1;
    private File metadata;
    private FileLock lock;

    public synchronized Object start(IApplicationContext context) throws Exception {
        if (status == 2) {
            return EXIT_RESTART;
        }
        this.metadata = new File(Platform.getLocation().toFile(), ".metadata/");
        this.obtainLock();
        if (this.lock == null) {
            this.executeHelpCommands(true);
            return EXIT_OK;
        }
        if (!BaseHelpSystem.ensureWebappRunning()) {
            System.out.println(NLS.bind((String)HelpBaseResources.HelpApplication_couldNotStart, (Object)Platform.getLogFileLocation().toOSString()));
            return EXIT_OK;
        }
        if (status == 2) {
            return EXIT_RESTART;
        }
        this.writeHostAndPort();
        if (2 == BaseHelpSystem.getMode()) {
            this.executeHelpCommands(false);
            DisplayUtils.runUI();
        }
        while (HelpApplication.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        this.releaseLock();
        if (status == 2) {
            return EXIT_RESTART;
        }
        return EXIT_OK;
    }

    public void executeHelpCommands(boolean isStarted) {
        final String[] args = Platform.getCommandLineArgs();
        Runnable r = new Runnable(){

            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                String[] args2 = new String[args.length + 2];
                int i = 0;
                while (i < args.length) {
                    args2[i] = args[i];
                    ++i;
                }
                args2[i++] = "-data";
                args2[i] = Platform.getLocation().toString();
                IDLHelp.main(args2);
            }
        };
        if (isStarted) {
            r.run();
        } else {
            Thread t = new Thread(r);
            t.start();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void stop() {
        IDLHelpApplication.stopHelp();
        IDLHelpApplication iDLHelpApplication = this;
        // MONITORENTER : iDLHelpApplication
        // MONITOREXIT : iDLHelpApplication
    }

    public static void stopHelp() {
        status = 0;
        if (2 == BaseHelpSystem.getMode()) {
            DisplayUtils.wakeupUI();
        }
    }

    public static void restartHelp() {
        if (status != 0) {
            status = 2;
        }
    }

    public void setInitializationData(IConfigurationElement configElement, String propertyName, Object data) {
        String value = (String)((Map)data).get("mode");
        if ("infocenter".equalsIgnoreCase(value)) {
            BaseHelpSystem.setMode((int)1);
        } else if ("standalone".equalsIgnoreCase(value)) {
            BaseHelpSystem.setMode((int)2);
        }
    }

    private void writeHostAndPort() throws IOException {
        Properties p = new Properties();
        p.put("host", WebappManager.getHost());
        p.put("port", "" + WebappManager.getPort());
        File hostPortFile = new File(this.metadata, ".connection");
        hostPortFile.deleteOnExit();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(hostPortFile);
            p.store(out, null);
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void obtainLock() {
        File lockFile = new File(this.metadata, APPLICATION_LOCK_FILE);
        try {
            RandomAccessFile raf = new RandomAccessFile(lockFile, "rw");
            this.lock = raf.getChannel().tryLock();
        }
        catch (IOException iOException) {
            this.lock = null;
        }
    }

    private void releaseLock() {
        if (this.lock != null) {
            try {
                this.lock.channel().close();
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean isRunning() {
        return status == 1;
    }
}

