/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.standalone.Help;
import org.osgi.framework.Bundle;

public class IDLHelp {
    static String eclipseHome;
    static File[] docjars;

    public static void main(String[] args) {
        try {
            IDLHelp.computeEclipseHome(args);
            IDLHelp.installDocjars(args);
            String topic = IDLHelp.getTopicHref(args);
            if (topic != null) {
                Help help = new Help(args);
                if (topic.length() > 0) {
                    help.displayHelp(topic);
                } else {
                    help.displayHelp();
                }
            } else {
                Help.main((String[])args);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
    }

    private static void computeEclipseHome(String[] args) {
        int i = 0;
        while (i < args.length - 1) {
            if ("-eclipsehome".equalsIgnoreCase(args[i])) {
                eclipseHome = args[i + 1];
                return;
            }
            ++i;
        }
        String s = System.getProperty("osgi.syspath");
        s = s != null ? s.replaceAll("plugins", "") : ".";
        eclipseHome = s;
    }

    private static void installDocjars(String[] args) throws IOException {
        docjars = IDLHelp.getDocjars();
        String filterList = null;
        int i = 0;
        while (i < args.length) {
            if ("-filter".equals(args[i]) && i < args.length - 1 && args[i + 1].charAt(0) != '-') {
                filterList = args[i + 1];
            }
            ++i;
        }
        if (filterList == null || filterList.length() == 0) {
            return;
        }
        String[] filters = filterList.split(",");
        Vector<File> docKeep = new Vector<File>();
        int i2 = 0;
        while (i2 < docjars.length) {
            String pluginID = IDLHelp.getPluginID(docjars[i2]);
            boolean foundMatch = false;
            int j = 0;
            while (j < filters.length) {
                if (pluginID.startsWith(filters[j])) {
                    foundMatch = true;
                    break;
                }
                ++j;
            }
            if (foundMatch) {
                docKeep.add(docjars[i2]);
            } else {
                try {
                    Bundle b = Platform.getBundle((String)pluginID);
                    if (b != null) {
                        b.uninstall();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i2;
        }
        if (docKeep.isEmpty()) {
            docjars = null;
        } else {
            docjars = new File[docKeep.size()];
            docKeep.toArray(docjars);
        }
    }

    private static File[] getDocjars() {
        File plugins = new File(eclipseHome, "plugins");
        File[] docjars1 = plugins.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.indexOf(".doc.") >= 0 || name.indexOf(".doc_") >= 0;
            }
        });
        return docjars1;
    }

    private static String getTopicHref(String[] args) {
        String href = "";
        int i = 0;
        while (i < args.length) {
            if ("-command".equals(args[i])) {
                return null;
            }
            if ("-topic".equals(args[i]) && i < args.length - 1 && args[i + 1].charAt(0) != '-') {
                href = IDLHelp.findTopic(args[i + 1]);
            }
            ++i;
        }
        return href;
    }

    private static String findTopic(String topic) {
        if (docjars == null || docjars.length == 0) {
            return "";
        }
        String topicname = topic;
        int htmlIndex = topic.indexOf(".html");
        if (htmlIndex >= 0) {
            topicname = topic.substring(0, htmlIndex);
        }
        String topicpath = String.valueOf(topicname) + ".html";
        String topicpathUpper = String.valueOf(topicname.toUpperCase()) + ".html";
        String anchor = "";
        int iAnchor = topic.indexOf(35);
        if (iAnchor >= 0 && iAnchor < topic.length() - 1) {
            anchor = "%23" + topic.substring(iAnchor + 1);
        }
        int i = 0;
        while (i < docjars.length) {
            String pluginID;
            String entryName;
            block10: {
                entryName = null;
                try {
                    JarFile jfile = new JarFile(docjars[i], false);
                    JarEntry entry = jfile.getJarEntry(topicpath);
                    if (entry == null) {
                        entry = jfile.getJarEntry(topicpathUpper);
                    }
                    if (entry != null) {
                        entryName = entry.getName();
                    }
                }
                catch (IOException iOException) {
                    File f = new File(docjars[i], topicpath);
                    if (!f.canRead()) {
                        f = new File(docjars[i], topicpathUpper);
                    }
                    if (!f.canRead()) break block10;
                    entryName = f.getName();
                }
            }
            if (entryName != null && (pluginID = IDLHelp.getPluginID(docjars[i])) != null) {
                return String.valueOf('/') + pluginID + '/' + entryName + anchor;
            }
            ++i;
        }
        return "/com.rsi.idl.doc.base/TopicNotFound.html?notfound=" + topic;
    }

    private static String getPluginID(File file) {
        String f = file.getName();
        int index = f.indexOf(95);
        if (index > 0) {
            f = f.substring(0, index);
        } else if (f.toLowerCase().endsWith(".jar")) {
            f = f.substring(0, f.length() - 4);
        }
        return f;
    }
}

