/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.GeneralName;

public final class AccessDescription {
    private int myhash = -1;
    private ObjectIdentifier accessMethod;
    private GeneralName accessLocation;
    public static final ObjectIdentifier Ad_OCSP_Id;

    public AccessDescription(DerValue derValue) throws IOException {
        DerInputStream derInputStream = derValue.getData();
        this.accessMethod = derInputStream.getOID();
        DerValue derValue2 = derInputStream.getDerValue();
        this.accessLocation = new GeneralName(derValue2);
    }

    public ObjectIdentifier getAccessMethod() {
        return this.accessMethod;
    }

    public GeneralName getAccessLocation() {
        return this.accessLocation;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.accessMethod);
        this.accessLocation.encode(derOutputStream2);
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = this.accessMethod.hashCode() + this.accessLocation.hashCode();
        }
        return this.myhash;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AccessDescription)) {
            return false;
        }
        AccessDescription accessDescription = (AccessDescription)object;
        if (this == accessDescription) {
            return true;
        }
        return this.accessMethod.equals(accessDescription.getAccessMethod()) && this.accessLocation.equals(accessDescription.getAccessLocation());
    }

    public String toString() {
        return "accessMethod: " + this.accessMethod.toString() + "\n   accessLocation: " + this.accessLocation.toString();
    }

    static {
        ObjectIdentifier objectIdentifier = null;
        try {
            objectIdentifier = new ObjectIdentifier("1.3.6.1.5.5.7.48.1");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Ad_OCSP_Id = objectIdentifier;
    }
}

