/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.runtime;

import java.security.AccessController;
import java.util.LinkedList;
import sun.rmi.runtime.Executor;
import sun.rmi.runtime.NewThreadAction;
import sun.security.action.GetLongAction;

final class ThreadPool
implements Executor {
    private static final long idleTimeout = (Long)AccessController.doPrivileged(new GetLongAction("sun.rmi.jrmp.idleThreadTimeout", 300000L));
    private final ThreadGroup threadGroup;
    private final Object lock = new Object();
    private int totalThreads = 0;
    private int idleThreads = 0;
    private final LinkedList queue = new LinkedList();

    ThreadPool(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable, String string) {
        Task task = new Task(runnable, string);
        Object object = this.lock;
        synchronized (object) {
            if (this.queue.size() < this.idleThreads) {
                this.queue.addLast(task);
                this.lock.notify();
            } else {
                Thread thread = (Thread)AccessController.doPrivileged(new NewThreadAction(this.threadGroup, new Worker(task), string, true));
                thread.start();
                ++this.totalThreads;
            }
        }
    }

    private static class Task {
        final Runnable runnable;
        final String name;

        Task(Runnable runnable, String string) {
            this.runnable = runnable;
            this.name = string;
        }
    }

    private class Worker
    implements Runnable {
        private Task first;

        Worker(Task task) {
            this.first = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object;
            try {
                object = this.first;
                this.first = null;
                while (true) {
                    ((Task)object).runnable.run();
                    Object object2 = ThreadPool.this.lock;
                    synchronized (object2) {
                        if (ThreadPool.this.queue.isEmpty()) {
                            Thread.currentThread().setName("RMI Idle");
                            ThreadPool.this.idleThreads++;
                            try {
                                ThreadPool.this.lock.wait(idleTimeout);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            finally {
                                ThreadPool.this.idleThreads--;
                            }
                            if (ThreadPool.this.queue.isEmpty()) {
                                return;
                            }
                        }
                        object = (Task)ThreadPool.this.queue.removeFirst();
                        Thread.currentThread().setName("RMI " + ((Task)object).name);
                    }
                }
            }
            finally {
                object = ThreadPool.this.lock;
                synchronized (object) {
                    ThreadPool.this.totalThreads--;
                }
            }
        }
    }
}

