/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOUtil;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Util {
    private static final int TEMP_BUF_POOL_SIZE = 3;
    private static ThreadLocal[] bufferPool = new ThreadLocal[3];
    private static ThreadLocal localSelector;
    private static ThreadLocal localSelectorWrapper;
    private static Unsafe unsafe;
    private static int pageSize;
    private static Constructor directByteBufferConstructor;
    private static Constructor directByteBufferRConstructor;
    private static String bugLevel;
    private static boolean loaded;

    Util() {
    }

    static ByteBuffer getTemporaryDirectBuffer(int n) {
        ByteBuffer byteBuffer = null;
        for (int i = 0; i < 3; ++i) {
            SoftReference softReference = (SoftReference)bufferPool[i].get();
            if (softReference == null || (byteBuffer = (ByteBuffer)softReference.get()) == null || byteBuffer.capacity() < n) continue;
            byteBuffer.rewind();
            byteBuffer.limit(n);
            bufferPool[i].set(null);
            return byteBuffer;
        }
        return ByteBuffer.allocateDirect(n);
    }

    static void releaseTemporaryDirectBuffer(ByteBuffer byteBuffer) {
        SoftReference softReference;
        int n;
        if (byteBuffer == null) {
            return;
        }
        for (n = 0; n < 3; ++n) {
            softReference = (SoftReference)bufferPool[n].get();
            if (softReference != null && softReference.get() != null) continue;
            bufferPool[n].set(new SoftReference<ByteBuffer>(byteBuffer));
            return;
        }
        for (n = 0; n < 3; ++n) {
            softReference = (SoftReference)bufferPool[n].get();
            ByteBuffer byteBuffer2 = (ByteBuffer)softReference.get();
            if (byteBuffer2 != null && byteBuffer.capacity() <= byteBuffer2.capacity()) continue;
            bufferPool[n].set(new SoftReference<ByteBuffer>(byteBuffer));
            return;
        }
    }

    static Selector getTemporarySelector(SelectableChannel selectableChannel) throws IOException {
        SoftReference softReference = (SoftReference)localSelector.get();
        SelectorWrapper selectorWrapper = null;
        Selector selector = null;
        if (softReference == null || (selectorWrapper = (SelectorWrapper)softReference.get()) == null || (selector = selectorWrapper.get()) == null || selector.provider() != selectableChannel.provider()) {
            selector = selectableChannel.provider().openSelector();
            localSelector.set(new SoftReference<SelectorWrapper>(new SelectorWrapper(selector)));
        } else {
            localSelectorWrapper.set(selectorWrapper);
        }
        return selector;
    }

    static void releaseTemporarySelector(Selector selector) throws IOException {
        selector.selectNow();
        assert (selector.keys().isEmpty()) : "Temporary selector not empty";
        localSelectorWrapper.set(null);
    }

    static ByteBuffer[] subsequence(ByteBuffer[] byteBufferArray, int n, int n2) {
        if (n == 0 && n2 == byteBufferArray.length) {
            return byteBufferArray;
        }
        int n3 = n2;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n3];
        for (int i = 0; i < n3; ++i) {
            byteBufferArray2[i] = byteBufferArray[n + i];
        }
        return byteBufferArray2;
    }

    static <E> Set<E> ungrowableSet(final Set<E> set) {
        return new Set<E>(){

            @Override
            public int size() {
                return set.size();
            }

            @Override
            public boolean isEmpty() {
                return set.isEmpty();
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object);
            }

            @Override
            public Object[] toArray() {
                return set.toArray();
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return set.toArray(TArray);
            }

            public String toString() {
                return set.toString();
            }

            @Override
            public Iterator<E> iterator() {
                return set.iterator();
            }

            @Override
            public boolean equals(Object object) {
                return ((Object)set).equals(object);
            }

            @Override
            public int hashCode() {
                return ((Object)set).hashCode();
            }

            @Override
            public void clear() {
                set.clear();
            }

            @Override
            public boolean remove(Object object) {
                return set.remove(object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return set.containsAll(collection);
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                return set.removeAll(collection);
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                return set.retainAll(collection);
            }

            @Override
            public boolean add(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends E> collection) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static byte _get(long l) {
        return unsafe.getByte(l);
    }

    private static void _put(long l, byte by) {
        unsafe.putByte(l, by);
    }

    static void erase(ByteBuffer byteBuffer) {
        unsafe.setMemory(((DirectBuffer)((Object)byteBuffer)).address(), byteBuffer.capacity(), (byte)0);
    }

    static Unsafe unsafe() {
        return unsafe;
    }

    static int pageSize() {
        if (pageSize == -1) {
            pageSize = Util.unsafe().pageSize();
        }
        return pageSize;
    }

    private static void initDBBConstructor() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName("java.nio.DirectByteBuffer");
                    directByteBufferConstructor = clazz.getDeclaredConstructor(Integer.TYPE, Long.TYPE, Runnable.class);
                    directByteBufferConstructor.setAccessible(true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalError();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InternalError();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InternalError();
                }
                catch (ClassCastException classCastException) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }

    static MappedByteBuffer newMappedByteBuffer(int n, long l, Runnable runnable) {
        MappedByteBuffer mappedByteBuffer;
        if (directByteBufferConstructor == null) {
            Util.initDBBConstructor();
        }
        try {
            mappedByteBuffer = (MappedByteBuffer)directByteBufferConstructor.newInstance(new Integer(n), new Long(l), runnable);
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError();
        }
        return mappedByteBuffer;
    }

    private static void initDBBRConstructor() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName("java.nio.DirectByteBufferR");
                    directByteBufferRConstructor = clazz.getDeclaredConstructor(Integer.TYPE, Long.TYPE, Runnable.class);
                    directByteBufferRConstructor.setAccessible(true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalError();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InternalError();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InternalError();
                }
                catch (ClassCastException classCastException) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }

    static MappedByteBuffer newMappedByteBufferR(int n, long l, Runnable runnable) {
        MappedByteBuffer mappedByteBuffer;
        if (directByteBufferRConstructor == null) {
            Util.initDBBRConstructor();
        }
        try {
            mappedByteBuffer = (MappedByteBuffer)directByteBufferRConstructor.newInstance(new Integer(n), new Long(l), runnable);
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError();
        }
        return mappedByteBuffer;
    }

    static boolean atBugLevel(String string) {
        if (bugLevel == null) {
            if (!VM.isBooted()) {
                return false;
            }
            GetPropertyAction getPropertyAction = new GetPropertyAction("sun.nio.ch.bugLevel");
            bugLevel = (String)AccessController.doPrivileged(getPropertyAction);
            if (bugLevel == null) {
                bugLevel = "";
            }
        }
        return bugLevel != null && bugLevel.equals(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load() {
        Class<Util> clazz = Util.class;
        synchronized (Util.class) {
            if (loaded) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            loaded = true;
            AccessController.doPrivileged(new LoadLibraryAction("net"));
            AccessController.doPrivileged(new LoadLibraryAction("nio"));
            IOUtil.initIDs();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        for (int i = 0; i < 3; ++i) {
            Util.bufferPool[i] = new ThreadLocal();
        }
        localSelector = new ThreadLocal();
        localSelectorWrapper = new ThreadLocal();
        unsafe = Unsafe.getUnsafe();
        pageSize = -1;
        directByteBufferConstructor = null;
        directByteBufferRConstructor = null;
        bugLevel = null;
        loaded = false;
    }

    private static class SelectorWrapper {
        private Selector sel;

        private SelectorWrapper(Selector selector) {
            this.sel = selector;
            Cleaner.create(this, new Closer(selector));
        }

        public Selector get() {
            return this.sel;
        }

        private static class Closer
        implements Runnable {
            private Selector sel;

            private Closer(Selector selector) {
                this.sel = selector;
            }

            public void run() {
                try {
                    this.sel.close();
                }
                catch (Throwable throwable) {
                    throw new Error(throwable);
                }
            }
        }
    }
}

