/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class JTextPane
extends JEditorPane {
    private static final String uiClassID = "TextPaneUI";

    public JTextPane() {
        this.setEditorKit(this.createDefaultEditorKit());
    }

    public JTextPane(StyledDocument styledDocument) {
        this();
        this.setStyledDocument(styledDocument);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setDocument(Document document) {
        if (!(document instanceof StyledDocument)) {
            throw new IllegalArgumentException("Model must be StyledDocument");
        }
        super.setDocument(document);
    }

    public void setStyledDocument(StyledDocument styledDocument) {
        super.setDocument(styledDocument);
    }

    public StyledDocument getStyledDocument() {
        return (StyledDocument)this.getDocument();
    }

    public void replaceSelection(String string) {
        this.replaceSelection(string, true);
    }

    private void replaceSelection(String string, boolean bl) {
        if (bl && !this.isEditable()) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
            return;
        }
        StyledDocument styledDocument = this.getStyledDocument();
        if (styledDocument != null) {
            try {
                Caret caret = this.getCaret();
                int n = Math.min(caret.getDot(), caret.getMark());
                int n2 = Math.max(caret.getDot(), caret.getMark());
                AttributeSet attributeSet = this.getInputAttributes().copyAttributes();
                if (styledDocument instanceof AbstractDocument) {
                    ((AbstractDocument)((Object)styledDocument)).replace(n, n2 - n, string, attributeSet);
                } else {
                    if (n != n2) {
                        styledDocument.remove(n, n2 - n);
                    }
                    if (string != null && string.length() > 0) {
                        styledDocument.insertString(n, string, attributeSet);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
            }
        }
    }

    public void insertComponent(Component component) {
        MutableAttributeSet mutableAttributeSet = this.getInputAttributes();
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        StyleConstants.setComponent(mutableAttributeSet, component);
        this.replaceSelection(" ", false);
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
    }

    public void insertIcon(Icon icon) {
        MutableAttributeSet mutableAttributeSet = this.getInputAttributes();
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        StyleConstants.setIcon(mutableAttributeSet, icon);
        this.replaceSelection(" ", false);
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
    }

    public Style addStyle(String string, Style style) {
        StyledDocument styledDocument = this.getStyledDocument();
        return styledDocument.addStyle(string, style);
    }

    public void removeStyle(String string) {
        StyledDocument styledDocument = this.getStyledDocument();
        styledDocument.removeStyle(string);
    }

    public Style getStyle(String string) {
        StyledDocument styledDocument = this.getStyledDocument();
        return styledDocument.getStyle(string);
    }

    public void setLogicalStyle(Style style) {
        StyledDocument styledDocument = this.getStyledDocument();
        styledDocument.setLogicalStyle(this.getCaretPosition(), style);
    }

    public Style getLogicalStyle() {
        StyledDocument styledDocument = this.getStyledDocument();
        return styledDocument.getLogicalStyle(this.getCaretPosition());
    }

    public AttributeSet getCharacterAttributes() {
        StyledDocument styledDocument = this.getStyledDocument();
        Element element = styledDocument.getCharacterElement(this.getCaretPosition());
        if (element != null) {
            return element.getAttributes();
        }
        return null;
    }

    public void setCharacterAttributes(AttributeSet attributeSet, boolean bl) {
        int n;
        int n2 = this.getSelectionStart();
        if (n2 != (n = this.getSelectionEnd())) {
            StyledDocument styledDocument = this.getStyledDocument();
            styledDocument.setCharacterAttributes(n2, n - n2, attributeSet, bl);
        } else {
            MutableAttributeSet mutableAttributeSet = this.getInputAttributes();
            if (bl) {
                mutableAttributeSet.removeAttributes(mutableAttributeSet);
            }
            mutableAttributeSet.addAttributes(attributeSet);
        }
    }

    public AttributeSet getParagraphAttributes() {
        StyledDocument styledDocument = this.getStyledDocument();
        Element element = styledDocument.getParagraphElement(this.getCaretPosition());
        if (element != null) {
            return element.getAttributes();
        }
        return null;
    }

    public void setParagraphAttributes(AttributeSet attributeSet, boolean bl) {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        StyledDocument styledDocument = this.getStyledDocument();
        styledDocument.setParagraphAttributes(n, n2 - n, attributeSet, bl);
    }

    public MutableAttributeSet getInputAttributes() {
        return this.getStyledEditorKit().getInputAttributes();
    }

    protected final StyledEditorKit getStyledEditorKit() {
        return (StyledEditorKit)this.getEditorKit();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    protected EditorKit createDefaultEditorKit() {
        return new StyledEditorKit();
    }

    public final void setEditorKit(EditorKit editorKit) {
        if (!(editorKit instanceof StyledEditorKit)) {
            throw new IllegalArgumentException("Must be StyledEditorKit");
        }
        super.setEditorKit(editorKit);
    }

    protected String paramString() {
        return super.paramString();
    }
}

