/*
 * Decompiled with CFR 0.152.
 */
package java.io;

class Bits {
    Bits() {
    }

    static boolean getBoolean(byte[] byArray, int n) {
        return byArray[n] != 0;
    }

    static char getChar(byte[] byArray, int n) {
        return (char)(((byArray[n + 1] & 0xFF) << 0) + ((byArray[n + 0] & 0xFF) << 8));
    }

    static short getShort(byte[] byArray, int n) {
        return (short)(((byArray[n + 1] & 0xFF) << 0) + ((byArray[n + 0] & 0xFF) << 8));
    }

    static int getInt(byte[] byArray, int n) {
        return ((byArray[n + 3] & 0xFF) << 0) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 0] & 0xFF) << 24);
    }

    static float getFloat(byte[] byArray, int n) {
        int n2 = ((byArray[n + 3] & 0xFF) << 0) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 0] & 0xFF) << 24);
        return Float.intBitsToFloat(n2);
    }

    static long getLong(byte[] byArray, int n) {
        return (((long)byArray[n + 7] & 0xFFL) << 0) + (((long)byArray[n + 6] & 0xFFL) << 8) + (((long)byArray[n + 5] & 0xFFL) << 16) + (((long)byArray[n + 4] & 0xFFL) << 24) + (((long)byArray[n + 3] & 0xFFL) << 32) + (((long)byArray[n + 2] & 0xFFL) << 40) + (((long)byArray[n + 1] & 0xFFL) << 48) + (((long)byArray[n + 0] & 0xFFL) << 56);
    }

    static double getDouble(byte[] byArray, int n) {
        long l = (((long)byArray[n + 7] & 0xFFL) << 0) + (((long)byArray[n + 6] & 0xFFL) << 8) + (((long)byArray[n + 5] & 0xFFL) << 16) + (((long)byArray[n + 4] & 0xFFL) << 24) + (((long)byArray[n + 3] & 0xFFL) << 32) + (((long)byArray[n + 2] & 0xFFL) << 40) + (((long)byArray[n + 1] & 0xFFL) << 48) + (((long)byArray[n + 0] & 0xFFL) << 56);
        return Double.longBitsToDouble(l);
    }

    static void putBoolean(byte[] byArray, int n, boolean bl) {
        byArray[n] = (byte)(bl ? 1 : 0);
    }

    static void putChar(byte[] byArray, int n, char c) {
        byArray[n + 1] = (byte)(c >>> 0);
        byArray[n + 0] = (byte)(c >>> 8);
    }

    static void putShort(byte[] byArray, int n, short s) {
        byArray[n + 1] = (byte)(s >>> 0);
        byArray[n + 0] = (byte)(s >>> 8);
    }

    static void putInt(byte[] byArray, int n, int n2) {
        byArray[n + 3] = (byte)(n2 >>> 0);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 0] = (byte)(n2 >>> 24);
    }

    static void putFloat(byte[] byArray, int n, float f) {
        int n2 = Float.floatToIntBits(f);
        byArray[n + 3] = (byte)(n2 >>> 0);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 0] = (byte)(n2 >>> 24);
    }

    static void putLong(byte[] byArray, int n, long l) {
        byArray[n + 7] = (byte)(l >>> 0);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 0] = (byte)(l >>> 56);
    }

    static void putDouble(byte[] byArray, int n, double d) {
        long l = Double.doubleToLongBits(d);
        byArray[n + 7] = (byte)(l >>> 0);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 0] = (byte)(l >>> 56);
    }
}

