/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DHPrivateKey;
import com.sun.crypto.provider.DHPublicKey;
import com.sun.crypto.provider.SunJCE;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import sun.security.provider.ParameterCache;

public final class DHKeyPairGenerator
extends KeyPairGeneratorSpi {
    private DHParameterSpec a;
    private int b;
    private int c;
    private SecureRandom d;

    public DHKeyPairGenerator() {
        this.initialize(1024, null);
    }

    public void initialize(int n, SecureRandom secureRandom) {
        if (n < 512 || n > 1024 || n % 64 != 0) {
            throw new InvalidParameterException("Keysize must be multiple of 64, and can only range from 512 to 1024 (inclusive)");
        }
        this.b = n;
        this.c = 0;
        this.d = secureRandom;
        this.a = null;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
        }
        this.a = (DHParameterSpec)algorithmParameterSpec;
        this.b = this.a.getP().bitLength();
        if (this.b < 512 || this.b > 1024 || this.b % 64 != 0) {
            throw new InvalidAlgorithmParameterException("Prime size must be multiple of 64, and can only range from 512 to 1024 (inclusive)");
        }
        this.c = this.a.getL();
        if (this.c != 0 && this.c > this.b) {
            throw new InvalidAlgorithmParameterException("Exponent value must be less than (modulus value -1)");
        }
        this.d = secureRandom;
    }

    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        if (this.d == null) {
            this.d = SunJCE.h;
        }
        if (this.c <= 0) {
            bigInteger3 = new BigInteger(this.b - 1, this.d).add(BigInteger.ONE);
            this.c = bigInteger3.bitLength();
        } else {
            bigInteger3 = new BigInteger(this.c, this.d).setBit(this.c - 1);
        }
        if (this.c == this.b) {
            bigInteger2 = this.a.getP();
            bigInteger = bigInteger2.subtract(BigInteger.ONE);
            while (bigInteger3.compareTo(bigInteger) != -1) {
                bigInteger3 = new BigInteger(this.c, this.d).setBit(this.c - 1);
            }
        }
        if (this.a == null) {
            try {
                this.a = ParameterCache.getDHParameterSpec(this.b, this.d);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new ProviderException(generalSecurityException);
            }
        }
        bigInteger2 = this.a.getP();
        bigInteger = this.a.getG();
        BigInteger bigInteger4 = bigInteger.modPow(bigInteger3, bigInteger2);
        DHPublicKey dHPublicKey = new DHPublicKey(bigInteger4, bigInteger2, bigInteger, this.c);
        DHPrivateKey dHPrivateKey = new DHPrivateKey(bigInteger3, bigInteger2, bigInteger, this.c);
        return new KeyPair(dHPublicKey, dHPrivateKey);
    }
}

